/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import gov.nih.nlm.nls.lexAccess.Api.LexAccessApi;
import gov.nih.nlm.nls.lexAccess.Api.LexAccessApiResult;
import gov.nih.nlm.nls.lexCheck.Lib.AdjEntry;
import gov.nih.nlm.nls.lexCheck.Lib.AdvEntry;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.NounEntry;
import gov.nih.nlm.nls.lexCheck.Lib.VerbEntry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import simplenlg.features.Inflection;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIHDBLexicon
extends Lexicon {
    private static String DB_HSQL_DRIVER = "org.hsqldb.jdbc.JDBCDriver";
    private static String DB_HQSL_JDBC = "jdbc:hsqldb:";
    private static String DB_DEFAULT_USERNAME = "sa";
    private static String DB_DEFAULT_PASSWORD = "";
    private static String DB_HSQL_EXTENSION = ".data";
    private Connection conn = null;
    private LexAccessApi lexdb = null;
    private boolean keepStandardInflections = false;

    public NIHDBLexicon(String filename) {
        String dbfilename = filename;
        if (dbfilename.endsWith(DB_HSQL_EXTENSION)) {
            dbfilename = dbfilename.substring(0, dbfilename.length() - DB_HSQL_EXTENSION.length());
        }
        try {
            Class.forName(DB_HSQL_DRIVER);
            this.conn = DriverManager.getConnection(DB_HQSL_JDBC + dbfilename, DB_DEFAULT_USERNAME, DB_DEFAULT_PASSWORD);
            this.lexdb = new LexAccessApi(this.conn);
        }
        catch (Exception ex) {
            System.out.println("Cannot open lexical db: " + ex.toString());
        }
    }

    public NIHDBLexicon(String driver, String url, String username, String password) {
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(url, username, password);
            this.lexdb = new LexAccessApi(this.conn);
        }
        catch (Exception ex) {
            System.out.println("Cannot open lexical db: " + ex.toString());
        }
    }

    public boolean isKeepStandardInflections() {
        return this.keepStandardInflections;
    }

    public void setKeepStandardInflections(boolean keepStandardInflections) {
        this.keepStandardInflections = keepStandardInflections;
    }

    @Override
    public synchronized List<WordElement> getWords(String baseForm, LexicalCategory category) {
        try {
            LexAccessApiResult lexResult = this.lexdb.GetLexRecordsByBase(baseForm, 4);
            return this.getWordsFromLexResult(category, lexResult);
        }
        catch (SQLException ex) {
            System.out.println("Lexical DB error: " + ex.toString());
            return null;
        }
    }

    @Override
    public synchronized List<WordElement> getWordsByID(String id) {
        try {
            LexAccessApiResult lexResult = this.lexdb.GetLexRecords(id);
            return this.getWordsFromLexResult(LexicalCategory.ANY, lexResult);
        }
        catch (SQLException ex) {
            System.out.println("Lexical DB error: " + ex.toString());
            return null;
        }
    }

    @Override
    public synchronized List<WordElement> getWordsFromVariant(String variant, LexicalCategory category) {
        try {
            LexAccessApiResult lexResult = this.lexdb.GetLexRecords(variant);
            return this.getWordsFromLexResult(category, lexResult);
        }
        catch (SQLException ex) {
            System.out.println("Lexical DB error: " + ex.toString());
            return null;
        }
    }

    @Override
    public void close() {
        if (this.lexdb != null) {
            this.lexdb.CleanUp();
        }
    }

    private WordElement makeWord(LexRecord record) {
        String baseForm = record.GetBase();
        LexicalCategory category = this.getSimplenlgCategory(record);
        String id = record.GetEui();
        WordElement wordElement = new WordElement(baseForm, category, id);
        switch (category) {
            case ADJECTIVE: {
                this.addAdjectiveInfo(wordElement, record.GetCatEntry().GetAdjEntry());
                break;
            }
            case ADVERB: {
                this.addAdverbInfo(wordElement, record.GetCatEntry().GetAdvEntry());
                break;
            }
            case NOUN: {
                this.addNounInfo(wordElement, record.GetCatEntry().GetNounEntry());
                break;
            }
            case VERB: {
                this.addVerbInfo(wordElement, record.GetCatEntry().GetVerbEntry());
            }
        }
        Inflection defaultInfl = (Inflection)((Object)wordElement.getDefaultInflectionalVariant());
        for (InflVar inflection : record.GetInflVarsAndAgreements().GetInflValues()) {
            String simplenlgInflection = this.getSimplenlgInflection(inflection.GetInflection());
            if (simplenlgInflection == null) continue;
            String inflectedForm = inflection.GetVar();
            Inflection inflType = Inflection.getInflCode(inflection.GetType());
            if (inflType != null && (!Inflection.REGULAR.equals((Object)inflType) || this.keepStandardInflections)) {
                wordElement.addInflectionalVariant(inflType, simplenlgInflection, inflectedForm);
            }
            if (defaultInfl != null && (!defaultInfl.equals((Object)inflType) || Inflection.REGULAR.equals((Object)inflType) && !this.keepStandardInflections)) continue;
            wordElement.setFeature(simplenlgInflection, inflectedForm);
        }
        this.addAcronymInfo(wordElement, record);
        this.addSpellingVariants(wordElement, record);
        return wordElement;
    }

    private List<WordElement> getWordsFromLexResult(LexicalCategory category, LexAccessApiResult lexResult) {
        Vector records = lexResult.GetJavaObjs();
        ArrayList<WordElement> wordElements = new ArrayList<WordElement>();
        for (LexRecord record : records) {
            if (category != LexicalCategory.ANY && category != this.getSimplenlgCategory(record)) continue;
            wordElements.add(this.makeWord(record));
        }
        return wordElements;
    }

    private boolean standardInflections(LexRecord record, LexicalCategory category) {
        Vector variants = null;
        switch (category) {
            case NOUN: {
                variants = record.GetCatEntry().GetNounEntry().GetVariants();
                break;
            }
            case ADJECTIVE: {
                variants = record.GetCatEntry().GetAdjEntry().GetVariants();
                break;
            }
            case ADVERB: {
                variants = record.GetCatEntry().GetAdvEntry().GetVariants();
                break;
            }
            case MODAL: {
                variants = record.GetCatEntry().GetModalEntry().GetVariant();
                break;
            }
            case VERB: {
                if (record.GetCatEntry().GetVerbEntry() == null) break;
                variants = record.GetCatEntry().GetVerbEntry().GetVariants();
            }
        }
        return this.notEmpty(variants) && variants.contains("reg");
    }

    private LexicalCategory getSimplenlgCategory(LexRecord record) {
        String cat = record.GetCategory();
        if (cat == null) {
            return LexicalCategory.ANY;
        }
        if (cat.equalsIgnoreCase("noun")) {
            return LexicalCategory.NOUN;
        }
        if (cat.equalsIgnoreCase("verb")) {
            return LexicalCategory.VERB;
        }
        if (cat.equalsIgnoreCase("aux") && record.GetBase().equalsIgnoreCase("be")) {
            return LexicalCategory.VERB;
        }
        if (cat.equalsIgnoreCase("adj")) {
            return LexicalCategory.ADJECTIVE;
        }
        if (cat.equalsIgnoreCase("adv")) {
            return LexicalCategory.ADVERB;
        }
        if (cat.equalsIgnoreCase("pron")) {
            return LexicalCategory.PRONOUN;
        }
        if (cat.equalsIgnoreCase("det")) {
            return LexicalCategory.DETERMINER;
        }
        if (cat.equalsIgnoreCase("prep")) {
            return LexicalCategory.PREPOSITION;
        }
        if (cat.equalsIgnoreCase("conj")) {
            return LexicalCategory.CONJUNCTION;
        }
        if (cat.equalsIgnoreCase("compl")) {
            return LexicalCategory.COMPLEMENTISER;
        }
        if (cat.equalsIgnoreCase("modal")) {
            return LexicalCategory.MODAL;
        }
        return LexicalCategory.ANY;
    }

    private String getSimplenlgInflection(String NIHInflection) {
        if (NIHInflection == null) {
            return null;
        }
        if (NIHInflection.equalsIgnoreCase("comparative")) {
            return "comparative";
        }
        if (NIHInflection.equalsIgnoreCase("superlative")) {
            return "superlative";
        }
        if (NIHInflection.equalsIgnoreCase("plural")) {
            return "plural";
        }
        if (NIHInflection.equalsIgnoreCase("pres3s")) {
            return "present3s";
        }
        if (NIHInflection.equalsIgnoreCase("past")) {
            return "past";
        }
        if (NIHInflection.equalsIgnoreCase("pastPart")) {
            return "pastParticiple";
        }
        if (NIHInflection.equalsIgnoreCase("presPart")) {
            return "presentParticiple";
        }
        return null;
    }

    private void addAdjectiveInfo(WordElement wordElement, AdjEntry adjEntry) {
        boolean qualitativeAdj = false;
        boolean colourAdj = false;
        boolean classifyingAdj = false;
        boolean predicativeAdj = false;
        Vector positions = adjEntry.GetPosition();
        for (String position : positions) {
            if (position.startsWith("attrib(1)")) {
                qualitativeAdj = true;
                continue;
            }
            if (position.startsWith("attrib(2)")) {
                colourAdj = true;
                continue;
            }
            if (position.startsWith("attrib(3)")) {
                classifyingAdj = true;
                continue;
            }
            if (!position.startsWith("pred")) continue;
            predicativeAdj = true;
        }
        wordElement.setFeature("qualitative", qualitativeAdj);
        wordElement.setFeature("colour", colourAdj);
        wordElement.setFeature("classifying", classifyingAdj);
        wordElement.setFeature("predicative", predicativeAdj);
    }

    private void addAdverbInfo(WordElement wordElement, AdvEntry advEntry) {
        boolean verbModifier = false;
        boolean sentenceModifier = false;
        boolean intensifier = false;
        Vector modifications = advEntry.GetModification();
        for (String modification : modifications) {
            if (modification.startsWith("verb_modifier")) {
                verbModifier = true;
                continue;
            }
            if (modification.startsWith("sentence_modifier")) {
                sentenceModifier = true;
                continue;
            }
            if (!modification.startsWith("intensifier")) continue;
            intensifier = true;
        }
        wordElement.setFeature("verb_modifier", verbModifier);
        wordElement.setFeature("sentence_modifier", sentenceModifier);
        wordElement.setFeature("intensifier", intensifier);
    }

    private void addNounInfo(WordElement wordElement, NounEntry nounEntry) {
        boolean proper = nounEntry.IsProper();
        Vector variants = nounEntry.GetVariants();
        if (!variants.isEmpty()) {
            ArrayList<Inflection> wordVariants = new ArrayList<Inflection>();
            for (String v : variants) {
                int index = v.indexOf("|");
                String code = index > -1 ? v.substring(0, index).toLowerCase().trim() : v.toLowerCase().trim();
                Inflection infl = Inflection.getInflCode(code);
                if (infl == null) continue;
                wordVariants.add(infl);
                wordElement.addInflectionalVariant(infl);
            }
            Inflection defaultVariant = wordVariants.contains((Object)Inflection.REGULAR) || wordVariants.isEmpty() ? Inflection.REGULAR : (Inflection)((Object)wordVariants.get(0));
            wordElement.setFeature("default_infl", (Object)defaultVariant);
            wordElement.setDefaultInflectionalVariant(defaultVariant);
        }
        wordElement.setFeature("proper", proper);
    }

    private void addVerbInfo(WordElement wordElement, VerbEntry verbEntry) {
        if (verbEntry == null) {
            wordElement.setFeature("intransitive", false);
            wordElement.setFeature("transitive", true);
            wordElement.setFeature("ditransitive", false);
            return;
        }
        boolean intransitiveVerb = this.notEmpty(verbEntry.GetIntran());
        boolean transitiveVerb = this.notEmpty(verbEntry.GetTran()) || this.notEmpty(verbEntry.GetCplxtran());
        boolean ditransitiveVerb = this.notEmpty(verbEntry.GetDitran());
        wordElement.setFeature("intransitive", intransitiveVerb);
        wordElement.setFeature("transitive", transitiveVerb);
        wordElement.setFeature("ditransitive", ditransitiveVerb);
        Vector variants = verbEntry.GetVariants();
        if (!variants.isEmpty()) {
            ArrayList<Inflection> wordVariants = new ArrayList<Inflection>();
            for (String v : variants) {
                Inflection infl;
                int index = v.indexOf("|");
                if (index > -1) {
                    String code = v.substring(0, index).toLowerCase().trim();
                    infl = Inflection.getInflCode(code);
                } else {
                    infl = Inflection.getInflCode(v.toLowerCase().trim());
                }
                if (infl == null) continue;
                wordElement.addInflectionalVariant(infl);
                wordVariants.add(infl);
            }
            Inflection defaultVariant = wordVariants.contains((Object)Inflection.REGULAR) || wordVariants.isEmpty() ? Inflection.REGULAR : (Inflection)((Object)wordVariants.get(0));
            wordElement.setDefaultInflectionalVariant(defaultVariant);
        }
    }

    private boolean notEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private void addAcronymInfo(WordElement wordElement, LexRecord record) {
        Vector acronyms = record.GetAcronyms();
        if (!acronyms.isEmpty()) {
            List<NLGElement> acronymOf = wordElement.getFeatureAsElementList("acronym_of");
            for (String fullForm : acronyms) {
                if (!fullForm.contains("|")) continue;
                String acronymID = fullForm.substring(fullForm.indexOf("|") + 1, fullForm.length());
                WordElement fullFormWE = this.getWordByID(acronymID);
                if (fullForm == null) continue;
                acronymOf.add(fullFormWE);
            }
            wordElement.setFeature("acronym_of", acronymOf);
        }
    }

    private void addSpellingVariants(WordElement wordElement, LexRecord record) {
        Vector vars = record.GetSpellingVars();
        if (vars != null && !vars.isEmpty()) {
            ArrayList wordVars = new ArrayList();
            wordVars.addAll(vars);
            wordElement.setFeature("spell_vars", wordVars);
        }
        wordElement.setFeature("default_spell", wordElement.getBaseForm());
    }
}

