/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.client;

import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.visualization.recommender.schema.VisRecommenderRequest;
import com.ibm.smarts.visualization.recommender.schema.VisRecommenderResponse;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaVisRecommenderClient
extends CaRestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaVisRecommenderClient.class);
    public static final String SMARTSMODULE = "/bi/v1/smarts/module/%s";

    public CaVisRecommenderClient(RequestContext requestContext, Properties config) {
        super((RestClient.RestCallContextFactory)requestContext.getAttribute("com.ibm.smarts.rest.restCallContextFactory"), requestContext, config.getProperty("smarts.ca.core.caServer.url"));
    }

    public CaVisRecommenderClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CaVisRecommenderClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        super(rccf, requestContext, uri, headers);
    }

    public String getSmartsModule(String moduleId) {
        try {
            return (String)this.get(this.getSmartsModuleAsync(moduleId));
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving smarts module", (Throwable)e);
            return "";
        }
    }

    public VisRecommenderResponse recommend(VisRecommenderRequest request) {
        try {
            return this.recommendAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public CompletableFuture<VisRecommenderResponse> recommendAsync(VisRecommenderRequest request) {
        String path = Paths.recommendPath();
        return this.recommendAsync(path, request.toJSON()).thenApply(VisRecommenderResponse::fromJSON);
    }

    private CompletableFuture<String> recommendAsync(String path, String request) {
        return this.postAsync(path, request);
    }

    public CompletableFuture<String> getSmartsModuleAsync(String moduleId) {
        Ensure.nonBlank((String[])new String[]{moduleId});
        return this.getAsync(String.format(SMARTSMODULE, moduleId));
    }

    private static class Paths {
        private static final String VISRECOMMENDER = "/bi/v1/smarts/visualization-recommender";
        private static final String RECOMMEND = "/bi/v1/smarts/visualization-recommender/recommend";

        private Paths() {
        }

        public static String recommendPath() {
            return RECOMMEND;
        }
    }
}

