/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import java.util.Locale;

public class ModuleDataTypeUtil {
    private static final String DT_SHORT = "SHORT";
    private static final String DT_BYTE = "BYTE";
    private static final String DT_LONG = "LONG";
    private static final String MAX = "MAX";
    private static final String QUALIFIER = "(";
    private static final String COMMA = ",";

    private ModuleDataTypeUtil() {
    }

    public static DataType createDataType(String type) {
        String datatype;
        if (type == null || type.isEmpty()) {
            return DataTypes.getUnknownType();
        }
        switch (datatype = type.toUpperCase(Locale.ENGLISH)) {
            case "LONG": {
                return DataTypes.getLongType();
            }
            case "BYTE": {
                return DataTypes.getByteType();
            }
            case "SHORT": {
                return DataTypes.getShortType();
            }
            case "INTEGER": 
            case "SMALLINT": 
            case "TINYINT": 
            case "BIT": {
                return DataTypes.getIntegerType();
            }
            case "BIGINT": {
                return DataTypes.getLongType();
            }
            case "REAL": 
            case "FLOAT": {
                return DataTypes.getFloatType();
            }
            case "DOUBLE": {
                return DataTypes.getDoubleType();
            }
            case "BOOLEAN": {
                return DataTypes.getBooleanType();
            }
            case "DATE": {
                return DataTypes.getDateType();
            }
            case "TIME": 
            case "TIME_TZ": {
                return DataTypes.getTimeType();
            }
            case "TIMESTAMP": 
            case "TIMESTAMP_TZ": {
                return DataTypes.getTimestampType();
            }
            case "CHAR": 
            case "VARCHAR": 
            case "LONGVARCHAR": 
            case "NCHAR": 
            case "LONGVARBINARY": 
            case "NVARCHAR": 
            case "LONGNVARCHAR": {
                return DataTypes.getStringType((int)Integer.MAX_VALUE);
            }
            case "DECIMAL": 
            case "NUMERIC": {
                return DataTypes.getDecimalType();
            }
        }
        if (ModuleDataTypeUtil.isQualified(datatype)) {
            if (datatype.contains("CHAR") || datatype.contains("LONGVARBINARY")) {
                return DataTypes.getStringType((int)Integer.MAX_VALUE);
            }
            if (datatype.contains("NUMERIC") || datatype.contains("DECIMAL")) {
                return DataTypes.getDecimalType();
            }
        }
        return DataTypes.getUnknownType();
    }

    private static boolean isQualified(String dataType) {
        return dataType.indexOf(QUALIFIER) != -1;
    }
}

