/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.api.query;

import com.ibm.smarts.core.exceptions.InternalException;
import java.util.Arrays;
import java.util.List;

public class StoreStatus {
    private final boolean success;
    private final List<InternalException> errors;
    private String resourceURI = null;

    public StoreStatus() {
        this((List<InternalException>)null);
    }

    public StoreStatus(InternalException error) {
        this(Arrays.asList(error));
    }

    public StoreStatus(List<InternalException> errors) {
        this(errors == null || errors.isEmpty(), errors);
    }

    public StoreStatus(boolean success, List<InternalException> errors) {
        this.success = success;
        this.errors = errors;
    }

    public StoreStatus(boolean success, List<InternalException> errors, String resource) {
        this.success = success;
        this.errors = errors;
        this.resourceURI = resource;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<InternalException> getErrors() {
        return this.errors;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[StoreStatus");
        sb.append(" success=" + this.success);
        if (this.errors != null && !this.errors.isEmpty()) {
            sb.append(" errors=[");
            for (InternalException ex : this.errors) {
                sb.append("[" + ex + "]");
            }
            sb.append("]");
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }
}

