/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.i18n;

import com.ibm.smarts.core.i18n.PseudoTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private String[] nlSuffixes;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final Object ASSIGNED = new Object();
    private static PseudoTranslator pseudoTranslator = null;
    private final List<Message> allMessages = new ArrayList<Message>();
    private final List<Message> missingMessages = new ArrayList<Message>();
    public final String resourcePath;
    private String loadedFromPath;
    private static final Logger LOGGER = LoggerFactory.getLogger(NLS.class);
    private static final Map<Object, Map<String, Object>> instanceCache = new HashMap<Object, Map<String, Object>>();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[NLS");
        sb.append(" resource=" + this.resourcePath);
        if (!this.resourcePath.equals(this.loadedFromPath) && this.loadedFromPath != null) {
            sb.append(" loadedFrom=" + this.loadedFromPath);
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public static void setPseudoTranslator(PseudoTranslator pt) {
        pseudoTranslator = pt;
    }

    private static NLS findInCache(Object clazz, String locale) {
        NLS ret = null;
        Map<String, Object> localeMap = instanceCache.get(clazz);
        if (localeMap != null) {
            ret = (NLS)localeMap.get(locale);
        }
        return ret;
    }

    private static void putIntoCache(NLS instance, Object clazz, String locale) {
        Map<String, Object> localeMap = instanceCache.get(clazz);
        if (localeMap == null) {
            localeMap = new HashMap<String, Object>();
            instanceCache.put(clazz, localeMap);
        }
        localeMap.put(locale, instance);
    }

    protected NLS(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public static <T extends NLS> T get(Class<?> clazz, String locale) {
        NLS ret = NLS.findInCache(clazz, locale);
        if (ret == null) {
            NLS instance = null;
            try {
                instance = (NLS)clazz.newInstance();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to create instance of class " + clazz.getCanonicalName(), e);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to create instance of class " + clazz.getCanonicalName(), e);
            }
            if (instance != null) {
                NLS.initializeMessages(instance, locale);
                NLS.putIntoCache(instance, clazz, locale);
                ret = instance;
            }
        }
        return (T)ret;
    }

    public List<Message> missingMessages() {
        return this.missingMessages;
    }

    public List<Message> allMessages() {
        return this.allMessages;
    }

    public Map<String, String> messageMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Message message : this.allMessages()) {
            ret.put(message.name, message.text);
        }
        return ret;
    }

    public String pseudoTranslate(String s) {
        if (pseudoTranslator == null) {
            return s;
        }
        return pseudoTranslator.translate(s);
    }

    public static String bind(String message, Object binding) {
        return NLS.internalBind(message, null, String.valueOf(binding), null);
    }

    public static String bind(String message, Object binding1, Object binding2) {
        return NLS.internalBind(message, null, String.valueOf(binding1), String.valueOf(binding2));
    }

    public static String bind(String message, Object[] bindings) {
        return NLS.internalBind(message, bindings, null, null);
    }

    public static void initializeMessages(final NLS instance, final String locale) {
        if (System.getSecurityManager() == null) {
            NLS.load(instance, locale);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NLS.load(instance, locale);
                return null;
            }
        });
    }

    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuffer buffer = new StringBuffer(bufLen < 0 ? 0 : bufLen);
        block5: for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        continue block5;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        continue block5;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                    }
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument" + number + ">");
                            i = index;
                            continue block5;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private static String[] buildVariants(NLS instance, String root, String nl) {
        return NLS.buildVariants_subFolders(instance, root, nl);
    }

    private static String[] buildVariants_subFolders(NLS instance, String root, String nl) {
        if (instance.nlSuffixes == null) {
            String filename;
            String folder;
            int lastSlash = root.lastIndexOf(47);
            if (lastSlash == -1) {
                folder = "";
                filename = root + EXTENSION;
            } else {
                folder = root.substring(0, lastSlash + 1);
                filename = root.substring(lastSlash + 1) + EXTENSION;
            }
            ArrayList<String> result = new ArrayList<String>(4);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) {
                lastSeparator = nl.lastIndexOf(45);
            }
            if (lastSeparator == -1) {
                result.add(folder + nl + "/" + filename);
            } else {
                String lang = nl.substring(0, lastSeparator);
                String locale = nl.substring(lastSeparator + 1);
                result.add(folder + lang + "_" + locale + "/" + filename);
                result.add(folder + lang + "-" + locale + "/" + filename);
                result.add(folder + lang + "/" + filename);
            }
            result.add(folder + filename);
            instance.nlSuffixes = result.toArray(new String[result.size()]);
        }
        String[] variants = new String[instance.nlSuffixes.length];
        for (int i = 0; i < variants.length; ++i) {
            variants[i] = instance.nlSuffixes[i];
        }
        return variants;
    }

    private static void computeMissingMessages(NLS nls, String resourcePath, Class<?> clazz, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int MOD_EXPECTED = 17;
        for (Field field : fieldArray) {
            int modifiers;
            int maskedModifiers;
            Class<?> fieldType = field.getType();
            if (fieldType != Message.class || (maskedModifiers = (modifiers = field.getModifiers()) & 0x11) != 17 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "NLS message not in props: '" + field.getName() + "' in: " + resourcePath;
                LOGGER.warn(value);
                boolean wasAccessible = field.isAccessible();
                field.setAccessible(true);
                Message message = new Message(nls, field.getName(), value);
                field.set(nls, message);
                field.setAccessible(wasAccessible);
                nls.missingMessages.add(message);
                nls.allMessages.add(message);
            }
            catch (Exception e) {
                LOGGER.error("Error setting the missing message value for: " + field.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(NLS instance, String locale) {
        Class<?> clazz = instance.getClass();
        String resourcePath = instance.resourcePath;
        Field[] fieldArray = clazz.getDeclaredFields();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
        }
        boolean loadedMessages = false;
        String[] variants = NLS.buildVariants(instance, resourcePath, locale);
        int loadAttempt = 0;
        String firstVariant = null;
        for (int i = 0; i < variants.length; ++i) {
            String variant = variants[i];
            InputStream input = clazz.getResourceAsStream(variant);
            if (input == null) continue;
            if (firstVariant == null) {
                firstVariant = variant;
            }
            loadedMessages = true;
            if (instance.loadedFromPath == null) {
                instance.loadedFromPath = variants[i];
            }
            try {
                MessagesProperties properties = new MessagesProperties(++loadAttempt, instance, fields, firstVariant, variant, isAccessible);
                properties.load(input);
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Error loading " + variants[i], (Throwable)e);
                continue;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!loadedMessages) {
            LOGGER.error("Could not find messages for class " + clazz.getCanonicalName() + " messages-file-path=" + resourcePath + " files-looked-for=" + NLS.toString(variants));
        }
        NLS.computeMissingMessages(instance, resourcePath, clazz, fields, fieldArray, isAccessible);
        Collections.sort(instance.allMessages, Message.getNameComparator());
    }

    private static String toString(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(strings[i]);
        }
        String ret = sb.toString();
        return ret;
    }

    private static class MessagesProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final String firstVariant;
        private final String currentVariant;
        private final NLS outer;
        private final int loadAttempt;
        private final Map<Object, Object> fields;

        public MessagesProperties(int loadAttempt, NLS outer, Map<Object, Object> fieldMap, String firstVariant, String currentVariant, boolean isAccessible) {
            this.loadAttempt = loadAttempt;
            this.outer = outer;
            this.fields = fieldMap;
            this.firstVariant = firstVariant;
            this.currentVariant = currentVariant;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS message in props, but not in class: '" + key + "' in: " + this.firstVariant;
                LOGGER.warn(msg);
                return null;
            }
            Field field = (Field)fieldObject;
            try {
                if (this.loadAttempt > 1) {
                    LOGGER.warn("NLS message missing from language props: '" + key + "' is in: " + this.currentVariant + " but missing from " + this.firstVariant);
                }
                boolean wasAccessible = field.isAccessible();
                field.setAccessible(true);
                String newValue = new String(((String)value).toCharArray());
                Message message = new Message(this.outer, (String)key, newValue);
                field.set(this.outer, message);
                field.setAccessible(wasAccessible);
                this.outer.allMessages.add(message);
            }
            catch (Exception e) {
                LOGGER.error("Exception setting field value.", (Throwable)e);
            }
            return null;
        }
    }

    public static class Message {
        public final NLS nls;
        public final String name;
        public final String text;

        public Message(NLS nls, String name, String text) {
            this.nls = nls;
            this.name = name;
            this.text = text;
        }

        public String bind() {
            String ret = this.nls.pseudoTranslate(this.text);
            return ret;
        }

        public String bind(Object binding) {
            String ret = this.nls.pseudoTranslate(NLS.bind(this.text, binding));
            return ret;
        }

        public String bind(Object binding1, Object binding2) {
            String ret = this.nls.pseudoTranslate(NLS.bind(this.text, binding1, binding2));
            return ret;
        }

        public String bind(Object[] bindings) {
            String ret = this.nls.pseudoTranslate(NLS.bind(this.text, bindings));
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[NLS.Message");
            sb.append(" name=" + this.name);
            sb.append(" text='" + this.text + "'");
            sb.append(" resource=" + this.nls.resourcePath);
            if (!this.nls.resourcePath.equals(this.nls.loadedFromPath) && this.nls.loadedFromPath != null) {
                sb.append(" loadedFrom=" + this.nls.loadedFromPath);
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        public static Comparator<Message> getNameComparator() {
            return new Comparator<Message>(){

                @Override
                public int compare(Message o1, Message o2) {
                    return o1.name.compareTo(o2.name);
                }
            };
        }
    }
}

