/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.util.AbstractMetrics;
import com.ibm.smarts.core.util.MetricsHelper;
import com.ibm.smarts.core.util.OperationMetrics;
import com.ibm.smarts.core.util.RestMetrics;
import com.ibm.smarts.core.util.StoreMetrics;
import java.util.concurrent.atomic.AtomicLong;

public class RequestMetrics
extends AbstractMetrics<RequestMetrics> {
    private static final AtomicLong instanceCounter = new AtomicLong();
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final AsyncMetrics asyncMetrics;
    public final StoreMetrics storeMetrics;
    public final RestMetrics restMetrics;
    public final OperationMetrics opMetrics;
    private String label = null;

    public RequestMetrics() {
        this(new AsyncMetrics(), new StoreMetrics(), new RestMetrics(), new OperationMetrics());
    }

    private RequestMetrics(AsyncMetrics asyncMetrics, StoreMetrics storeMetrics, RestMetrics restMetrics, OperationMetrics opMetrics) {
        this.asyncMetrics = asyncMetrics;
        this.storeMetrics = storeMetrics;
        this.restMetrics = restMetrics;
        this.opMetrics = opMetrics;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    @Override
    public boolean isTouched() {
        return RequestMetrics.isTouched((AbstractMetrics[])new AbstractMetrics[]{this.asyncMetrics, this.storeMetrics, this.restMetrics, this.opMetrics});
    }

    @Override
    public long firstTouchNanos() {
        return RequestMetrics.firstTouchNanos((AbstractMetrics[])new AbstractMetrics[]{this.asyncMetrics, this.storeMetrics, this.restMetrics, this.opMetrics});
    }

    @Override
    public long lastTouchNanos() {
        return RequestMetrics.lastTouchNanos((AbstractMetrics[])new AbstractMetrics[]{this.asyncMetrics, this.storeMetrics, this.restMetrics, this.opMetrics});
    }

    @Override
    public String toString(boolean pretty, int indent) {
        long durationNanos = this.activeDurationNanos();
        if (durationNanos == 0L) {
            long l = this.activeDurationNanos();
        }
        String durationStr = MetricsHelper.stringForNanosToMillis(durationNanos);
        StringBuilder sb = new StringBuilder();
        sb.append("[RequestMetrics #" + this.instanceNumber);
        sb.append(" durationMs=" + durationStr);
        if (this.label != null) {
            sb.append(" label='" + this.label + "'");
        }
        if (this.asyncMetrics.isTouched()) {
            sb.append(RequestMetrics.linePrefix(pretty, indent + 1) + "asyncMetrics=" + this.asyncMetrics.toString(pretty, indent + 2));
        }
        if (this.storeMetrics.isTouched()) {
            sb.append(RequestMetrics.linePrefix(pretty, indent + 1) + "storeMetrics=" + this.storeMetrics.toString(pretty, indent + 2));
        }
        if (this.restMetrics.isTouched()) {
            sb.append(RequestMetrics.linePrefix(pretty, indent + 1) + "restMetrics=" + this.restMetrics.toString(pretty, indent + 2));
        }
        if (this.opMetrics.isTouched()) {
            sb.append(RequestMetrics.linePrefix(pretty, indent + 1) + "opMetrics=" + this.opMetrics.toString(pretty, indent + 2));
        }
        sb.append("]");
        return sb.toString();
    }

    public RequestMetrics combine(RequestMetrics other) {
        return new RequestMetrics(this.asyncMetrics.combine(other.asyncMetrics), this.storeMetrics.combine(other.storeMetrics), this.restMetrics.combine(other.restMetrics), this.opMetrics.combine(other.opMetrics));
    }
}

