/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import java.util.List;

public final class StringUtils {
    static final String MSG_NULL_PARAM = "null parameter";
    static final String MSG_UNABLE_TO_CONVERT = "Unable to convert string to UTF-8 byte array";
    static final String MSG_ZERO_SEARCH_STRING = "Cannot have a zero-length search string";
    static final String MSG_ZERO_REPLACE_STRING = "Cannot have a zero-length replacement string";
    static final int SPLIT_DEFAULT_ARRAY_SIZE = 50;
    static final String MSG_NULL_MAIN_STRING = "<null> main string parameter";
    static final String MSG_NULL_DELIMITER_STRING = "<null> delimiter parameter";
    static final String MSG_ZERO_LENGTH_DELIMITER = "zero-length delimiter parameter";
    static final String MSG_NULL_REPLACEMENT_MAP = "<null> replacement map";
    static final String MSG_MISSING_END_DELIMITER = "missing end-delimiter";
    static final String MSG_VARIABLE_NOT_IN_MAP = "variable is not in map";
    public static final String DEFAULT_START_MARKER = "${";
    public static final String DEFAULT_END_MARKER = "}";
    public static final String JOIN_DEFAULT_SEPARATOR = ", ";
    public static final boolean JOIN_IGNORE_NULLS = true;
    public static final boolean JOIN_DONT_IGNORE_NULLS = false;
    public static final boolean JOIN_DEFAULT_IGNORE_NULLS = false;
    public static final String JOIN_NULL_STRING = "[null]";
    private static final String TRIM_TRAILER = "...";
    private static final int TRIM_TRAILER_LEN = "...".length();

    public static byte[] String2UTF8ByteArray(String sStringToBeConverted) {
        byte[] baRet = null;
        try {
            baRet = sStringToBeConverted.getBytes("UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(MSG_UNABLE_TO_CONVERT, ex);
        }
        return baRet;
    }

    public static String join(List<? extends Object> vObjects) {
        return StringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, false);
    }

    public static String join(List<? extends Object> vObjects, String sSeparator) {
        return StringUtils.join(vObjects, sSeparator, false);
    }

    public static String join(List<? extends Object> vObjects, boolean bIgnoreNulls) {
        return StringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, bIgnoreNulls);
    }

    public static String join(List<? extends Object> vObjects, String sSeparator, boolean bIgnoreNulls) {
        Object[] v = vObjects.toArray();
        return StringUtils.join(v, sSeparator, bIgnoreNulls);
    }

    public static String join(Object[] vObjects) {
        return StringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, false);
    }

    public static String join(Object[] vObjects, String sSeparator) {
        return StringUtils.join(vObjects, sSeparator, false);
    }

    public static String join(Object[] vObjects, boolean bIgnoreNulls) {
        return StringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, bIgnoreNulls);
    }

    public static String join(Object[] vObjects, String sSeparator, boolean bIgnoreNulls) {
        String sRet = null;
        StringBuffer sb = new StringBuffer(2000);
        boolean bDidOne = false;
        for (int i = 0; i < vObjects.length; ++i) {
            Object objToWrite = vObjects[i];
            boolean bWriteIt = true;
            String sStr = null;
            if (objToWrite == null && bIgnoreNulls) {
                bWriteIt = false;
            }
            if (!bWriteIt) continue;
            sStr = objToWrite == null ? JOIN_NULL_STRING : objToWrite.toString();
            if (bDidOne) {
                sb.append(sSeparator);
            } else {
                bDidOne = true;
            }
            sb.append(sStr);
        }
        sRet = sb.toString();
        return sRet;
    }

    public static String trim(String sOriginal, int nMaxLen) {
        String sRet = sOriginal;
        try {
            try {
                if (sOriginal.length() > nMaxLen) {
                    StringBuffer sb = new StringBuffer(nMaxLen);
                    int nNewLen = nMaxLen - TRIM_TRAILER_LEN;
                    if (nNewLen >= 0) {
                        sb.append(sOriginal.substring(0, nMaxLen - TRIM_TRAILER_LEN));
                        sb.append(TRIM_TRAILER);
                    }
                    if ((sRet = sb.toString()).length() > nMaxLen) {
                        sRet = sRet.substring(0, nMaxLen);
                    }
                }
            }
            catch (NullPointerException nex) {
                throw new RuntimeException(MSG_NULL_MAIN_STRING, nex);
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("trimming string", ex);
        }
        return sRet;
    }
}

