/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.exceptions.InternalException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipToFolderHelper {
    private String destFolder;

    public UnzipToFolderHelper(String destFolder) {
        this.destFolder = destFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(InputStream is) {
        byte[] buffer = new byte[8096];
        File folder = new File(this.destFolder);
        if (!folder.exists()) {
            throw new InternalException("Unzip folder does not exist: " + this.destFolder, new Object[0]);
        }
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String entryFileName = ze.getName();
                String newFilepath = this.destFolder + File.separator + entryFileName;
                File newFile = new File(newFilepath);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                File parentFolder = new File(newFile.getParent());
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            throw new InternalException((Throwable)ex, "Unzipping to folder " + this.destFolder, new Object[0]);
        }
    }
}

