/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.builder.api;

import com.ibm.smarts.model.builder.ColumnEmbedding;
import com.ibm.smarts.nlp.embedding.WordEmbedding;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.similarity.classifier.builder.core.EncodeDatasetHelper;
import com.ibm.smarts.similarity.classifier.common.api.WordEmbeddingProvider;
import com.ibm.smarts.similarity.classifier.common.core.BigramEncoder;
import com.ibm.smarts.similarity.classifier.common.core.IEncoder;
import com.ibm.smarts.similarity.classifier.common.core.IOovEncoder;
import com.ibm.smarts.similarity.classifier.common.core.KMeansEncoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueToColumnEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueToColumnEncoder.class);

    private ValueToColumnEncoder() {
    }

    public static List<ColumnEmbedding> encodeDataset(DatasetInfo datasetInfo) {
        WordEmbedding wordEmbedding = WordEmbeddingProvider.getWordEmbedding();
        if (wordEmbedding == null) {
            LOGGER.error("Failed to encode dataset. Similarity Classifier may not have been initialized properly");
            return new ArrayList<ColumnEmbedding>();
        }
        IEncoder kMeansEncoder = ValueToColumnEncoder.getEncoder(wordEmbedding);
        return EncodeDatasetHelper.encodeDataset(datasetInfo, kMeansEncoder, true);
    }

    private static IEncoder getEncoder(WordEmbedding wordEmbedding) {
        BigramEncoder bigramEncoder = BigramEncoder.getInstance();
        if (bigramEncoder == null) {
            LOGGER.debug("Failed to get embedding for oov words. Similarity Classifier may not have been initialized properly or oov embedding is disabled");
            return new KMeansEncoder(wordEmbedding);
        }
        return new KMeansEncoder(wordEmbedding, (IOovEncoder)bigramEncoder);
    }
}

