/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class VisColumn {
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<String> id;
    private String slot;
    private AggregationType aggregation;
    private Set<ChartElementFeatureMismatch> warnings;

    public VisColumn(String id) {
        this.id = new ArrayList<String>();
        this.id.add(id);
    }

    public VisColumn(List<String> id, String slot, AggregationType aggregation) {
        this(id, slot, aggregation, null);
    }

    @JsonCreator
    public VisColumn(@JsonProperty(value="id") List<String> id, @JsonProperty(value="slot") String slot, @JsonProperty(value="aggregation") AggregationType aggregation, @JsonProperty(value="warnings") Set<ChartElementFeatureMismatch> warnings) {
        this.id = id;
        this.slot = slot;
        this.aggregation = aggregation;
        this.warnings = warnings;
    }

    public VisColumn(Binding columnBinding) {
        this.id = columnBinding.getColumns();
        this.slot = columnBinding.getSlot();
        this.warnings = columnBinding.getWarnings();
        this.aggregation = null;
    }

    public VisColumn(Binding columnBinding, AggregationType aggregationType) {
        this.id = columnBinding.getColumns();
        this.slot = columnBinding.getSlot();
        this.warnings = columnBinding.getWarnings();
        this.aggregation = aggregationType;
    }

    public List<String> getId() {
        return this.id;
    }

    public String getSlot() {
        return this.slot;
    }

    public AggregationType getAggregation() {
        return this.aggregation;
    }

    public Set<ChartElementFeatureMismatch> getWarnings() {
        return this.warnings;
    }

    @JsonIgnore
    public boolean isBound() {
        return this.slot != null && !this.slot.isEmpty();
    }

    @JsonIgnore
    public boolean isUnbound() {
        return !this.isBound();
    }

    @JsonIgnore
    public String getFirst() {
        if (this.id != null && !this.id.isEmpty()) {
            return this.id.get(0);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregation == null ? 0 : this.aggregation.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.slot == null ? 0 : this.slot.hashCode());
        result = 31 * result + (this.warnings == null ? 0 : this.warnings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VisColumn other = (VisColumn)obj;
        if (this.aggregation == null ? other.aggregation != null : !this.aggregation.equals((Object)other.aggregation)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.slot == null ? other.slot != null : !this.slot.equals(other.slot)) {
            return false;
        }
        return !(this.warnings == null ? other.warnings != null : !this.warnings.equals(other.warnings));
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        if (this.id != null) {
            JSONArray jsonId = new JSONArray();
            this.id.stream().forEach(arg_0 -> ((JSONArray)jsonId).add(arg_0));
            json.put((Object)"id", (Object)jsonId);
        }
        json.put((Object)"slot", (Object)this.slot);
        if (this.aggregation != null) {
            json.put((Object)"aggregation", (Object)this.aggregation.name());
        }
        return json;
    }
}

