/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.visualization.recommender.schema.EXTRA_BEHAVIOR;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisRecommenderRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisRecommenderRequest.class);
    private String sourceModuleId;
    private String sourceModule;
    private String sourceModuleURI;
    private List<VisColumn> columns;
    private String chartType;
    private String originalChartType;
    private String sourceType;
    private Long timeout;
    private Boolean oneChartPerType;
    private Integer numResults;
    private Boolean allowBindingsWithWarnings;
    private String tempModule;
    private String tempModuleId;
    private Boolean shapedModule;
    private List<String> includedCharts;
    private List<String> excludedCharts;
    private List<BaseFilter> filters;
    private List<EXTRA_BEHAVIOR> extraBehaviors;
    private Boolean isJoinSafe;

    public VisRecommenderRequest() {
    }

    @JsonCreator
    public VisRecommenderRequest(@JsonProperty(value="sourceModuleId") String sourceModuleId, @JsonProperty(value="sourceModule") String sourceModule, @JsonProperty(value="sourceModuleURI") String sourceModuleURI, @JsonProperty(value="tempModule") String tempModule, @JsonProperty(value="tempModuleId") String tempModuleId, @JsonProperty(value="columns") List<VisColumn> columns, @JsonProperty(value="chartType") String chartType, @JsonProperty(value="originalChartType") String originalChartType, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="timeout") long timeout, @JsonProperty(value="oneChartPerType") Boolean oneChartPerType, @JsonProperty(value="numResults") int numResults, @JsonProperty(value="allowBindingsWithWarnings") Boolean allowBindingsWithWarnings, @JsonProperty(value="shapedModule") Boolean shapedModule, @JsonProperty(value="includedCharts") List<String> includedCharts, @JsonProperty(value="excludedCharts") List<String> excludedCharts, @JsonProperty(value="filters") List<BaseFilter> filters, @JsonProperty(value="extraBehaviors") List<EXTRA_BEHAVIOR> extraBehaviors, @JsonProperty(value="isJoinSafe") Boolean isJoinSafe) {
        this.sourceModuleId = sourceModuleId;
        this.sourceModule = sourceModule;
        this.sourceModuleURI = sourceModuleURI;
        this.tempModule = tempModule;
        this.tempModuleId = tempModuleId;
        this.columns = columns;
        this.chartType = chartType;
        this.originalChartType = originalChartType;
        this.sourceType = sourceType;
        this.timeout = timeout;
        this.oneChartPerType = oneChartPerType;
        this.numResults = numResults;
        this.allowBindingsWithWarnings = allowBindingsWithWarnings;
        this.shapedModule = shapedModule;
        this.includedCharts = includedCharts;
        this.excludedCharts = excludedCharts;
        this.filters = filters;
        this.extraBehaviors = extraBehaviors;
        this.isJoinSafe = isJoinSafe;
    }

    public VisRecommenderRequest(@JsonProperty(value="sourceModuleId") String sourceModuleId, @JsonProperty(value="sourceModule") String sourceModule, @JsonProperty(value="sourceModuleURI") String sourceModuleURI, @JsonProperty(value="tempModule") String tempModule, @JsonProperty(value="columns") List<VisColumn> columns, @JsonProperty(value="chartType") String chartType, @JsonProperty(value="originalChartType") String originalChartType, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="timeout") long timeout, @JsonProperty(value="oneChartPerType") Boolean oneChartPerType, @JsonProperty(value="numResults") int numResults, @JsonProperty(value="allowBindingsWithWarnings") Boolean allowBindingsWithWarnings, @JsonProperty(value="shapedModule") Boolean shapedModule, @JsonProperty(value="includedCharts") List<String> includedCharts, @JsonProperty(value="excludedCharts") List<String> excludedCharts, @JsonProperty(value="filters") List<BaseFilter> filters, @JsonProperty(value="extraBehaviors") List<EXTRA_BEHAVIOR> extraBehaviors, @JsonProperty(value="isJoinSafe") Boolean isJoinSafe) {
        this(sourceModuleId, sourceModule, sourceModuleURI, tempModule, "", columns, chartType, originalChartType, sourceType, timeout, oneChartPerType, numResults, allowBindingsWithWarnings, shapedModule, includedCharts, excludedCharts, filters, extraBehaviors, isJoinSafe);
    }

    public VisRecommenderRequest(String sourceModuleId, String sourceModule, String sourceModuleURI, String tempModule, List<VisColumn> columns, String chartType, String originalChartType, SourceType sourceType, long timeout, Boolean oneChartPerType, int numResults, Boolean allowBindingsWithWarnings, Boolean shapedModule, List<String> includedCharts, List<String> excludedCharts, List<BaseFilter> filters, List<EXTRA_BEHAVIOR> extraBehaviors, Boolean isJoinSafe) {
        this(sourceModuleId, sourceModule, sourceModuleURI, tempModule, columns, chartType, originalChartType, sourceType.getName(), timeout, oneChartPerType, numResults, allowBindingsWithWarnings, shapedModule, includedCharts, excludedCharts, filters, extraBehaviors, isJoinSafe);
    }

    public void setSourceModuleId(String sourceModuleId) {
        this.sourceModuleId = sourceModuleId;
    }

    public void setSourceModule(String sourceModule) {
        this.sourceModule = sourceModule;
    }

    public void setSourceModuleURI(String sourceModuleURI) {
        this.sourceModuleURI = sourceModuleURI;
    }

    public void setColumns(List<VisColumn> columns) {
        this.columns = columns;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public void setTempModule(String tempModule) {
        this.tempModule = tempModule;
    }

    public void setTempModuleId(String tempModuleId) {
        this.tempModuleId = tempModuleId;
    }

    public void setShapedModule(boolean shapedModule) {
        this.shapedModule = shapedModule;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public void setOneChartPerType(Boolean oneChartPerType) {
        this.oneChartPerType = oneChartPerType;
    }

    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    public void setIncludedCharts(List<String> includedCharts) {
        this.includedCharts = includedCharts;
    }

    public void setExcludedCharts(List<String> excludedCharts) {
        this.excludedCharts = excludedCharts;
    }

    public void setFilters(List<BaseFilter> filters) {
        this.filters = filters;
    }

    public void setExtraBehavior(List<EXTRA_BEHAVIOR> extraBehaviors) {
        this.extraBehaviors = extraBehaviors;
    }

    public void setIsJoinSafe(Boolean isJoinSafe) {
        this.isJoinSafe = isJoinSafe;
    }

    public String getSourceModuleId() {
        return this.sourceModuleId;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String getSourceModuleURI() {
        return this.sourceModuleURI;
    }

    public String getTempModule() {
        return this.tempModule;
    }

    public String getTempModuleId() {
        return this.tempModuleId;
    }

    public boolean isShapedModule() {
        return this.shapedModule == null ? false : this.shapedModule;
    }

    public List<VisColumn> getColumns() {
        return this.columns;
    }

    public String getChartType() {
        return this.chartType;
    }

    public String getOriginalChartType() {
        return this.originalChartType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public long getTimeout() {
        return this.timeout == null ? 0L : this.timeout;
    }

    public boolean getOneChartPerType() {
        return this.oneChartPerType == null ? true : this.oneChartPerType;
    }

    public int getNumResults() {
        return this.numResults == null ? 0 : this.numResults;
    }

    public boolean getAllowBindingsWithWarnings() {
        return this.allowBindingsWithWarnings == null ? false : this.allowBindingsWithWarnings;
    }

    @JsonIgnore
    public List<VisColumn> getBoundColumns() {
        return this.columns != null ? this.columns.stream().filter(VisColumn::isBound).collect(Collectors.toList()) : null;
    }

    @JsonIgnore
    public List<VisColumn> getUnboundColumns() {
        return this.columns != null ? this.columns.stream().filter(VisColumn::isUnbound).collect(Collectors.toList()) : null;
    }

    public List<String> getIncludedCharts() {
        return this.includedCharts == null ? Collections.emptyList() : this.includedCharts;
    }

    public List<String> getExcludedCharts() {
        return this.excludedCharts == null ? Collections.emptyList() : this.excludedCharts;
    }

    public List<BaseFilter> getFilters() {
        return this.filters == null ? Collections.emptyList() : this.filters;
    }

    public List<EXTRA_BEHAVIOR> getExtraBehaviors() {
        return this.extraBehaviors == null ? Collections.emptyList() : this.extraBehaviors;
    }

    public boolean getIsJoinSafe() {
        return this.isJoinSafe != null && this.isJoinSafe != false;
    }

    public static VisRecommenderRequest fromJSON(String str) {
        try {
            return (VisRecommenderRequest)CommonJAXBHelper.unmarshalFromJSON(VisRecommenderRequest.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Error parsing visualization recommender request", (Throwable)e);
            return null;
        }
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public String toString() {
        return "VisRecommenderRequest{sourceModuleId='" + this.sourceModuleId + '\'' + ", sourceModule='" + this.sourceModule + '\'' + ", sourceModuleURI='" + this.sourceModuleURI + '\'' + ", columns=" + this.columns + ", chartType='" + this.chartType + '\'' + ", sourceType=" + this.sourceType + ", timeout=" + this.timeout + ", oneChartPerType=" + this.oneChartPerType + ", numResults=" + this.numResults + ", tempModule='" + this.tempModule + '\'' + ", tempModuleId='" + this.tempModuleId + '\'' + ", shapedModule=" + this.shapedModule + ", includedCharts=" + this.includedCharts + ", excludedCharts=" + this.excludedCharts + ", filters=" + this.filters + ", extraBehaviors=" + this.extraBehaviors + ", isJoinSafe=" + this.isJoinSafe + '}';
    }

    public static class Builder {
        private String sourceModuleId;
        private String sourceModule;
        private String sourceModuleURI;
        private String tempModule;
        private String tempModuleId;
        private List<VisColumn> columns;
        private String chartType;
        private String sourceType;
        private Long timeout;
        private Boolean oneChartPerType;
        private Integer numResults;
        private List<BaseFilter> filters;
        private List<EXTRA_BEHAVIOR> extraBehaviors;
        private Boolean isJoinSafe;

        public Builder(ModuleAccess access, String module, List<VisColumn> columns) {
            switch (access) {
                case MODULE_ID: {
                    this.sourceModuleId = module;
                    break;
                }
                case MODULE_URI: {
                    this.sourceModuleURI = module;
                    break;
                }
                case MODULE_JSON: {
                    this.sourceModule = module;
                }
            }
            this.columns = columns;
        }

        public VisRecommenderRequest request() {
            VisRecommenderRequest request = new VisRecommenderRequest();
            request.setSourceModuleId(this.sourceModuleId);
            request.setSourceModule(this.sourceModule);
            request.setSourceModuleURI(this.sourceModuleURI);
            request.setChartType(this.chartType);
            request.setColumns(this.columns);
            request.setTempModule(this.tempModule);
            request.setTempModuleId(this.tempModuleId);
            request.setNumResults(this.numResults);
            request.setOneChartPerType(this.oneChartPerType);
            request.setSourceType(this.sourceType);
            request.setTimeout(this.timeout);
            request.setFilters(this.filters);
            request.setExtraBehavior(this.extraBehaviors);
            request.setIsJoinSafe(this.isJoinSafe);
            return request;
        }

        public Builder sourceModuleId(String sourceModuleId) {
            this.sourceModuleId = sourceModuleId;
            return this;
        }

        public Builder sourceModule(String sourceModule) {
            this.sourceModule = sourceModule;
            return this;
        }

        public Builder sourceModuleURI(String sourceModuleURI) {
            this.sourceModuleURI = sourceModuleURI;
            return this;
        }

        public Builder tempModule(String tempModule) {
            this.tempModule = tempModule;
            return this;
        }

        public Builder tempModuleId(String tempModuleId) {
            this.tempModuleId = tempModuleId;
            return this;
        }

        public Builder columns(List<VisColumn> columns) {
            this.columns = columns;
            return this;
        }

        public Builder chartType(String chartType) {
            this.chartType = chartType;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder oneChartPerType(Boolean oneChartPerType) {
            this.oneChartPerType = oneChartPerType;
            return this;
        }

        public Builder numResults(int numResults) {
            this.numResults = numResults;
            return this;
        }

        public Builder filters(List<BaseFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder extraBehaviors(List<EXTRA_BEHAVIOR> extraBehaviors) {
            this.extraBehaviors = extraBehaviors;
            return this;
        }

        public Builder isJoinSafe(Boolean isJoinSafe) {
            this.isJoinSafe = isJoinSafe;
            return this;
        }
    }

    public static enum SourceType {
        UPLOADED_FILE("uploadedFile");

        private String name;

        private SourceType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    public static enum ModuleAccess {
        MODULE_ID,
        MODULE_URI,
        MODULE_JSON;

    }
}

