/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.contentrecommender;

import com.ibm.smarts.ca.core.impl.contentrecommender.ContentRecommenderRequest;
import com.ibm.smarts.ca.core.impl.contentrecommender.ContentRecommenderResponse;
import com.ibm.smarts.ca.core.impl.contentrecommender.ExplainRequest;
import com.ibm.smarts.ca.core.impl.contentrecommender.ExplainResponse;
import com.ibm.smarts.ca.core.impl.contentrecommender.PrescriptionRequest;
import com.ibm.smarts.ca.core.impl.contentrecommender.PrescriptionResponse;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class CaContentRecommenderClient
extends CaRestClient {
    public CaContentRecommenderClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<ContentRecommenderResponse> recommendAsync(ContentRecommenderRequest request) {
        String path = Paths.recommendPath();
        return this.recommendAsync(path, request.toJSON()).thenApply(ContentRecommenderResponse::fromJSON);
    }

    public CompletableFuture<ExplainResponse> recommendAsync(ExplainRequest request) {
        String path = Paths.explainPath();
        return this.recommendAsync(path, request.toJSON()).thenApply(ExplainResponse::fromJSON);
    }

    public CompletableFuture<PrescriptionResponse> recommendAsync(PrescriptionRequest request) {
        String path = Paths.prescribePath();
        return this.recommendAsync(path, request.toJSON()).thenApply(PrescriptionResponse::fromJSON);
    }

    public ContentRecommenderResponse recommend(ContentRecommenderRequest request) {
        try {
            return this.recommendAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public ExplainResponse explain(ExplainRequest request) {
        try {
            return this.recommendAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public PrescriptionResponse prescribe(PrescriptionRequest request) {
        try {
            return this.recommendAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private CompletableFuture<String> recommendAsync(String path, String request) {
        return this.postAsync(path, request);
    }

    private static class Paths {
        private static final String CONTENTRECOMMENDER = "/bi/v1/smarts/content-recommender";
        private static final String RECOMMEND = "/bi/v1/smarts/content-recommender/recommend";
        private static final String EXPLAIN = "/bi/v1/smarts/content-recommender/explain";
        private static final String PRESCRIBE = "/bi/v1/smarts/content-recommender/prescribe";

        private Paths() {
        }

        public static String recommendPath() {
            return RECOMMEND;
        }

        public static String explainPath() {
            return EXPLAIN;
        }

        public static String prescribePath() {
            return PRESCRIBE;
        }
    }
}

