/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.function;

import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.core.function.DdsFunction;
import com.ibm.smarts.dds.core.tasks.InitialPublishingTaskImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;

public class InitialPublishingFunction
extends DdsFunction<SmartsModuleMessage> {
    public InitialPublishingFunction(String taskId, IStoreProvider storeProvider, IDataProvider dataProvider) {
        super(taskId, storeProvider, SmartsModuleMessage.class, dataProvider);
    }

    public SmartsModuleFunctionResult doApply(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        String smartsModuleId = message.getSmartsModuleId();
        String datasetID = message.getDatasetId();
        SmartsTaskContext context = new SmartsTaskContext(smartsModuleId, datasetID, null, rc, this.storeProvider);
        InitialPublishingTaskImpl initialPublishingTaskImpl = new InitialPublishingTaskImpl();
        try {
            initialPublishingTaskImpl.execute(context);
        }
        catch (InternalException ex) {
            return new SmartsModuleFunctionResult();
        }
        String resourceURI = context.getResourceURI();
        HashMap<String, SmartsModuleMessage> outgoingMessages = new HashMap<String, SmartsModuleMessage>();
        outgoingMessages.put("smartsmodule.fanout.initpublish", new SmartsModuleMessage(message.getSmartsModuleId(), message.getDatasetId(), resourceURI != null ? resourceURI.toString() : null));
        return new SmartsModuleFunctionResult(outgoingMessages);
    }
}

