/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.value.decor;

import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.decor.OrderedDecoration;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import java.util.ArrayList;
import java.util.List;

public class ValueDecorationProvider {
    private ValueDecorationProvider() {
    }

    public static List<ValueDecoration> getValueDecorations(DataType dataType, List<String> samples) {
        ArrayList<ValueDecoration> result = new ArrayList<ValueDecoration>();
        OrderedDecoration ordered = ValueDecorationProvider.getOrderedDecoration(dataType, samples);
        if (ordered != null) {
            result.add((ValueDecoration)ordered);
        }
        return result;
    }

    public static OrderedDecoration getOrderedDecoration(DataType dataType, List<String> samples) {
        if (dataType.isUnknown()) {
            return null;
        }
        int sampleSize = samples.size();
        if (sampleSize < 2) {
            return null;
        }
        Value first = dataType.newValue();
        first.assignFrom(samples.get(0));
        Value next = dataType.newValue();
        next.assignFrom(samples.get(1));
        int index = 2;
        while (next.equals((Object)first) && index < sampleSize) {
            next = dataType.newValue();
            next.assignFrom(samples.get(index++));
        }
        if (index == sampleSize && first.equals((Object)next)) {
            return null;
        }
        boolean isOrderAscending = next.compareTo((Object)first) > 0;
        boolean isOrdered = true;
        for (int i = index; i < sampleSize && isOrdered; ++i) {
            Value value = dataType.newValue();
            value.assignFrom(samples.get(i));
            int compare = value.compareTo((Object)next);
            if (compare == 0) continue;
            isOrdered = isOrderAscending && compare > 0 || !isOrderAscending && compare < 0;
            next = value;
        }
        return isOrdered ? new OrderedDecoration(isOrderAscending) : null;
    }
}

