/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.datatype;

import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.BooleanType;
import com.ibm.smarts.model.datatype.ByteType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypeAdapter;
import com.ibm.smarts.model.datatype.DateType;
import com.ibm.smarts.model.datatype.DecimalType;
import com.ibm.smarts.model.datatype.DoubleType;
import com.ibm.smarts.model.datatype.FloatType;
import com.ibm.smarts.model.datatype.IntegerType;
import com.ibm.smarts.model.datatype.LongType;
import com.ibm.smarts.model.datatype.ShortType;
import com.ibm.smarts.model.datatype.StringType;
import com.ibm.smarts.model.datatype.TimeType;
import com.ibm.smarts.model.datatype.TimestampType;
import com.ibm.smarts.model.datatype.UnknownType;

public final class DataTypes {
    private static final int INT_MAX_CHARS = Integer.toString(Integer.MIN_VALUE).length();
    private static final int LONG_MAX_CHARS = Long.toString(Long.MIN_VALUE).length();
    private static final int FLOAT_MAX_CHARS = Float.toString(-3.4028235E38f).length();
    private static final int DOUBLE_MAX_CHARS = Double.toString(-1.7976931348623157E308).length();
    private static final int DATE_MAX_CHARS = 32;
    private static final int TIME_MAX_CHARS = 32;
    private static final int TIMESTAMP_MAX_CHARS = 32;
    private static final int BOOLEAN_MAX_CHARS = 5;
    private static final UnknownType UNKNOWN_TYPE = new UnknownType();
    private static final BooleanType BOOLEAN_TYPE = new BooleanType();
    private static final ByteType BYTE_TYPE = new ByteType();
    private static final ShortType SHORT_TYPE = new ShortType();
    private static final IntegerType INTEGER_TYPE = new IntegerType();
    private static final LongType LONG_TYPE = new LongType();
    private static final FloatType FLOAT_TYPE = new FloatType();
    private static final DecimalType DECIMAL_TYPE = new DecimalType();
    private static final DoubleType DOUBLE_TYPE = new DoubleType();
    private static final DateType DATE_TYPE = new DateType();
    private static final TimeType TIME_TYPE = new TimeType();
    private static final TimestampType TIMESTAMP_TYPE = new TimestampType();

    public static UnknownType getUnknownType() {
        return UNKNOWN_TYPE;
    }

    public static StringType getStringType(int maxLength) {
        return new StringType(maxLength);
    }

    public static BooleanType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    public static ShortType getShortType() {
        return SHORT_TYPE;
    }

    public static ByteType getByteType() {
        return BYTE_TYPE;
    }

    public static IntegerType getIntegerType() {
        return INTEGER_TYPE;
    }

    public static LongType getLongType() {
        return LONG_TYPE;
    }

    public static FloatType getFloatType() {
        return FLOAT_TYPE;
    }

    public static DoubleType getDoubleType() {
        return DOUBLE_TYPE;
    }

    public static DecimalType getDecimalType() {
        return DECIMAL_TYPE;
    }

    public static DecimalType getDecimalType(int precision) {
        return new DecimalType(precision);
    }

    public static DecimalType getDecimalType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DateType getDateType() {
        return DATE_TYPE;
    }

    public static TimeType getTimeType() {
        return TIME_TYPE;
    }

    public static TimestampType getTimestampType() {
        return TIMESTAMP_TYPE;
    }

    public static DataType fromBaseType(BaseDataType baseType) {
        switch (baseType) {
            case BOOLEAN: {
                return DataTypes.getBooleanType();
            }
            case DATE: {
                return DataTypes.getDateType();
            }
            case TIME: {
                return DataTypes.getTimeType();
            }
            case TIMESTAMP: {
                return DataTypes.getTimestampType();
            }
            case DOUBLE: {
                return DataTypes.getDoubleType();
            }
            case DECIMAL: {
                return DataTypes.getDecimalType();
            }
            case FLOAT: {
                return DataTypes.getFloatType();
            }
            case INTEGER: {
                return DataTypes.getIntegerType();
            }
            case LONG: {
                return DataTypes.getLongType();
            }
            case STRING: {
                return DataTypes.getStringType(Integer.MAX_VALUE);
            }
            case UNKNOWN: {
                return DataTypes.getUnknownType();
            }
        }
        throw new IllegalArgumentException("Unsupported base type:" + baseType.toString());
    }

    public static DataType fromXSDType(String xsdType, int precision, int scale) {
        if (xsdType.endsWith("boolean")) {
            return DataTypes.getBooleanType();
        }
        if (xsdType.endsWith("string")) {
            return DataTypes.getStringType(precision);
        }
        if (xsdType.endsWith("integer") || xsdType.endsWith("int")) {
            return DataTypes.getIntegerType();
        }
        if (xsdType.endsWith("short")) {
            return DataTypes.getIntegerType();
        }
        if (xsdType.endsWith("long")) {
            return DataTypes.getLongType();
        }
        if (xsdType.endsWith("date")) {
            return DataTypes.getDateType();
        }
        if (xsdType.endsWith("time")) {
            return DataTypes.getTimeType();
        }
        if (xsdType.endsWith("dateTime")) {
            return DataTypes.getTimestampType();
        }
        if (xsdType.endsWith("double")) {
            return DataTypes.getDoubleType();
        }
        if (xsdType.endsWith("decimal")) {
            return DataTypes.getDecimalType(precision, scale);
        }
        throw new IllegalArgumentException("Unsupported XSD type: " + xsdType);
    }

    public static DataType fromStringType(String strType) {
        DataTypeAdapter adapter = new DataTypeAdapter();
        try {
            return adapter.unmarshal(strType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported XSD type: " + strType, e);
        }
    }

    public static DataType widestCompatibleType(DataType left, DataType right) {
        int rightLength;
        int leftLength;
        int leftRank = DataTypes.getRank(left);
        int rightRank = DataTypes.getRank(right);
        DataType result = null;
        result = leftRank >= rightRank ? (left.isString() || left.isTemporal() ? ((leftLength = DataTypes.getStringLength(left)) < (rightLength = DataTypes.getStringLength(right)) ? DataTypes.getStringType(rightLength) : left) : left) : (right.isString() || right.isTemporal() ? ((leftLength = DataTypes.getStringLength(left)) > (rightLength = DataTypes.getStringLength(right)) ? DataTypes.getStringType(leftLength) : DataTypes.getStringType(rightLength)) : right);
        return result;
    }

    private static int getRank(DataType dataType) {
        switch (dataType.getBaseType()) {
            case UNKNOWN: {
                return 0;
            }
            case BOOLEAN: {
                return 1;
            }
            case BYTE: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case DECIMAL: {
                return 8;
            }
            case TIME: {
                return 9;
            }
            case DATE: {
                return 10;
            }
            case TIMESTAMP: {
                return 11;
            }
            case STRING: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.toString());
    }

    public static int getStringLength(DataType dataType) {
        switch (dataType.getBaseType()) {
            case BOOLEAN: {
                return 5;
            }
            case DOUBLE: {
                return DOUBLE_MAX_CHARS;
            }
            case DECIMAL: {
                return ((DecimalType)dataType).getPrecision() + 2;
            }
            case FLOAT: {
                return FLOAT_MAX_CHARS;
            }
            case INTEGER: {
                return INT_MAX_CHARS;
            }
            case LONG: {
                return LONG_MAX_CHARS;
            }
            case DATE: {
                return 32;
            }
            case TIME: {
                return 32;
            }
            case TIMESTAMP: {
                return 32;
            }
            case STRING: {
                return ((StringType)dataType).getMaxLength();
            }
            case UNKNOWN: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.toString());
    }

    private DataTypes() {
    }
}

