/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.progress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.schema.AnalysisTask;
import com.ibm.smarts.schema.AnalysisTaskStatus;
import java.util.ArrayList;
import java.util.List;

public class DatasetStatusMessages {
    public String table;
    public List<String> errors;
    public List<String> warnings;
    public List<String> dataSourceException;

    @JsonCreator
    public DatasetStatusMessages(@JsonProperty(value="table") String table, @JsonProperty(value="errors") List<String> errors, @JsonProperty(value="warnings") List<String> warnings, @JsonProperty(value="dataSourceException") List<String> dataSourceException) {
        this.table = table;
        this.errors = errors;
        this.warnings = warnings;
        this.dataSourceException = dataSourceException;
    }

    public DatasetStatusMessages(String table, List<AnalysisTask> analysisTasks) {
        this.table = table;
        this.errors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.dataSourceException = new ArrayList<String>();
        analysisTasks.stream().forEach(analysisTask -> {
            AnalysisTaskStatus analysisTaskStatus = analysisTask.getStatus();
            if (analysisTaskStatus != null) {
                this.errors.addAll(analysisTaskStatus.getErrors());
                this.dataSourceException.addAll(analysisTaskStatus.getDataSourceException());
                this.warnings.addAll(analysisTaskStatus.getWarnings());
            }
        });
    }
}

