/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.analyzer;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.SimplePartOfSpeech;
import com.ibm.smarts.nlp.api.utility.DomainObjectAssembler;
import com.ibm.smarts.nlp.core.analyzer.NLPAnalyzer;
import com.ibm.smarts.nlp.core.analyzer.SmartAnalyzer;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPResourceManager;
import com.ibm.smarts.nlp.core.logic.Assembler;
import com.ibm.smarts.schema.ParseTreeNode;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SmartAnalyzerImpl<T>
implements SmartAnalyzer {
    private final NLPAnalyzer<T> nlpAnalyzer;
    private final DomainObjectAssembler<T> domAssembler;
    private final Assembler<T> assembler;

    public SmartAnalyzerImpl(NLPAnalyzer<T> nlpAnalyzer, DomainObjectAssembler<T> domAssembler, Locale locale) {
        this.nlpAnalyzer = nlpAnalyzer;
        this.domAssembler = domAssembler;
        this.assembler = new Assembler<T>(domAssembler, locale);
    }

    @Override
    public List<TextInfo> analyzeColumnNames(Locale locale, String[] phrases) {
        String lan = locale.getLanguage();
        ArrayList<TextInfo> textInfoCollection = new ArrayList<TextInfo>();
        for (String phrase : phrases) {
            PhraseInfo phraseInfo = this.analyzePhrase(phrase);
            ArrayList<PhraseInfo> phraseInfoCollection = new ArrayList<PhraseInfo>();
            phraseInfoCollection.add(phraseInfo);
            TextInfo textInfo = new TextInfo();
            textInfo.setLanguage(lan);
            textInfo.getPhrases().addAll(phraseInfoCollection);
            textInfoCollection.add(textInfo);
        }
        return textInfoCollection;
    }

    public PhraseInfo analyzePhrase(String processedPhrase) {
        if (StringUtils.isBlank((CharSequence)processedPhrase)) {
            return this.emptyNlpResponse(processedPhrase);
        }
        T results = this.nlpAnalyzer.analyzePhrase(processedPhrase);
        if (results == null) {
            return this.emptyNlpResponse(processedPhrase);
        }
        Hashtable senseInfoMap = new Hashtable();
        return this.domAssembler.assemblePhraseInfo(results, senseInfoMap);
    }

    @Override
    public ParseTreeNode analyzeQuestion(Locale locale, String question) {
        T results = this.nlpAnalyzer.analyzeQuestion(question);
        return this.assembler.assembleParseTree(CoreNLPResourceManager.getHeadFinder(locale), results);
    }

    @Override
    public PhraseInfo tokenize(String sentence) {
        T results = this.nlpAnalyzer.tokenize(sentence);
        if (results == null) {
            return this.emptyNlpResponse(sentence);
        }
        return this.domAssembler.assemblePhraseInfo(results);
    }

    private PhraseInfo emptyNlpResponse(String text) {
        PhraseInfo phraseInfo = new PhraseInfo();
        phraseInfo.setText(text);
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setLemma(text);
        tokenInfo.setText(text);
        tokenInfo.setPOS(PartOfSpeech.OTHER.name());
        tokenInfo.setPOSlocal(SimplePartOfSpeech.other.name());
        phraseInfo.getTokens().add(tokenInfo);
        return phraseInfo;
    }

    @Override
    public TextInfo analyzeQuestionForTextInfo(Locale locale, String question) {
        T results = this.nlpAnalyzer.analyzeQuestion(question);
        String lan = locale.getLanguage();
        List<PhraseInfo> phrases = this.assembler.assemblePhrasesFromParseTree(CoreNLPResourceManager.getHeadFinder(locale), results);
        TextInfo textInfo = new TextInfo();
        textInfo.setLanguage(lan);
        textInfo.getPhrases().addAll(phrases.stream().filter(p -> !p.getTokens().isEmpty()).collect(Collectors.toList()));
        return textInfo;
    }
}

