/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.fastload;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.nndep.DependencyParserFastLoad;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.DependencyParseAnnotator;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class DependencyParseAnnotatorFastLoad
extends SentenceAnnotator {
    private static Redwood.RedwoodChannels log = Redwood.channels((Object[])new Object[]{DependencyParseAnnotator.class});
    private final DependencyParserFastLoad parser;
    private final int nThreads;
    private static final int DEFAULT_NTHREADS = 1;
    private final long maxTime;
    private static final long DEFAULT_MAXTIME = -1L;
    private final GrammaticalStructure.Extras extraDependencies;

    public DependencyParseAnnotatorFastLoad() {
        this(new Properties());
    }

    public DependencyParseAnnotatorFastLoad(Properties properties) {
        String modelPath = PropertiesUtils.getString((Properties)properties, (String)"model", (String)"edu/stanford/nlp/models/parser/nndep/english_UD.gz");
        this.parser = DependencyParserFastLoad.loadFromModelFile(modelPath, properties);
        this.nThreads = PropertiesUtils.getInt((Properties)properties, (String)"testThreads", (int)1);
        this.maxTime = PropertiesUtils.getLong((Properties)properties, (String)"sentenceTimeout", (long)-1L);
        this.extraDependencies = (GrammaticalStructure.Extras)MetaClass.cast((String)properties.getProperty("extradependencies", "NONE"), GrammaticalStructure.Extras.class);
    }

    protected int nThreads() {
        return this.nThreads;
    }

    protected long maxTime() {
        return this.maxTime;
    }

    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        GrammaticalStructure gs = this.parser.predict(sentence);
        SemanticGraph deps = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.COLLAPSED, (GrammaticalStructure.Extras)this.extraDependencies, null);
        SemanticGraph uncollapsedDeps = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.BASIC, (GrammaticalStructure.Extras)this.extraDependencies, null);
        SemanticGraph ccDeps = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.CCPROCESSED, (GrammaticalStructure.Extras)this.extraDependencies, null);
        SemanticGraph enhancedDeps = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.ENHANCED, (GrammaticalStructure.Extras)this.extraDependencies, null);
        SemanticGraph enhancedPlusPlusDeps = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.ENHANCED_PLUS_PLUS, (GrammaticalStructure.Extras)this.extraDependencies, null);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, (Object)deps);
        sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, (Object)uncollapsedDeps);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, (Object)ccDeps);
        sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, (Object)enhancedDeps);
        sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, (Object)enhancedPlusPlusDeps);
    }

    protected void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        log.info(new Object[]{"fail"});
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)));
    }
}

