/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.utility;

import com.ibm.smarts.nlp.core.utility.AcronymHelper;
import com.ibm.smarts.nlp.core.utility.CharsUtils;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class PrettyNameUtil {
    private static final String LATIN_CHARSET_ENCODING = "ISO-8859-1";
    private static final String US_ASCII_ENCODING = "US-ASCII";

    private PrettyNameUtil() {
    }

    public static void setDatasetPrettyNames(DatasetInfo datasetInfo, Boolean moduleHasOverwrites, Boolean prettifyLabels) {
        boolean shouldNotPrettifyLabelsAndNames;
        if (datasetInfo == null) {
            return;
        }
        boolean bl = shouldNotPrettifyLabelsAndNames = prettifyLabels != null && prettifyLabels == false;
        if (shouldNotPrettifyLabelsAndNames || !PrettyNameUtil.allUpperCase(datasetInfo.getName()) || !PrettyNameUtil.allColNamesUpperCase(datasetInfo) || moduleHasOverwrites == null || moduleHasOverwrites.booleanValue()) {
            PrettyNameUtil.setPrettyNameAsName(datasetInfo);
        } else {
            PrettyNameUtil.createAndSetPrettyNames(datasetInfo);
        }
    }

    private static void setPrettyNameAsName(DatasetInfo datasetInfo) {
        datasetInfo.setPrettyName(datasetInfo.getName());
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo).forEach(columnInfo -> columnInfo.setPrettyName(columnInfo.getName()));
    }

    private static boolean allColNamesUpperCase(DatasetInfo datasetInfo) {
        List cols = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo);
        for (ColumnInfo col : cols) {
            if (PrettyNameUtil.allUpperCase(col.getName())) continue;
            return false;
        }
        return true;
    }

    protected static boolean allUpperCase(String text) {
        if (text == null || !PrettyNameUtil.isASCIIOnly(text) || CharsUtils.containsInvalidCharacters(text)) {
            return false;
        }
        String allUpperCase = text.toUpperCase();
        return text.equals(allUpperCase);
    }

    protected static boolean isLatinCharactersOnly(String text) {
        return Charset.forName(LATIN_CHARSET_ENCODING).newEncoder().canEncode(text);
    }

    protected static boolean isASCIIOnly(String text) {
        return Charset.forName(US_ASCII_ENCODING).newEncoder().canEncode(text);
    }

    private static void createAndSetPrettyNames(DatasetInfo datasetInfo) {
        String prettyNameDs = PrettyNameUtil.getPrettyName(datasetInfo.getLabel(), datasetInfo.getName());
        datasetInfo.setPrettyName(prettyNameDs);
        datasetInfo.setName(prettyNameDs);
        if (!datasetInfo.getLabel().getPhrases().isEmpty()) {
            ((PhraseInfo)datasetInfo.getLabel().getPhrases().get(0)).setText(prettyNameDs);
        }
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo).forEach(columnInfo -> {
            String prettyName = PrettyNameUtil.getPrettyName(columnInfo.getLabel(), columnInfo.getName());
            columnInfo.setPrettyName(prettyName);
            columnInfo.setName(prettyName);
            if (!columnInfo.getLabel().getPhrases().isEmpty()) {
                ((PhraseInfo)columnInfo.getLabel().getPhrases().get(0)).setText(prettyName);
            }
        });
    }

    protected static String getPrettyName(TextInfo textInfo, String originalName) {
        StringBuilder prettyPrint = new StringBuilder();
        if (textInfo == null) {
            return originalName;
        }
        List tokens = textInfo.getPhrases().stream().map(PhraseInfo::getTokens).flatMap(Collection::stream).collect(Collectors.toList());
        if (tokens.isEmpty()) {
            return originalName;
        }
        boolean possibleExtension = false;
        for (TokenInfo tokenInfo : tokens) {
            if ("SYM".equalsIgnoreCase(tokenInfo.getPOS())) continue;
            String value = tokenInfo.getText();
            if (".".equals(value)) {
                possibleExtension = true;
                continue;
            }
            if (possibleExtension) {
                possibleExtension = false;
                if (PrettyNameUtil.isSupportedExtension(value)) continue;
                prettyPrint.append(" .");
            }
            if (prettyPrint.length() > 0) {
                prettyPrint.append(' ');
            }
            prettyPrint.append(value);
        }
        return PrettyNameUtil.capitalize(prettyPrint.toString().trim());
    }

    protected static String capitalize(String input) {
        String[] nameArr;
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        for (String part : nameArr = input.split("\\s+")) {
            String append = null;
            append = AcronymHelper.isAcronym(part) ? part.toUpperCase() : part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            output.append(append);
            output.append(" ");
        }
        return output.toString().trim();
    }

    private static boolean isSupportedExtension(String value) {
        boolean supported = false;
        for (String extension : PrettyNameUtil.getSupported()) {
            if (!value.trim().equalsIgnoreCase(extension)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    private static List<String> getSupported() {
        ArrayList<String> supported = new ArrayList<String>();
        supported.add("csv");
        supported.add("txt");
        supported.add("xls");
        supported.add("xlsx");
        return supported;
    }
}

