/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.impl;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.ca.rest.CaRestDataProviderInfo;
import com.ibm.smarts.ca.rest.CaRestDataProviderModuleInfo;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.schema.LoadOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;

public class SmartsCaHelper
extends SmartsCaCoreHelper {
    public static Map<String, List<String>> extractCaHeaders(HttpServletRequest request) {
        try {
            RESTClientConfig rcc = new RESTClientConfig(request);
            Collection rccHeaders = rcc.getRequestHeaders();
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            if (rccHeaders != null) {
                for (Header hdr : rccHeaders) {
                    String name = hdr.getName();
                    String value = hdr.getValue();
                    List<String> values = ret.get(name);
                    if (values == null) {
                        values = new ArrayList<String>();
                        ret.put(name, values);
                    }
                    values.add(value);
                }
            }
            return ret;
        }
        catch (Throwable th) {
            throw new InternalException(th, "extracting headers from HttpServletRequest", new Object[]{request});
        }
    }

    public static CaRestDataProviderInfo buildDataProviderInfo(Properties config, String id, Module module, String moduleType, String connections) {
        String hostUrl = config.getProperty("smarts.ca.core.caServer.url");
        return SmartsCaHelper.buildDataProviderInfo(config, id, SmartsCaHelper.buildModuleUri((String)hostUrl, (String)id, (String)moduleType), module, moduleType, connections);
    }

    public static CaRestDataProviderInfo buildDataProviderInfo(Properties config, String id, String moduleUri, Module module, String type, String connections, Set<String> excludedTables, LoadOptions loadOptions) {
        int sampleSize;
        CaRestDataProviderModuleInfo mInfo = new CaRestDataProviderModuleInfo(config.getProperty("smarts.ca.core.caServer.url"));
        mInfo.baseUri = config.getProperty("smarts.ca.core.caServer.url");
        mInfo.moduleUri = moduleUri;
        HashMap querySubjectMap = new HashMap();
        List querySubjects = module.getQuerySubject().stream().filter(qs -> !excludedTables.contains(qs.getIdentifier())).collect(Collectors.toList());
        for (QuerySubject qs2 : querySubjects) {
            String qsId = qs2.getIdentifier();
            querySubjectMap.put(qsId, new ArrayList());
            List items = QuerySubjectUtil.getVisibleQueryItems((QuerySubject)qs2, (boolean)true);
            for (QueryItem qi : items) {
                ((List)querySubjectMap.get(qsId)).add(qi.getIdentifier());
            }
        }
        int n = sampleSize = loadOptions != null ? loadOptions.getDataSamplingSize() : Integer.valueOf(config.getProperty("smarts.ca.samples.size")).intValue();
        if (sampleSize > 0) {
            SampleQueryContext context;
            int sampleSeed = Integer.valueOf(config.getProperty("smarts.ca.samples.seed"));
            mInfo.sampleQueryContext = context = new SampleQueryContext(config.getProperty("smarts.ca.core.caServer.url"), id, querySubjectMap, type, connections, sampleSeed, sampleSize, null);
        } else {
            mInfo.disableRetrieveSamples();
        }
        CaRestDataProviderInfo providerInfo = new CaRestDataProviderInfo();
        providerInfo.putModuleInfo(id, mInfo);
        return providerInfo;
    }

    public static CaRestDataProviderInfo buildDataProviderInfo(Properties config, String id, String moduleUri, Module module, String type, String connections) {
        return SmartsCaHelper.buildDataProviderInfo(config, id, moduleUri, module, type, connections, new HashSet<String>(), null);
    }
}

