/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.IFlowCondition;
import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ConditionalFlowStage
implements IFlowStage {
    private final IFlowCondition _condition;
    private final List<IFlowStage> _stages;
    private int _currStageIndex;
    private boolean _first = true;

    public ConditionalFlowStage(IFlowCondition iFlowCondition, List<IFlowStage> list) {
        this._condition = iFlowCondition;
        this._stages = list;
    }

    public IFlowCondition getFlowCondition() {
        return this._condition;
    }

    public List<IFlowStage> getStages() {
        return this._stages;
    }

    @Override
    public void reset() {
        this._first = true;
        this._currStageIndex = 0;
        for (IFlowStage iFlowStage : this._stages) {
            iFlowStage.reset();
        }
    }

    @Override
    public void describe(int n, Logger logger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(Messages.getFormattedMessage("ConditionalFlowStage.name", this._condition.toString()));
        logger.log(Level.CONFIG, stringBuilder.toString());
        for (IFlowStage iFlowStage : this._stages) {
            iFlowStage.describe(n + 1, logger);
        }
    }

    @Override
    public boolean hasNext(CAS cAS) throws AnalysisEngineProcessException {
        if (this._first) {
            this._first = false;
            if (!this._condition.testCondition(cAS)) {
                return false;
            }
        }
        while (this._currStageIndex < this._stages.size()) {
            IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
            if (iFlowStage.hasNext(cAS)) {
                return true;
            }
            ++this._currStageIndex;
        }
        return false;
    }

    @Override
    public String next() throws AnalysisEngineProcessException {
        IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
        return iFlowStage.next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ConditionFlowStage");
        stringBuilder.append("[first=").append(this._first);
        stringBuilder.append(",stageIndex=").append(this._currStageIndex);
        if (this._currStageIndex >= 0 && this._currStageIndex < this._stages.size()) {
            stringBuilder.append(",stage=").append(this._stages.get(this._currStageIndex));
        }
        stringBuilder.append(']');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

