/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.langware.annotator.Copyright;
import java.io.File;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class DictionariesCacheManager {
    private static DictionariesCacheManager instance;
    private final CapMatrix cm = new CapMatrix(null);

    public static DictionariesCacheManager getInstance() throws DLTException {
        if (instance == null) {
            instance = new DictionariesCacheManager();
        }
        return instance;
    }

    private DictionariesCacheManager() throws DLTException {
    }

    public void updateDataSpec(String string) {
        this.cm.setDataSpec(string);
    }

    public Dictionary[] getDictionaries(CapMatrix.Entry[] entryArray) throws DLTException {
        Dictionary[] dictionaryArray = new Dictionary[entryArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            CapMatrix.Entry entry = this.cm.getEntryByFile(entryArray[i].getFile());
            if (entry == null) {
                entry = entryArray[i];
                this.cm.registerEntry(entry);
            }
            dictionaryArray[i] = entry.activate();
        }
        return dictionaryArray;
    }

    public Dictionary getDictionaryByFile(File file) throws DLTException {
        return this.cm.getEntryByFile(file).activate();
    }

    public Dictionary getDictionaryByFilename(String string) throws DLTException {
        File file = new File(string);
        CapMatrix.Entry entry = file.isFile() ? this.cm.getEntryByFile(file) : this.cm.getEntryByFilename(string);
        return entry != null ? entry.activate() : null;
    }

    public void deactivateAll() throws DLTException {
        this.cm.deactivateAll();
    }

    public void deactiveFile(File file) {
        this.cm.deactivateFile(file);
    }
}

