/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.es;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultHandler;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.lex_analysis.es.AnnotationsCreatorOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ConfigurationMgrOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultSpecMgrOF;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.lang.reflect.Method;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ResultHandlerOF
extends ResultHandler {
    private final ResultSpecMgrOF mRsltSpecMgr;
    protected final AnnotationsCreatorOF mAnnoCreator;
    protected GlossCollection mGlossColl = new GlossCollection();
    final boolean mQueryProcessingMode;

    public ResultHandlerOF(LexicalAnalyzerContext lexicalAnalyzerContext, AnnotationsCreator annotationsCreator, CharacterIterator characterIterator) {
        super(lexicalAnalyzerContext, annotationsCreator, characterIterator);
        this.mRsltSpecMgr = (ResultSpecMgrOF)lexicalAnalyzerContext.getResultSpecManager();
        this.mQueryProcessingMode = ((ConfigurationMgrOF)lexicalAnalyzerContext.getConfigurationManager()).mQueryProcessingMode;
        this.mAnnoCreator = (AnnotationsCreatorOF)annotationsCreator;
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        if (this.mQueryProcessingMode) {
            if (this.mRsltSpecMgr.mIsCompoundAnnoReq) {
                this.mLastCompoundToken = this.mAnnoCreator.addToken(n, n2, 0, TokenInfo.BasicType.COMPOUND);
                this.createQueryAnnotations(n, n2);
            }
            this.mAnnoCreator.startCompoundGroup(n3);
            this.mFirstForkRBBI4CJ = -1;
            return 0;
        }
        return super.startGroup(n, n2, n3);
    }

    void lookup(Dictionary[] dictionaryArray, int n, int n2, boolean bl) {
        int n3 = this.mDocumentTextItr.getIndex();
        this.mDocumentTextItr.setIndex(n);
        this.mGlossColl.clear();
        for (Dictionary dictionary : dictionaryArray) {
            try {
                GlossCollection glossCollection = dictionary.get(this.mDocumentTextItr, n2 - n);
                if (glossCollection == null) continue;
                if (!bl) {
                    this.mGlossColl.addAll((Collection)glossCollection);
                    return;
                }
                this.mGlossColl.addAll((Collection)glossCollection);
            }
            catch (DLTException dLTException) {
                this.mContext.logError(Level.WARNING, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreatorOF__Error_looking_up_dicts_for_token__WARNING.name(), dictionary, this.mAnnoCreator.getTextSpan(n, n2)), (Exception)((Object)dLTException));
            }
        }
        this.mDocumentTextItr.setIndex(n3);
    }

    void createQueryAnnotations(int n, int n2) {
        Dictionary[] dictionaryArray;
        Iterator iterator = null;
        if (this.mRsltSpecMgr.mIsStopwordAnnoReq) {
            dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType("StopwordDicts");
            this.lookup(dictionaryArray, n, n2, false);
            if (!this.mGlossColl.isEmpty()) {
                this.mAnnoCreator.createNewStopwordAnnotation(n, n2);
            }
        }
        if (this.mRsltSpecMgr.mIsBoostTermAnnoReq) {
            dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType("BoostTermDicts");
            this.lookup(dictionaryArray, n, n2, false);
            for (Gloss gloss : this.mGlossColl) {
                if (!gloss.getClass().getName().equals("com.ibm.dltj.gloss.user.BoostGloss")) continue;
                try {
                    Method method = gloss.getClass().getMethod("getBoostTerm_value", new Class[0]);
                    Object object = method.invoke((Object)gloss, new Object[0]);
                    List list = (List)object;
                    int n3 = (Integer)list.get(0);
                    this.mAnnoCreator.createNewBoostTermAnnotation(n, n2, n3);
                }
                catch (Exception exception) {
                    this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandlerOF__Error_Retrieve_X_for_Token__FINEST.name(), Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__boost__CONFIG.name()), this.mAnnoCreator.getTextSpan(n, n2)), exception);
                }
            }
        }
        if (this.mRsltSpecMgr.mIsSynonymAnnoReq) {
            dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType("QuerySynDicts");
            this.lookup(dictionaryArray, n, n2, true);
            if (!this.mGlossColl.isEmpty()) {
                this.mAnnoCreator.createNewSynonymAnnotation(n, n2, this.mGlossColl);
            }
        }
    }
}

