/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.qa.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InterpretationUnit {
    private PhraseInfo phraseInfo;
    private int startIndex;
    private int endIndex;
    private boolean isStopWord;
    private List<SemanticAnnotation> semanticAnnotations;

    public InterpretationUnit(PhraseInfo info) {
        this(info, 0, 0, new ArrayList<SemanticAnnotation>(0));
    }

    public InterpretationUnit(PhraseInfo info, int startIndex, int endIndex) {
        this(info, startIndex, endIndex, new ArrayList<SemanticAnnotation>(0));
    }

    public InterpretationUnit(PhraseInfo info, int startIndex, int endIndex, List<SemanticAnnotation> sas) {
        this.phraseInfo = info;
        this.setStartIndex(startIndex);
        this.setEndIndex(endIndex);
        this.semanticAnnotations = null != sas ? sas : new ArrayList(0);
        this.isStopWord = this.phraseInfo.getTokens().size() == 1 && ((TokenInfo)this.phraseInfo.getTokens().get(0)).getSignificance() <= Significance.LOW;
    }

    public boolean hasSemanticAnnotation() {
        return !this.semanticAnnotations.isEmpty();
    }

    public boolean hasSingleSemanticAnnotation() {
        return this.hasSemanticAnnotation() && this.semanticAnnotations.size() == 1;
    }

    public PhraseInfo getPhraseInfo() {
        return this.phraseInfo;
    }

    public void setPhraseInfo(PhraseInfo phraseInfo) {
        this.phraseInfo = phraseInfo;
    }

    public boolean isStopWord() {
        return this.isStopWord;
    }

    @JsonIgnore
    public String getText() {
        return this.phraseInfo.getText();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public String toString() {
        String phrase = "";
        try {
            phrase = JAXBHelper.marshalToJSON((Object)this.getPhraseInfo());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "InterpretationUnit [phraseInfo=\"" + phrase + "\", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", isStopWord=" + this.isStopWord + ", semanticAnnotations=" + this.semanticAnnotations + "]";
    }

    private void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    private void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public List<SemanticAnnotation> getSemanticAnnotations() {
        return this.semanticAnnotations;
    }

    public int getCharOffsetBegin() {
        return ((TokenInfo)this.phraseInfo.getTokens().get(0)).getCharOffsetBegin();
    }

    public int getCharOffsetEnd() {
        return ((TokenInfo)this.phraseInfo.getTokens().get(this.phraseInfo.getTokens().size() - 1)).getCharOffsetEnd();
    }
}

