/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.qa.api;

import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.PhraseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SemanticAnnotation {
    private PhraseInfo phraseInfo;
    private List<ConceptInfo> concepts;

    public SemanticAnnotation(PhraseInfo info) {
        this.setPhraseInfo(info);
        this.concepts = new ArrayList<ConceptInfo>(0);
    }

    public SemanticAnnotation(PhraseInfo info, List<ConceptInfo> cs) {
        this(info);
        this.setConcepts(cs);
    }

    public List<ConceptInfo> getConcepts() {
        return this.concepts;
    }

    public void setConcepts(List<ConceptInfo> concepts) {
        if (null != concepts) {
            this.concepts = concepts;
        }
    }

    public PhraseInfo getPhraseInfo() {
        return this.phraseInfo;
    }

    public void setPhraseInfo(PhraseInfo phraseInfo) {
        this.phraseInfo = phraseInfo;
    }

    public String toString() {
        return "SemanticAnnotation [phraseInfo=" + this.phraseInfo.getText() + ", concepts=" + this.concepts.stream().map(c -> "[" + ConceptsUtil.getConceptName((ConceptInfo)c) + ", " + c.getConfidence() + "]").collect(Collectors.joining(", ")) + "]";
    }
}

