/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.smarts.model.common.util.TaxonomyTypeWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaxonomyUtil {
    private static final Map<String, TaxonomyTypeWrapper> AF_TAXONOMY_MAP = new HashMap<String, TaxonomyTypeWrapper>();
    private static final Map<TaxonomyTypeWrapper, List<String>> REVERSE_AF_TAXONOMY_MAP = new HashMap<TaxonomyTypeWrapper, List<String>>();
    private static final String C_DOMAIN = "cognos";
    public static final String CC_TIME = "cTime";
    public static final String CC_GEOLOCATION = "cGeoLocation";
    public static final String CC_NONE = "cNone";
    public static final String IDENTIFIER = "Identifier";
    public static final String DOMAIN_CONCEPT = "http://www.ibm.com/ontologies/waca/domain";
    public static final String ONTOLOGY_COMMON = "http://www.ibm.com/ontologies/waca/domain/common";
    public static final String TEMPORAL = "Temporal";
    public static final String GEOGRAPHY = "Geography";
    public static final String MEASURE = "Measure";
    public static final String ENTITY = "Entity";
    public static final String NOTHING = "owl:Nothing";
    public static final String OWL_NOTHING = "owl:Nothing";
    protected static final String CF_NONE = "cNone";
    private static final String CF_DATE = "cDate";
    private static final String CF_YEAR = "cYear";
    private static final String CF_QUARTER = "cQuarter";
    private static final String CF_SEASON = "cSeason";
    private static final String CF_MONTH = "cMonth";
    private static final String CF_WEEK = "cWeek";
    private static final String CF_DAY = "cDay";
    private static final String CF_HOUR = "cHour";
    private static final String CF_MINUTE = "cMinute";
    private static final String CF_SECOND = "cSecond";
    private static final String CF_CONTINENT = "cContinent";
    private static final String CF_SUBCONTINENT = "cSubContinent";
    private static final String CF_COUNTRY = "cCountry";
    private static final String CF_REGION = "cRegion";
    private static final String CF_STATEPROVINCE = "cStateProvince";
    private static final String CF_COUNTY = "cCounty";
    private static final String CF_CITY = "cCity";
    private static final String CF_POSTALCODE = "cPostalCode";
    private static final String CF_STREETADDRESS = "cStreetAddress";
    private static final String CF_POSITION = "cPosition";
    private static final String CF_LATITUDE = "cLatitude";
    private static final String CF_LONGITUDE = "cLongitude";
    private static final String AF_NONE = "None";
    private static final String AF_DATE = "Date";
    private static final String AF_DATEOFBIRTH = "DateOfBirth";
    private static final String AF_YEAR = "Year";
    private static final String AF_QUARTER = "Quarter";
    private static final String AF_YEARQUARTER = "YearQuarter";
    private static final String AF_SEASON = "Season";
    private static final String AF_MONTH = "Month";
    private static final String AF_YEARMONTH = "YearMonth";
    private static final String AF_WEEK = "Week";
    private static final String AF_DAYOFWEEK = "DayOfWeek";
    private static final String AF_DAYOFMONTH = "DayOfMonth";
    private static final String AF_DAYOFYEAR = "DayOfYear";
    private static final String AF_HOUR = "Hour";
    private static final String AF_MINUTE = "Minute";
    private static final String AF_SECOND = "Second";
    private static final String AF_CONTINENT = "Continent";
    private static final String AF_SUBCONTINENT = "SubContinent";
    private static final String AF_COUNTRY = "Country";
    private static final String AF_COUNTRYREGION = "CountryRegion";
    private static final String AF_STATEPROVINCE = "StateProvince";
    private static final String AF_COUNTY = "County";
    private static final String AF_CITY = "City";
    private static final String AF_POSTALCODE = "PostalCode";
    private static final String AF_STREETADDRESS = "StreetAddress";
    private static final String AF_COORDINATE = "Coordinate";
    private static final String AF_LONGITUDE = "Longitude";
    private static final String AF_LATITUDE = "Latitude";

    private TaxonomyUtil() {
    }

    public static TaxonomyTypeWrapper getTaxonomyType(String str) {
        return str != null ? AF_TAXONOMY_MAP.get(str) : null;
    }

    public static List<String> getConcept(TaxonomyType type) {
        return type != null ? REVERSE_AF_TAXONOMY_MAP.get(new TaxonomyTypeWrapper(type)) : null;
    }

    private static TaxonomyTypeWrapper initTaxonomyType(TaxonomyType taxonomyType, String domain, String clazz, String family) {
        taxonomyType.setDomain(domain);
        taxonomyType.setClazz(clazz);
        taxonomyType.setFamily(family);
        return new TaxonomyTypeWrapper(taxonomyType);
    }

    static {
        ObjectFactory factory = new ObjectFactory();
        AF_TAXONOMY_MAP.put(AF_NONE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, "cNone", "cNone"));
        AF_TAXONOMY_MAP.put(AF_DATE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DATE));
        AF_TAXONOMY_MAP.put(AF_DATEOFBIRTH, AF_TAXONOMY_MAP.get(AF_DATE));
        AF_TAXONOMY_MAP.put(AF_YEAR, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_YEAR));
        AF_TAXONOMY_MAP.put(AF_QUARTER, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_QUARTER));
        AF_TAXONOMY_MAP.put(AF_YEARQUARTER, AF_TAXONOMY_MAP.get(AF_QUARTER));
        AF_TAXONOMY_MAP.put(AF_SEASON, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SEASON));
        AF_TAXONOMY_MAP.put(AF_MONTH, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MONTH));
        AF_TAXONOMY_MAP.put(AF_YEARMONTH, AF_TAXONOMY_MAP.get(AF_MONTH));
        AF_TAXONOMY_MAP.put(AF_WEEK, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_WEEK));
        AF_TAXONOMY_MAP.put(AF_DAYOFWEEK, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DAY));
        AF_TAXONOMY_MAP.put(AF_DAYOFMONTH, AF_TAXONOMY_MAP.get(AF_DAYOFWEEK));
        AF_TAXONOMY_MAP.put(AF_DAYOFYEAR, AF_TAXONOMY_MAP.get(AF_DAYOFWEEK));
        AF_TAXONOMY_MAP.put(AF_HOUR, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_HOUR));
        AF_TAXONOMY_MAP.put(AF_MINUTE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MINUTE));
        AF_TAXONOMY_MAP.put(AF_SECOND, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SECOND));
        AF_TAXONOMY_MAP.put(AF_CONTINENT, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CONTINENT));
        AF_TAXONOMY_MAP.put(AF_SUBCONTINENT, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_SUBCONTINENT));
        AF_TAXONOMY_MAP.put(AF_COUNTRY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTRY));
        AF_TAXONOMY_MAP.put(AF_COUNTRYREGION, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_REGION));
        AF_TAXONOMY_MAP.put(AF_STATEPROVINCE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STATEPROVINCE));
        AF_TAXONOMY_MAP.put(AF_COUNTY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTY));
        AF_TAXONOMY_MAP.put(AF_CITY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CITY));
        AF_TAXONOMY_MAP.put(AF_POSTALCODE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSTALCODE));
        AF_TAXONOMY_MAP.put(AF_STREETADDRESS, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STREETADDRESS));
        AF_TAXONOMY_MAP.put(AF_COORDINATE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSITION));
        AF_TAXONOMY_MAP.put(AF_LATITUDE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LATITUDE));
        AF_TAXONOMY_MAP.put(AF_LONGITUDE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LONGITUDE));
        factory = new ObjectFactory();
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, "cNone", "cNone"), Arrays.asList(AF_NONE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DATE), Arrays.asList(AF_DATE, AF_DATEOFBIRTH));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_YEAR), Arrays.asList(AF_YEAR));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_QUARTER), Arrays.asList(AF_QUARTER, AF_YEARQUARTER));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SEASON), Arrays.asList(AF_SEASON));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MONTH), Arrays.asList(AF_MONTH, AF_YEARMONTH));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_WEEK), Arrays.asList(AF_WEEK));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DAY), Arrays.asList(AF_DAYOFWEEK, AF_DAYOFMONTH, AF_DAYOFYEAR));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_HOUR), Arrays.asList(AF_HOUR));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MINUTE), Arrays.asList(AF_MINUTE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SECOND), Arrays.asList(AF_SECOND));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CONTINENT), Arrays.asList(AF_CONTINENT));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_SUBCONTINENT), Arrays.asList(AF_SUBCONTINENT));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTRY), Arrays.asList(AF_COUNTRY));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_REGION), Arrays.asList(AF_COUNTRYREGION));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STATEPROVINCE), Arrays.asList(AF_STATEPROVINCE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTY), Arrays.asList(AF_COUNTY));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CITY), Arrays.asList(AF_CITY));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSTALCODE), Arrays.asList(AF_POSTALCODE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STREETADDRESS), Arrays.asList(AF_STREETADDRESS));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSITION), Arrays.asList(AF_COORDINATE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LATITUDE), Arrays.asList(AF_LATITUDE));
        REVERSE_AF_TAXONOMY_MAP.put(TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LONGITUDE), Arrays.asList(AF_LONGITUDE));
    }
}

