/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ir.visualizer;

import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.ir.visualizer.IRVisualizerUtilParams;
import com.ibm.smarts.recommenders.core.utils.ChartFamilyUtil;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.schema.EXTRA_BEHAVIOR;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IRVisualizerUtil {
    public static Map<IRCombination, IRecommendedVisualization> generate(IRVisualizerUtilParams irParams) {
        if (irParams.getIRContent().getCombinations().isEmpty()) {
            return Collections.emptyMap();
        }
        QuickAccessSmartsModule quick = new QuickAccessSmartsModule(irParams.getSmartsModule());
        Map<IRCombination, List> recommendations = irParams.getIRContent().getCombinations().stream().map(c -> {
            try {
                VisualizationParameters parameters = new VisualizationParameters();
                parameters.setAggregationMap(irParams.getAggregationMap());
                parameters.setIncludedCharts(irParams.getIncludedChartTypes());
                parameters.setExcludedCharts(irParams.getExcludedChartTypes());
                parameters.setPredictiveOnly(irParams.isPredictiveOnly());
                ArrayList filters = new ArrayList();
                filters.addAll(irParams.getIRContent().getGlobalFilters());
                filters.addAll(c.getFilters());
                parameters.setBaseFilterList(filters);
                parameters.addBehaviour(EXTRA_BEHAVIOR.ALLOW_DUAL_COLUMNS_ADAPTATION);
                parameters.addBehaviour(EXTRA_BEHAVIOR.ALLOW_AUTO_GROUPING);
                if (!IRVisualizerUtil.isJoin(c, quick)) {
                    parameters.addBehaviour(EXTRA_BEHAVIOR.ALLOW_TOP_BOTTOM_FILTER);
                }
                return new Pair(c, (Object)irParams.getVisRec().recommend(null, irParams.getSmartsModule(), irParams.getLocale(), c.getColumnCombinations().stream().map(col -> col.getId()).collect(Collectors.toList()), parameters));
            }
            catch (RecommendationException e) {
                return new Pair(c, Collections.emptyList());
            }
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (p1, p2) -> p1));
        EnumMap observedChartFamilies = new EnumMap(ChartFamilyUtil.ChartFamily.class);
        HashSet observedCharts = new HashSet();
        return irParams.getIRContent().getCombinations().stream().map(c -> {
            IRecommendedVisualization rec;
            List list = recommendations.getOrDefault(c, Collections.emptyList());
            if (list.isEmpty()) {
                return null;
            }
            IRecommendedVisualization top = (IRecommendedVisualization)list.get(0);
            if (!IRVisualizerUtil.haveObservedChart(top, observedChartFamilies, observedCharts, irParams.getMaxChartFamilyFrequency())) {
                return new Pair(c, (Object)top);
            }
            double topScore = top.getScore();
            IRecommendedVisualization secondaryChoice = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !(topScore - (rec = (IRecommendedVisualization)iterator.next()).getScore() > irParams.getChartConfidenceRange())) {
                if (!IRVisualizerUtil.haveObservedChart(rec, observedChartFamilies, observedCharts, irParams.getMaxChartFamilyFrequency())) {
                    return new Pair(c, (Object)rec);
                }
                if (secondaryChoice != null || observedCharts.contains(rec.getLabel())) continue;
                secondaryChoice = rec;
            }
            return new Pair(c, (Object)(secondaryChoice == null ? top : secondaryChoice));
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (p1, p2) -> p1));
    }

    private static boolean haveObservedChart(IRecommendedVisualization chart, Map<ChartFamilyUtil.ChartFamily, Integer> observedChartFamilies, Set<String> observedCharts, int maxChartFamilyFrequency) {
        ChartFamilyUtil.ChartFamily family = ChartFamilyUtil.getChartFamily((String)chart.getLabel());
        int familyFrequency = observedChartFamilies.getOrDefault(family, 0);
        if (familyFrequency < maxChartFamilyFrequency && !observedCharts.contains(chart.getLabel())) {
            if (!family.equals((Object)ChartFamilyUtil.ChartFamily.NON_FAMILY)) {
                observedChartFamilies.put(family, familyFrequency + 1);
            }
            observedCharts.add(chart.getLabel());
            return false;
        }
        return true;
    }

    private static boolean isJoin(IRCombination combo, QuickAccessSmartsModule quick) {
        DatasetInfo lastDs = null;
        for (IRColumn column : combo.getColumnCombinations()) {
            if (lastDs == null) {
                lastDs = quick.getDatasetInfo(column.getId());
                continue;
            }
            if (lastDs == quick.getDatasetInfo(column.getId())) continue;
            return true;
        }
        return false;
    }
}

