/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.api.util;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.store.api.exceptions.StoreException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class StoreAsyncHelper {
    public static <T> T get(CompletableFuture<T> cf) {
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalException((Throwable)e, "Interrupted", new Object[0]);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                Throwable cause = e.getCause();
                if (cause instanceof StoreException) {
                    StoreException sex = (StoreException)((Object)cause);
                    throw sex;
                }
                throw new InternalException(cause, "ExecutionException with unexpected cause.", new Object[0]);
            }
            throw new InternalException((Throwable)e, "ExecutionException without cause.", new Object[0]);
        }
    }
}

