/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.annotator;

import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.questionanalyzer.core.annotator.IAnnotator;
import com.ibm.smarts.questionanalyzer.core.interpretation.Interpretation;
import com.ibm.smarts.questionanalyzer.core.interpretation.InterpretationUnit;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalyzerContext;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.TextInfo;
import java.util.ArrayList;
import java.util.List;

public class ConceptAnnotator
implements IAnnotator {
    public static final String NAME = "ConceptAnnotator";

    @Override
    public String getIdentifier() {
        return NAME;
    }

    @Override
    public List<Interpretation> annotate(AnalyzerContext ctx, Interpretation anInterpretation) throws Exception {
        ArrayList<Interpretation> result = new ArrayList<Interpretation>();
        Interpretation interpretation = new Interpretation(anInterpretation, NAME);
        result.add(interpretation);
        interpretation.getInterpretationUnits().parallelStream().filter(InterpretationUnit::requireSemanticAnalysis).forEach(iu -> {
            TextInfo textInfo = iu.toTextInfo(ctx.getRequestContext().locale.getLanguage());
            List concepts = ctx.getOntology().getTextConceptClassifier().classify(ctx.getRequestContext(), textInfo);
            this.addToSemanticAnnotation((InterpretationUnit)iu, concepts);
        });
        return result;
    }

    private void addToSemanticAnnotation(InterpretationUnit iu, List<List<ConceptInfo>> concepts) {
        List<SemanticAnnotation> sas = iu.getSemanticAnnotations();
        for (int i = 0; i < sas.size(); ++i) {
            sas.get(i).setConcepts(concepts.get(i));
        }
    }

    @Override
    public boolean isMandatory() {
        return true;
    }
}

