/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.interpretation;

import com.ibm.smarts.questionanalyzer.core.interpretation.InterpretationUnit;
import com.ibm.smarts.schema.NLPMentionsEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Interpretation {
    private List<InterpretationUnit> units = new ArrayList<InterpretationUnit>();
    private String annotator;
    private List<NLPMentionsEntity> entities;

    public Interpretation(String aAnnotator) {
        this.annotator = aAnnotator;
    }

    public Interpretation(Interpretation copy, String annotator) {
        this(annotator);
        this.copyIUs(copy);
        this.entities = copy.entities;
    }

    private void copyIUs(Interpretation copy) {
        for (InterpretationUnit iu : Collections.unmodifiableList(copy.getInterpretationUnits())) {
            InterpretationUnit unitCopy = new InterpretationUnit(iu);
            this.units.add(unitCopy);
        }
    }

    public boolean addInterpretationUnit(InterpretationUnit aUnit) {
        for (InterpretationUnit mCIU : this.units) {
            if (!mCIU.detectOverlap(aUnit)) continue;
            return false;
        }
        this.units.add(aUnit);
        return true;
    }

    public List<InterpretationUnit> getInterpretationUnits() {
        return this.units;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
    }

    public String getAnnotator() {
        return this.annotator;
    }

    public InterpretationUnit getIUByIndex(int index) {
        for (int i = 0; i < this.units.size(); ++i) {
            InterpretationUnit iu = this.units.get(i);
            if (iu.getStartIndex() != index) continue;
            return iu;
        }
        return null;
    }

    public synchronized int size() {
        return this.units.size();
    }

    public Float getScore() {
        return this.calcScore();
    }

    private Float calcScore() {
        return Float.valueOf(1.0f);
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        for (InterpretationUnit unit : this.units) {
            sb.append(unit.getText());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Annotator: ").append(this.getAnnotator()).append("\nInterpretationUnits:").append(this.getInterpretationUnits().stream().map(InterpretationUnit::toString).collect(Collectors.joining(", ")));
        return sb.toString();
    }

    public List<NLPMentionsEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<NLPMentionsEntity> entities) {
        this.entities = entities;
    }
}

