/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.registry;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ontology.registry.Concept;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptsRegistry {
    public static final String NAME_KEY = "name";
    public static final String IRI_KEY = "IRI";
    public static final String ONTOLOGY_ID_KEY = "ontologyID";
    public static final String IS_VISIBLE_KEY = "isVisible";
    public static final String CHILDREN_KEY = "children";
    public static final String PROPERTIES_KEY = "properties";
    private static final String CONCEPT_INFO_FILE = "/multi_domain_concepts.json";
    private static final ConceptsRegistry INSTANCE = new ConceptsRegistry();
    private final Map<String, Map<String, Concept>> multiDomainRegistry = new HashMap<String, Map<String, Concept>>();
    private Map<String, Concept> reverseConceptLookUp = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptsRegistry.class);

    private ConceptsRegistry() {
        this.initialize();
    }

    private void initialize() {
        try (InputStream inputStream = ConceptsRegistry.class.getResourceAsStream(CONCEPT_INFO_FILE);){
            JSONObject root = (JSONObject)JSON.parse((InputStream)inputStream);
            this.buildOntoMap(root, this.multiDomainRegistry);
        }
        catch (IOException e) {
            LOGGER.error("Could not load concepts JSON", (Throwable)e);
        }
    }

    public void buildOntoMap(JSONObject json, Map<String, Map<String, Concept>> multiDomainMap) {
        Set ontoIDs = json.keySet();
        for (Object ontoID : ontoIDs) {
            Map<String, Concept> ontoMap = this.buildOntoMap((JSONObject)json.get(ontoID));
            multiDomainMap.put((String)ontoID, ontoMap);
        }
    }

    private Map<String, Concept> buildOntoMap(JSONObject jsonConcept) {
        HashMap<String, Concept> ontoMap = new HashMap<String, Concept>();
        this.addConcept(jsonConcept, ontoMap);
        return ontoMap;
    }

    private Concept addConcept(JSONObject jsonConcept, Map<String, Concept> ontoMap) {
        String name = (String)jsonConcept.get((Object)NAME_KEY);
        String iri = (String)jsonConcept.get((Object)IRI_KEY);
        String ontologyID = (String)jsonConcept.get((Object)ONTOLOGY_ID_KEY);
        boolean isVisible = (Boolean)jsonConcept.get((Object)IS_VISIBLE_KEY);
        Concept concept = new Concept(iri, name);
        concept.setVisible(isVisible);
        concept.setOntologyID(ontologyID);
        this.addProperties(jsonConcept, concept);
        ontoMap.put(iri, concept);
        this.processChildren(jsonConcept, ontoMap, concept);
        return concept;
    }

    private void processChildren(JSONObject jsonConcept, Map<String, Concept> ontoMap, Concept concept) {
        if (jsonConcept.containsKey((Object)CHILDREN_KEY)) {
            JSONArray children = (JSONArray)jsonConcept.get((Object)CHILDREN_KEY);
            for (Object child : children) {
                JSONObject jsonChild = (JSONObject)child;
                Concept childConcept = ontoMap.get(jsonChild.get((Object)IRI_KEY)) == null ? this.addConcept(jsonChild, ontoMap) : ontoMap.get(jsonChild.get((Object)IRI_KEY));
                concept.addChild(childConcept);
            }
        }
    }

    private void addProperties(JSONObject jsonConcept, Concept concept) {
        JSONObject props = (JSONObject)jsonConcept.get((Object)PROPERTIES_KEY);
        if (props != null && !props.isEmpty()) {
            Set keys = props.keySet();
            for (Object key : keys) {
                concept.addProperty((String)key, (String)props.get(key));
            }
        }
    }

    public static ConceptsRegistry instance() {
        return INSTANCE;
    }

    public Concept getConcept(String iri) {
        Concept concept = this.fetchConceptFromRegistry(iri);
        if (concept == null) {
            LOGGER.debug("Unable to find concept by IRI [{}]. This indicates that the SmartsModulewas generated using an older version of the ontology and/or the clue files", (Object)iri);
            return Concept.UNKNOWN_CONCEPT;
        }
        if (!concept.isVisible()) {
            LOGGER.info("Concept [{}] is not available", (Object)iri);
            return Concept.UNKNOWN_CONCEPT;
        }
        return concept;
    }

    private Concept fetchConceptFromRegistry(String iri) {
        Concept concept = null;
        Collection<Map<String, Concept>> ontoMaps = this.multiDomainRegistry.values();
        for (Map<String, Concept> ontoMap : ontoMaps) {
            concept = ontoMap.get(iri);
            if (concept == null) continue;
            return concept;
        }
        return concept;
    }

    public Concept getConceptFromName(String name) {
        if (this.reverseConceptLookUp == null) {
            this.reverseConceptLookUp = this.multiDomainRegistry.get("http://www.ibm.com/ontologies/waca/domain/common").entrySet().stream().collect(Collectors.toMap(e -> ((Concept)e.getValue()).getName(), Map.Entry::getValue));
        }
        return this.reverseConceptLookUp.get(name);
    }

    public List<Concept> getConcepts(List<String> iris) {
        return iris.stream().map(this::getConcept).filter(c -> !c.equals(Concept.UNKNOWN_CONCEPT)).collect(Collectors.toList());
    }

    public List<Concept> getConceptChildren(String iri) {
        Concept concept = this.fetchConceptFromRegistry(iri);
        if (concept == null) {
            LOGGER.debug("Unable to find concept by IRI [{}]. This indicates that the SmartsModulewas generated using an older version of the ontology and/or the clue files", (Object)iri);
            return Collections.emptyList();
        }
        return concept.getChildren().stream().filter(Concept::isVisible).collect(Collectors.toList());
    }

    public Iterator<Map.Entry<String, Concept>> getEntryIterator() {
        return Collections.unmodifiableSet(this.multiDomainRegistry.get("http://www.ibm.com/ontologies/waca/domain/common").entrySet()).iterator();
    }

    public Map<String, Map<String, Concept>> getMultiDomainRegistry() {
        return Collections.unmodifiableMap(this.multiDomainRegistry);
    }
}

