/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.rules;

import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.smarts.common.util.SmartsModuleUtil;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.schema.InfluencerTuningParams;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedFieldsRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedFieldsRule.class);
    private InterestingFieldsRecommender recommender;
    private Map<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>> influencersMap = null;
    private Set<String> influencerCalls = null;
    private RequestContext requestContext = null;
    private SmartsModule smartsModule = null;
    private FieldsRecommendation moduleInterestingFields = null;
    private QuickAccessSmartsModule columnIdentifierMap;
    private Set<String> joinableTableIds = null;
    private AnalysisScope scopeNarrowedToDomainConceptFields;
    private final int MAX_INFLUENCERS_TO_CONSIDER = 20;
    private final long influencersTimeoutValue;
    private long influencersTimeElapsed = 0L;
    private InfluencerTuningParams influencerParams = null;
    private Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap;

    public RelatedFieldsRule(InterestingFieldsRecommender ifr, RequestContext rc, SmartsModule sm, QuickAccessSmartsModule ciMap, Set<String> joinableTables, long timeoutValue) {
        this.recommender = ifr;
        this.requestContext = rc;
        this.smartsModule = sm;
        this.columnIdentifierMap = ciMap;
        this.joinableTableIds = joinableTables;
        this.scopeNarrowedToDomainConceptFields = this.buildAnalysisScopeDomainConceptFields(sm);
        this.influencersTimeoutValue = timeoutValue;
        this.influencersTimeElapsed = 0L;
        this.influencerParams = new InfluencerTuningParams();
        this.influencerParams.setAllowCategoryTarget(Boolean.valueOf(true));
        this.influencerParams.setCorrelationUpperLimit(Float.valueOf(1.0f));
        this.influencerParams.setSemanticDelta(Float.valueOf(0.0f));
        this.bivariatesMap = new HashMap<String, Map<Pair<String, String>, BivariateStatistics>>();
        this.influencerCalls = new HashSet<String>();
    }

    private AnalysisScope buildAnalysisScopeDomainConceptFields(SmartsModule smartsModule) {
        AnalysisScope scope = new AnalysisScope();
        for (DatasetInfo ds : smartsModule.getDatasets()) {
            InScopeTable table = new InScopeTable();
            table.setTableID(ds.getId());
            List columns = com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
            ArrayList<Pair<ColumnInfo, Float>> domainConceptColumns = new ArrayList<Pair<ColumnInfo, Float>>();
            for (ColumnInfo ci : columns) {
                float conf = this.getDomainConceptConfidence(ci);
                if (!((double)conf > 0.0)) continue;
                Pair pair = new Pair((Object)ci, (Object)Float.valueOf(conf));
                domainConceptColumns.add((Pair<ColumnInfo, Float>)pair);
            }
            this.sort(domainConceptColumns);
            for (int ii = 0; ii < 20 && ii < domainConceptColumns.size(); ++ii) {
                table.getInScopeFieldIDs().add(((ColumnInfo)((Pair)domainConceptColumns.get(ii)).getFirst()).getId());
            }
            if (table.getInScopeFieldIDs().isEmpty()) continue;
            scope.getInScopeTables().add(table);
        }
        return scope;
    }

    private void sort(List<Pair<ColumnInfo, Float>> candidates) {
        Collections.sort(candidates, (pair1, pair2) -> {
            Float valA = (Float)pair1.getSecond();
            Float valB = (Float)pair2.getSecond();
            return -1 * valA.compareTo(valB);
        });
    }

    private float getDomainConceptConfidence(ColumnInfo field) {
        float domainConfidence = 0.0f;
        for (ConceptInfo ci : field.getSemanticInfo().getConcepts()) {
            if (!ConceptsUtil.getOntologyId((ConceptInfo)ci).equals("http://www.ibm.com/ontologies/waca/domain/common") || this.isUninteresting(ConceptsUtil.getConceptName((ConceptInfo)ci)) || !(ci.getConfidence() > domainConfidence)) continue;
            domainConfidence = ci.getConfidence();
        }
        return domainConfidence;
    }

    private boolean isUninteresting(String conceptName) {
        return conceptName.equals("Entity") || conceptName.equals("RowIdentifier") || conceptName.equals("Identifier") || conceptName.equals("Measure");
    }

    public AnalysisScope getScopeNarrowedToDomainConceptFields() {
        return this.scopeNarrowedToDomainConceptFields;
    }

    public void getTopInterestingFields(SmartsModule smartsModule, int n) {
        if (this.recommender == null || this.scopeNarrowedToDomainConceptFields.getInScopeTables().isEmpty() || this.influencersTimeout()) {
            return;
        }
        long interestingStart = System.currentTimeMillis();
        this.moduleInterestingFields = this.recommender.recommendInterestingFields(this.requestContext, smartsModule, null, this.bivariatesMap);
        long interestingEnd = System.currentTimeMillis();
        this.influencersTimeElapsed += interestingEnd - interestingStart;
        LOGGER.info("Related-vis called InterestingFields. Time elapsed = " + (interestingEnd - interestingStart) + " ms. Num results = " + this.moduleInterestingFields.getRecommendedFields().size());
        int count = 0;
        for (FieldRecommendationRecord fieldRec : this.moduleInterestingFields.getRecommendedFields()) {
            if (this.influencersTimeout()) {
                return;
            }
            if (!this.addPotentiallyInterestingField(fieldRec.getFieldIDForExpression()) || n <= 0 || ++count < n) continue;
            return;
        }
    }

    private boolean influencersTimeout() {
        return this.influencersTimeoutValue > 0L && this.influencersTimeElapsed > this.influencersTimeoutValue;
    }

    private List<RelatedVisualizationCandidate> calcModuleInterestingFieldCandidates(Set<String> mostInterestingSet, int n) {
        ArrayList<RelatedVisualizationCandidate> mostInteresting = new ArrayList<RelatedVisualizationCandidate>();
        if (this.moduleInterestingFields == null) {
            this.getTopInterestingFields(this.smartsModule, n);
        }
        if (this.moduleInterestingFields != null) {
            for (int ii = 0; ii < this.moduleInterestingFields.getRecommendedFields().size(); ++ii) {
                String columnId = ((FieldRecommendationRecord)this.moduleInterestingFields.getRecommendedFields().get(ii)).getFieldIDForExpression();
                RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(columnId);
                candidate.setInterestingnessScore(Double.valueOf(((FieldRecommendationRecord)this.moduleInterestingFields.getRecommendedFields().get(ii)).getConfidence()), 2.0);
                mostInteresting.add(new RelatedVisualizationCandidate(columnId));
                mostInterestingSet.add(columnId);
                if (mostInteresting.size() != n) continue;
                return mostInteresting;
            }
        }
        return mostInteresting;
    }

    private double cumulativeConfidence(Map<ColumnIdentifier, FieldRecommendationRecord> fieldsMap) {
        Iterator<Map.Entry<ColumnIdentifier, FieldRecommendationRecord>> it = fieldsMap.entrySet().iterator();
        float accumulation = 0.0f;
        while (it.hasNext()) {
            Map.Entry<ColumnIdentifier, FieldRecommendationRecord> pair = it.next();
            accumulation += pair.getValue().getConfidence();
        }
        return accumulation;
    }

    private List<Map.Entry<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>>> getSortedInterestingFields() {
        ArrayList<Map.Entry<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>>> sortableList = new ArrayList<Map.Entry<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>>>(this.influencersMap.entrySet());
        Collections.sort(sortableList, (o1, o2) -> {
            double conf2;
            if (((Map)o1.getValue()).size() < ((Map)o2.getValue()).size()) {
                return 1;
            }
            if (((Map)o1.getValue()).size() > ((Map)o2.getValue()).size()) {
                return -1;
            }
            double conf1 = this.cumulativeConfidence((Map)o1.getValue());
            if (conf1 < (conf2 = this.cumulativeConfidence((Map)o2.getValue()))) {
                return 1;
            }
            if (conf2 < conf1) {
                return -1;
            }
            ColumnIdentifier key1 = (ColumnIdentifier)o1.getKey();
            ColumnIdentifier key2 = (ColumnIdentifier)o2.getKey();
            return key1.columnIdForExpression.compareTo(key2.columnIdForExpression);
        });
        return sortableList;
    }

    public List<RelatedVisualizationCandidate> getOrderedInterestingFields(int n) {
        HashSet<String> mostInterestingSet = new HashSet<String>();
        List<RelatedVisualizationCandidate> mostInteresting = this.calcModuleInterestingFieldCandidates(mostInterestingSet, n);
        if (mostInteresting.size() >= n) {
            return mostInteresting;
        }
        List<Map.Entry<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>>> sortedFields = this.getSortedInterestingFields();
        int maxNumInfluencers = 0;
        for (int ii = 0; ii < sortedFields.size() && mostInteresting.size() < n; ++ii) {
            Map.Entry<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>> entry = sortedFields.get(ii);
            String columnId = entry.getKey().columnIdForExpression;
            if (mostInterestingSet.contains(columnId)) continue;
            if (maxNumInfluencers == 0) {
                maxNumInfluencers = entry.getValue().size();
            }
            RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(columnId);
            candidate.setInterestingnessScore((double)entry.getValue().size() / (double)maxNumInfluencers);
            mostInteresting.add(candidate);
            mostInterestingSet.add(columnId);
        }
        return mostInteresting;
    }

    public boolean addPotentiallyInterestingField(String fieldId) {
        FieldsRecommendation fields;
        if (this.recommender == null || this.scopeNarrowedToDomainConceptFields.getInScopeTables().isEmpty() || this.influencersTimeout() || this.alreadyCheckedInfluencersFor(fieldId)) {
            return false;
        }
        long influnecersStart = System.currentTimeMillis();
        Optional joinGraphOptional = SmartsModuleUtil.getJoinGraph((RequestContext)this.requestContext, (String)this.smartsModule.getId());
        if (joinGraphOptional.isPresent() && joinGraphOptional.get() != null) {
            JoinGraph joinGraph = (JoinGraph)joinGraphOptional.get();
            List relatedColumnIds = SmartsModuleUtil.getRelatedColumnIds((JoinGraph)joinGraph, Arrays.asList(fieldId));
            fields = this.recommender.recommendInfluencers(this.requestContext, this.smartsModule, fieldId, this.scopeNarrowedToDomainConceptFields, this.influencerParams, relatedColumnIds, this.bivariatesMap);
        } else {
            fields = this.recommender.recommendInfluencers(this.requestContext, this.smartsModule, fieldId, this.scopeNarrowedToDomainConceptFields, this.influencerParams, this.joinableTableIds, this.bivariatesMap);
        }
        long influencersEnd = System.currentTimeMillis();
        this.influencerCalls.add(fieldId);
        LOGGER.info("Related-vis called Influencers on fieldId = " + fieldId + ". Time elapsed = " + (influencersEnd - influnecersStart) + " ms. Num influencers = " + fields.getRecommendedFields().size());
        this.influencersTimeElapsed += influencersEnd - influnecersStart;
        if (this.influencersMap == null) {
            this.influencersMap = new HashMap<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>>();
        }
        for (FieldRecommendationRecord fieldRec : fields.getRecommendedFields()) {
            this.addToMap(fieldId, fieldRec);
        }
        return true;
    }

    private boolean alreadyCheckedInfluencersFor(String fieldId) {
        return this.influencerCalls != null && this.influencerCalls.contains(fieldId);
    }

    public boolean wouldBeViolated(RelatedVisualizationCandidate candidate, Set<ColumnIdentifier> inViewSet) {
        if (this.influencersMap == null) {
            return false;
        }
        ColumnIdentifier columnIdentifier1 = this.getColumnIdentifier(candidate.getField1());
        ColumnIdentifier columnIdentifier2 = this.getColumnIdentifier(candidate.getField2());
        ColumnIdentifier columnIdentifier3 = this.getColumnIdentifier(candidate.getField3());
        ColumnIdentifier columnIdentifier4 = this.getColumnIdentifier(candidate.getField4());
        return !this.introducesNewInterestingRelation(columnIdentifier1, columnIdentifier2, inViewSet) && !this.introducesNewInterestingRelation(columnIdentifier1, columnIdentifier3, inViewSet) && !this.introducesNewInterestingRelation(columnIdentifier1, columnIdentifier4, inViewSet) && !this.introducesNewInterestingRelation(columnIdentifier2, columnIdentifier3, inViewSet) && !this.introducesNewInterestingRelation(columnIdentifier2, columnIdentifier4, inViewSet) && !this.introducesNewInterestingRelation(columnIdentifier3, columnIdentifier4, inViewSet);
    }

    private ColumnIdentifier getColumnIdentifier(String idForExpression) {
        if (idForExpression == null || idForExpression.isEmpty()) {
            return null;
        }
        return this.columnIdentifierMap.getColumnIdentifier(idForExpression);
    }

    private boolean introducesNewInterestingRelation(ColumnIdentifier field1, ColumnIdentifier field2, Set<ColumnIdentifier> inViewSet) {
        if (inViewSet.contains(field1) && inViewSet.contains(field2)) {
            return false;
        }
        return this.influencersMap.containsKey(field1) && this.influencersMap.get(field1).containsKey(field2) || this.influencersMap.containsKey(field2) && this.influencersMap.get(field2).containsKey(field1);
    }

    public double getInterestingnessConfidence(String field1, String field2) {
        if (this.influencersMap == null) {
            return 0.0;
        }
        ColumnIdentifier cid1 = this.getColumnIdentifier(field1);
        ColumnIdentifier cid2 = this.getColumnIdentifier(field2);
        if (this.influencersMap.containsKey(cid1) && this.influencersMap.get(cid1).containsKey(cid2)) {
            return this.influencersMap.get(cid1).get(cid2).getConfidence();
        }
        if (this.influencersMap.containsKey(cid2) && this.influencersMap.get(cid2).containsKey(cid1)) {
            return this.influencersMap.get(cid2).get(cid1).getConfidence();
        }
        return 0.0;
    }

    private void addToMap(String fieldId, FieldRecommendationRecord fieldRecommendationRecord) {
        if (!this.influencersMap.containsKey(this.columnIdentifierMap.getColumnIdentifier(fieldId))) {
            this.influencersMap.put(this.columnIdentifierMap.getColumnIdentifier(fieldId), new HashMap());
        }
        String influencedByFieldId = fieldRecommendationRecord.getFieldIDForExpression();
        this.influencersMap.get(this.columnIdentifierMap.getColumnIdentifier(fieldId)).put(this.columnIdentifierMap.getColumnIdentifier(influencedByFieldId), fieldRecommendationRecord);
        if (!this.influencersMap.containsKey(this.columnIdentifierMap.getColumnIdentifier(influencedByFieldId))) {
            this.influencersMap.put(this.columnIdentifierMap.getColumnIdentifier(influencedByFieldId), new HashMap());
        }
        this.influencersMap.get(this.columnIdentifierMap.getColumnIdentifier(influencedByFieldId)).put(this.columnIdentifierMap.getColumnIdentifier(fieldId), fieldRecommendationRecord);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("related-vis added " + this.columnIdentifierMap.getColumnIdentifier((String)influencedByFieldId).columnIdForExpression + " <- as influencer for -> " + this.columnIdentifierMap.getColumnIdentifier((String)fieldId).columnIdForExpression + " with strength: " + fieldRecommendationRecord.getConfidence());
        }
    }

    public Map<ColumnIdentifier, Map<ColumnIdentifier, FieldRecommendationRecord>> getInfluencersMap() {
        return this.influencersMap;
    }

    public FieldsRecommendation getModuleInterestingFields() {
        return this.moduleInterestingFields;
    }
}

