/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.rules;

import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Hierarchy;
import com.ibm.smarts.schema.LogicalGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RelatedVisualizationHierarchyRule {
    private List<DatasetInfo> dataSets = null;
    private Map<String, List<Integer>> fieldToHierarchyLevel = null;
    private Map<String, List<Integer>> observedFieldToHierarchyLevel = null;
    private Map<String, List<String>> unsplittableLogicalGroupings = null;
    private Map<String, String> unsplittableLogicalGroupingsReversed = null;
    private Map<String, ColumnInfo> columnInfoMap = null;
    private QuickAccessSmartsModule columnIdentifierMap = null;
    private static final String DOMAIN_CONCEPT_PREFIX = "/domain";

    public RelatedVisualizationHierarchyRule(Map<String, ColumnInfo> columnInfoMap, QuickAccessSmartsModule columnIdentifierMap) {
        this.dataSets = columnIdentifierMap.getSmartsModule().getDatasets();
        this.columnInfoMap = columnInfoMap;
        this.columnIdentifierMap = columnIdentifierMap;
    }

    public void observe(RelatedVisualizationCandidate pairing) {
        if (this.fieldToHierarchyLevel == null) {
            this.initFieldToHierarchLevelMap();
        }
        if (this.fieldToHierarchyLevel.containsKey(pairing.getField1())) {
            this.updateObserved(pairing.getField2(), this.fieldToHierarchyLevel.get(pairing.getField1()));
        }
        if (this.fieldToHierarchyLevel.containsKey(pairing.getField2())) {
            this.updateObserved(pairing.getField1(), this.fieldToHierarchyLevel.get(pairing.getField2()));
        }
    }

    public boolean wouldBeViolated(RelatedVisualizationCandidate pairing) {
        List<Integer> potential;
        List<Integer> observed;
        if (this.fieldToHierarchyLevel == null) {
            this.initFieldToHierarchLevelMap();
        }
        if (this.referencesSameHierarchy(pairing)) {
            return true;
        }
        if (this.splitsLogicalGroup(pairing)) {
            return true;
        }
        if (this.observedFieldToHierarchyLevel == null) {
            return false;
        }
        if (this.observedFieldToHierarchyLevel.containsKey(pairing.getField1())) {
            observed = this.observedFieldToHierarchyLevel.get(pairing.getField1());
            potential = this.fieldToHierarchyLevel.get(pairing.getField2());
            if (potential != null && this.overlap(observed, potential)) {
                return true;
            }
        }
        if (this.observedFieldToHierarchyLevel.containsKey(pairing.getField2())) {
            observed = this.observedFieldToHierarchyLevel.get(pairing.getField2());
            potential = this.fieldToHierarchyLevel.get(pairing.getField1());
            if (potential != null && this.overlap(observed, potential)) {
                return true;
            }
        }
        return false;
    }

    public boolean splitsLogicalGroup(RelatedVisualizationCandidate pairing) {
        HashSet<String> groupsSatisified = new HashSet<String>();
        String logicalGroupId = this.getLogicalGroup(pairing.getField1());
        if (logicalGroupId != null && this.logicalGroupSplit(logicalGroupId, pairing)) {
            return true;
        }
        groupsSatisified.add(logicalGroupId);
        logicalGroupId = this.getLogicalGroup(pairing.getField2());
        if (logicalGroupId != null && !groupsSatisified.contains(logicalGroupId) && this.logicalGroupSplit(logicalGroupId, pairing)) {
            return true;
        }
        groupsSatisified.add(logicalGroupId);
        logicalGroupId = this.getLogicalGroup(pairing.getField3());
        if (logicalGroupId != null && !groupsSatisified.contains(logicalGroupId) && this.logicalGroupSplit(logicalGroupId, pairing)) {
            return true;
        }
        groupsSatisified.add(logicalGroupId);
        logicalGroupId = this.getLogicalGroup(pairing.getField4());
        if (logicalGroupId != null && !groupsSatisified.contains(logicalGroupId)) {
            return this.logicalGroupSplit(logicalGroupId, pairing);
        }
        return false;
    }

    private String getLogicalGroup(String columnIdForExpression) {
        if (columnIdForExpression == null || this.unsplittableLogicalGroupingsReversed == null) {
            return null;
        }
        return this.unsplittableLogicalGroupingsReversed.get(columnIdForExpression);
    }

    private boolean logicalGroupSplit(String logicalGroupId, RelatedVisualizationCandidate candidate) {
        List<String> members = this.unsplittableLogicalGroupings.get(logicalGroupId);
        if (members != null) {
            Set<String> chartColumns = candidate.fieldsAsSet();
            for (String member : members) {
                if (chartColumns.contains(member)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean referencesSameHierarchy(RelatedVisualizationCandidate pairing) {
        List<Integer> potential1 = this.fieldToHierarchyLevel.get(pairing.getField1());
        List<Integer> potential2 = this.fieldToHierarchyLevel.get(pairing.getField2());
        ArrayList<Integer> potential3 = pairing.getField3() != null ? this.fieldToHierarchyLevel.get(pairing.getField3()) : new ArrayList<Integer>();
        return this.overlap(potential1, potential2) || this.overlap(potential2, potential3) || this.overlap(potential1, potential3);
    }

    private boolean overlap(List<Integer> list1, List<Integer> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        List intersect = list1.stream().filter(list2::contains).collect(Collectors.toList());
        return !intersect.isEmpty();
    }

    private void updateObserved(String id, List<Integer> hierarchiesById) {
        if (this.observedFieldToHierarchyLevel == null) {
            this.observedFieldToHierarchyLevel = new HashMap<String, List<Integer>>();
        }
        if (!this.observedFieldToHierarchyLevel.containsKey(id)) {
            this.observedFieldToHierarchyLevel.put(id, new ArrayList());
        }
        this.observedFieldToHierarchyLevel.get(id).addAll(hierarchiesById);
    }

    public void initFieldToHierarchLevelMap() {
        this.fieldToHierarchyLevel = new HashMap<String, List<Integer>>();
        this.unsplittableLogicalGroupings = new HashMap<String, List<String>>();
        this.unsplittableLogicalGroupingsReversed = new HashMap<String, String>();
        int hierarchyId = 0;
        for (DatasetInfo dataSet : this.dataSets) {
            List hierarchies = dataSet.getHierarchies();
            List groups = dataSet.getLogicalGroups();
            Map<String, List<String>> groupIdToColumnIds = this.processLogicalGroups(groups, dataSet.getId());
            for (int h = 0; h < hierarchies.size(); ++h) {
                Hierarchy hierarchy = (Hierarchy)hierarchies.get(h);
                for (Hierarchy.Level level : hierarchy.getLevel()) {
                    if (!groupIdToColumnIds.containsKey(level.getGroupId())) continue;
                    List<String> columnIds = groupIdToColumnIds.get(level.getGroupId());
                    for (String columnId : columnIds) {
                        String idForExpression = this.columnIdentifierMap.getColumnIdentifier((String)dataSet.getId(), (String)columnId).columnIdForExpression;
                        if (!this.fieldToHierarchyLevel.containsKey(idForExpression)) {
                            this.fieldToHierarchyLevel.put(idForExpression, new ArrayList());
                        }
                        this.fieldToHierarchyLevel.get(idForExpression).add(h + hierarchyId);
                    }
                }
            }
            hierarchyId = hierarchies.size();
        }
    }

    private Map<String, List<String>> processLogicalGroups(List<LogicalGroup> groups, String datasetId) {
        HashMap<String, List<String>> groupIdToColumnIds = new HashMap<String, List<String>>();
        for (LogicalGroup group : groups) {
            String groupId = group.getId();
            if (groupIdToColumnIds.containsKey(groupId)) continue;
            ArrayList<String> columnIds = new ArrayList<String>();
            for (LogicalGroup.Member member : group.getMember()) {
                columnIds.add(member.getColumnId());
            }
            groupIdToColumnIds.put(groupId, columnIds);
            this.searchForUnsplittableGroups(groupId, columnIds, datasetId);
        }
        return groupIdToColumnIds;
    }

    private void addDomainConcept(String columnId, Set<String> parentDomainsInGroup, String datasetId) {
        String idForExpression = this.columnIdentifierMap.getColumnIdentifier((String)datasetId, (String)columnId).columnIdForExpression;
        if (this.columnInfoMap.containsKey(idForExpression)) {
            ColumnInfo columnInfo = this.columnInfoMap.get(idForExpression);
            Concept parentDomain = this.getDomainConcept(ConceptsRegistry.instance().getConcepts(columnInfo.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())));
            if (parentDomain != null) {
                parentDomainsInGroup.add(parentDomain.getName());
            }
        }
    }

    private void searchForUnsplittableGroups(String groupId, List<String> columnIds, String datasetId) {
        if (columnIds.size() > 1) {
            HashSet<String> parentDomainsInGroup = new HashSet<String>();
            for (String columnId : columnIds) {
                this.addDomainConcept(columnId, parentDomainsInGroup, datasetId);
                if (parentDomainsInGroup.size() <= 1) continue;
                return;
            }
            if (parentDomainsInGroup.size() == 1) {
                for (String columnId : columnIds) {
                    String idForExpression = this.columnIdentifierMap.getColumnIdentifier((String)datasetId, (String)columnId).columnIdForExpression;
                    if (!this.unsplittableLogicalGroupings.containsKey(groupId)) {
                        this.unsplittableLogicalGroupings.put(groupId, new ArrayList());
                    }
                    this.unsplittableLogicalGroupings.get(groupId).add(idForExpression);
                    this.unsplittableLogicalGroupingsReversed.put(idForExpression, groupId);
                }
            }
        }
    }

    private static boolean isNonTrivialDomainConcept(Concept concept) {
        return concept.getIRI().contains(DOMAIN_CONCEPT_PREFIX) && !concept.getName().equals("Measure") && !concept.getName().equals("Immutable") && !concept.getName().equals("Entity");
    }

    private Concept getDomainConcept(List<Concept> concepts) {
        Concept domainNotParent = null;
        for (Concept concept : concepts) {
            Optional<Concept> parentDomain = concept.getParents().stream().filter(RelatedVisualizationHierarchyRule::isNonTrivialDomainConcept).findFirst();
            if (parentDomain.isPresent()) {
                return parentDomain.get();
            }
            if (!RelatedVisualizationHierarchyRule.isNonTrivialDomainConcept(concept) || domainNotParent != null) continue;
            domainNotParent = concept;
        }
        return domainNotParent;
    }

    public Map<String, List<String>> getUnsplittableGroups() {
        return this.unsplittableLogicalGroupings;
    }
}

