/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.rules;

import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationScoring;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelatedVisualizationSimilarityRule {
    private Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> bivariateMap = null;
    private RelatedVisualizationScoring scoringRules = null;
    private QuickAccessSmartsModule columnIdentifierMap = null;
    Map<String, List<String>> observedFieldToRelatedFields = null;

    public RelatedVisualizationSimilarityRule(Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> statistics, RelatedVisualizationScoring scoring, QuickAccessSmartsModule cMap) {
        this.bivariateMap = statistics;
        this.scoringRules = scoring;
        this.columnIdentifierMap = cMap;
    }

    public void observe(RelatedVisualizationCandidate pairing) {
        if (this.observedFieldToRelatedFields == null) {
            this.initFieldToRelatedFieldsMap();
        }
        this.updateObserved(pairing.getField1(), pairing.getField2(), pairing.getField3());
    }

    private void initFieldToRelatedFieldsMap() {
        this.observedFieldToRelatedFields = new HashMap<String, List<String>>();
    }

    private void updateObserved(String field1, String field2, String field3) {
        if (field3 != null) {
            this.observeAllCombinations(field1, field2, field3);
        } else {
            if (!this.observedFieldToRelatedFields.containsKey(field1)) {
                this.observedFieldToRelatedFields.put(field1, new ArrayList());
            }
            this.observedFieldToRelatedFields.get(field1).add(field2);
            if (!this.observedFieldToRelatedFields.containsKey(field2)) {
                this.observedFieldToRelatedFields.put(field2, new ArrayList());
            }
            this.observedFieldToRelatedFields.get(field2).add(field1);
        }
    }

    public boolean wouldBeViolated(RelatedVisualizationCandidate pairing) {
        if (this.observedFieldToRelatedFields == null) {
            return false;
        }
        return this.checkIfHasSimilar(pairing.getField1(), pairing.getField2(), pairing.getField3());
    }

    private boolean checkIfHasSimilar(String field1, String field2, String field3) {
        if (field3 != null) {
            return this.checkAllCombinations(field1, field2, field3);
        }
        return this.checkIfHasSimilar(field1, field2);
    }

    private void observeAllCombinations(String field1, String field2, String field3) {
        String key = this.makeTwoFieldKey(field1, field2);
        if (!this.observedFieldToRelatedFields.containsKey(key)) {
            this.observedFieldToRelatedFields.put(key, new ArrayList());
        }
        this.observedFieldToRelatedFields.get(key).add(field3);
        key = this.makeTwoFieldKey(field2, field3);
        if (!this.observedFieldToRelatedFields.containsKey(key)) {
            this.observedFieldToRelatedFields.put(key, new ArrayList());
        }
        this.observedFieldToRelatedFields.get(key).add(field1);
        key = this.makeTwoFieldKey(field1, field3);
        if (!this.observedFieldToRelatedFields.containsKey(key)) {
            this.observedFieldToRelatedFields.put(key, new ArrayList());
        }
        this.observedFieldToRelatedFields.get(key).add(field2);
    }

    private boolean checkAllCombinations(String field1, String field2, String field3) {
        String key = this.makeTwoFieldKey(field1, field2);
        if (this.checkIfHasSimilar(key, field3)) {
            return true;
        }
        key = this.makeTwoFieldKey(field1, field3);
        if (this.checkIfHasSimilar(key, field2)) {
            return true;
        }
        key = this.makeTwoFieldKey(field2, field3);
        return this.checkIfHasSimilar(key, field1);
    }

    private String makeTwoFieldKey(String field1, String field2) {
        if (field1.compareTo(field2) < 0) {
            return field1 + "|" + field2;
        }
        return field2 + "|" + field1;
    }

    private boolean checkIfHasSimilar(String fieldKey, String field3) {
        if (!this.observedFieldToRelatedFields.containsKey(fieldKey)) {
            return false;
        }
        List<String> previouslyPaired = this.observedFieldToRelatedFields.get(fieldKey);
        for (String prevId : previouslyPaired) {
            if (!this.isCorrelated(field3, prevId)) continue;
            return true;
        }
        return false;
    }

    private boolean isCorrelated(String columnId, String prevId) {
        BivariateStatistics bivariate;
        double d;
        Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> datasetBivariates = this.bivariateMap.get(this.columnIdentifierMap.getColumnIdentifier((String)columnId).datasetId);
        if (datasetBivariates == null || !datasetBivariates.containsKey(this.columnIdentifierMap.getColumnIdentifier(columnId))) {
            return false;
        }
        Map<ColumnIdentifier, BivariateStatistics> bivariates = this.bivariateMap.get(this.columnIdentifierMap.getColumnIdentifier((String)columnId).datasetId).get(this.columnIdentifierMap.getColumnIdentifier(columnId));
        return bivariates.containsKey(this.columnIdentifierMap.getColumnIdentifier(prevId)) && (d = this.scoringRules.extractStatistic((bivariate = bivariates.get(this.columnIdentifierMap.getColumnIdentifier(prevId))).getStatistics(), false, true)) > 0.5;
    }
}

