/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.util;

import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class ContinuationToken {
    private Map<String, Integer> columnIdToIndex = new HashMap<String, Integer>();
    boolean isContinuationPossible = false;
    private Set<String> previousSolutions = new HashSet<String>();

    public ContinuationToken() {
    }

    public ContinuationToken(List<ColumnInfo> columns, String token) {
        int counter = 0;
        for (ColumnInfo ci : columns) {
            this.columnIdToIndex.put(ci.getIdForExpression(), counter);
            ++counter;
        }
        this.restoreFromToken(token);
    }

    public void addSolutions(List<VisRecommendation> relatedCharts, QuickAccessSmartsModule columnIdentifierMap) {
        for (VisRecommendation relChart : relatedCharts) {
            ArrayList<ColumnIdentifier> setOfColumns = new ArrayList<ColumnIdentifier>();
            for (VisColumn visCol : relChart.getColumns()) {
                for (String id : visCol.getId()) {
                    ColumnIdentifier ci = columnIdentifierMap.getColumnIdentifier(id);
                    setOfColumns.add(ci);
                }
            }
            this.addSolution(setOfColumns);
        }
    }

    public void addSolution(List<ColumnIdentifier> setOfColumns) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        HashSet<Integer> uniqueList = new HashSet<Integer>();
        for (ColumnIdentifier col : setOfColumns) {
            int c = this.columnIdToIndex.get(col.columnIdForExpression);
            if (uniqueList.contains(c)) continue;
            indexList.add(c);
            uniqueList.add(c);
        }
        Collections.sort(indexList);
        StringBuilder sb = new StringBuilder();
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!sb.toString().isEmpty()) {
                sb.append(",");
            }
            sb.append(index);
        }
        this.addSolution(sb.toString());
    }

    public boolean previouslyAttempted(VisRecommendation visRec) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int ii = 0; ii < visRec.getColumns().size(); ++ii) {
            for (String id : ((VisColumn)visRec.getColumns().get(ii)).getId()) {
                ids.add(id);
            }
        }
        RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(ids);
        return this.previouslyAttempted(candidate);
    }

    public boolean previouslyAttempted(RelatedVisualizationCandidate candidate) {
        if (this.previousSolutions.isEmpty()) {
            return false;
        }
        int index1 = this.columnIdToIndex.get(candidate.getField1());
        int index2 = candidate.getField2() == null ? -1 : this.columnIdToIndex.get(candidate.getField2());
        int index3 = candidate.getField3() == null ? -1 : this.columnIdToIndex.get(candidate.getField3());
        int index4 = candidate.getField4() == null ? -1 : this.columnIdToIndex.get(candidate.getField4());
        String translated = this.makeSolution(index1, index2, index3, index4);
        return this.previousSolutions.contains(translated);
    }

    private String makeSolution(int index1, int index2, int index3, int index4) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        indexList.add(index1);
        indexList.add(index2);
        if (index3 >= 0) {
            indexList.add(index3);
        }
        if (index4 >= 0) {
            indexList.add(index4);
        }
        Collections.sort(indexList);
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            int ii = (Integer)iterator.next();
            if (!sb.toString().isEmpty()) {
                sb.append(",");
            }
            sb.append(ii);
        }
        return sb.toString();
    }

    public void addSolution(String solutionAsStr) {
        this.previousSolutions.add(solutionAsStr);
    }

    private String outputSolutionsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.previousSolutions) {
            sb.append(str);
            sb.append("|");
        }
        return sb.toString();
    }

    private Set<String> convertStringToSolutions(String decodedToken) {
        StringBuilder listEntry = new StringBuilder();
        for (int idx = 0; idx < decodedToken.length(); ++idx) {
            char ch = decodedToken.charAt(idx);
            if (ch != '|') {
                listEntry.append(ch);
                continue;
            }
            this.previousSolutions.add(listEntry.toString());
            listEntry = new StringBuilder();
        }
        if (!listEntry.toString().isEmpty()) {
            this.previousSolutions.add(listEntry.toString());
        }
        return this.previousSolutions;
    }

    public String makeContinuationToken() {
        if (!this.isContinuationPossible) {
            return "";
        }
        String str = this.outputSolutionsAsString();
        byte[] encodedBytes = Base64.encodeBase64((byte[])str.getBytes());
        return new String(encodedBytes);
    }

    public Set<String> restoreFromToken(String token) {
        if (token != null) {
            byte[] decodedBytes = Base64.decodeBase64((byte[])token.getBytes());
            return this.convertStringToSolutions(new String(decodedBytes));
        }
        return new HashSet<String>();
    }

    public void setIsContinuationPossible(boolean isForSure) {
        this.isContinuationPossible = isForSure;
    }

    public boolean getIsContinuationPossible() {
        return this.isContinuationPossible;
    }
}

