/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.util;

import com.ibm.smarts.combinations.generator.exceptions.ColumnNotFoundException;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.relatedvisualizations.exception.RelatedVisualizationException;
import com.ibm.smarts.relatedvisualizations.rules.RelatedFieldsRule;
import com.ibm.smarts.relatedvisualizations.rules.RelatedVisualizationHierarchyRule;
import com.ibm.smarts.relatedvisualizations.rules.RelatedVisualizationSimilarityRule;
import com.ibm.smarts.relatedvisualizations.util.ContinuationToken;
import com.ibm.smarts.relatedvisualizations.util.IRelatedContentAdvisor;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationParameters;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationScoring;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.StatisticsUtil;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.useractions.actions.VisualizationPayload;
import com.ibm.smarts.visualization.recommender.api.VisRecommenderSupport;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.SmartsResult;
import com.ibm.smarts.visualization.recommender.schema.SmartsStatus;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedVisualizationAdvisor
implements IRelatedContentAdvisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedVisualizationAdvisor.class);
    private HashMap<String, ColumnInfo> columnInfoMap = new HashMap();
    private HashSet<String> candidateKeyMap = new HashSet();
    private HashSet<ColumnIdentifier> inViewSet = new HashSet();
    private HashSet<ColumnIdentifier> outOfViewSet = new HashSet();
    private QuickAccessSmartsModule indexedSmartsModule = null;
    private RelatedVisualizationHierarchyRule hierarchyRule = null;
    private RelatedVisualizationSimilarityRule similarityRule = null;
    private RelatedFieldsRule interestingFieldsRule = null;
    private static final int NUM_CANDIDATES_UPPER_BOUND = 1000;
    private static final long DEFAULT_VIS_REC_TIMEOUT = 10000L;
    private static final int CLEAN_SOLUTION_BONUS = 10000;
    private static final int UNDESIRABLE_PENALTY = 10000;
    private static final int TOO_MANY_CATEGORIES = 100;
    private VisRecommenderSupport recommender = null;
    private IUserActionStore userActionStore = null;
    private InterestingFieldsRecommender interestingFieldsRecommender = null;
    private RelatedVisualizationScoring scoringRules = null;
    boolean emptyVisualizationEntireSmartsModule = false;
    public boolean smartsModuleReady = true;
    private long requestStartTime = 0L;
    private long combinationTimeoutValue = 0L;
    private long buildRelatedTimeoutValue = 0L;
    private long influencersTimeoutValue = 6000L;
    private RelatedVisualizationParameters params = new RelatedVisualizationParameters();
    private HashMap<String, HashMap<String, Boolean>> likelyJoinableDatasets = new HashMap();
    private ContinuationToken continuationToken = null;

    public RelatedVisualizationAdvisor(VisRecommenderSupport recommender) {
        this.recommender = recommender;
    }

    public RelatedVisualizationAdvisor(VisRecommenderSupport recommender, IUserActionStore userActionStore) {
        this.recommender = recommender;
        this.userActionStore = userActionStore;
    }

    public RelatedVisualizationAdvisor(VisRecommenderSupport recommender, IUserActionStore userActionStore, InterestingFieldsRecommender ifr) {
        this.recommender = recommender;
        this.userActionStore = userActionStore;
        this.interestingFieldsRecommender = ifr;
    }

    public boolean getSkipVisRecommender() {
        return this.params.skipCharts;
    }

    @Override
    public List<VisRecommendation> suggestRelated(RequestContext context, VisualizationPayload visualization, SmartsModule smartsModule, RelatedVisualizationParameters inputParameters) throws RelatedVisualizationException {
        if (smartsModule == null || smartsModule.getDatasets() == null || smartsModule.getDatasets().isEmpty()) {
            return new ArrayList<VisRecommendation>();
        }
        if (!this.smartsModuleHasSufficientlyProgressed(smartsModule, "smarts.dds.predict")) {
            this.smartsModuleReady = false;
            return new ArrayList<VisRecommendation>();
        }
        this.indexedSmartsModule = new QuickAccessSmartsModule(smartsModule);
        this.indexedSmartsModule.maybeCreateIndices();
        this.params = inputParameters;
        this.setTimeouts(this.params.timeout);
        this.scoringRules = new RelatedVisualizationScoring(this.userActionStore, this.columnInfoMap, this.indexedSmartsModule);
        List<ColumnIdentifier> inView = this.getInView(context, smartsModule, visualization, this.params.incomingContinuationToken);
        this.logInput("Input to related-visualizations:", inView);
        this.getOutOfView(smartsModule, inView);
        List<RelatedVisualizationCandidate> potentialInterestingFields = this.generatePotentialSingles();
        if (!potentialInterestingFields.isEmpty()) {
            return this.buildRelated(context, potentialInterestingFields, smartsModule, this.params.oneChartPerType, this.params.numResults, this.params.includedCharts, this.params.excludedCharts);
        }
        List<RelatedVisualizationCandidate> potentialPairings = this.generatePotentialPairings(inView, context);
        List<RelatedVisualizationCandidate> potentialTriplets = this.generatePotentialTriplets(inView, context);
        List<RelatedVisualizationCandidate> potentialFoursomes = this.generatePotentialFoursomes(inView, context);
        List<VisRecommendation> pairs = this.buildRelated(context, potentialPairings, smartsModule, this.params.oneChartPerType, this.params.numResults, this.params.includedCharts, this.params.excludedCharts);
        List<VisRecommendation> triples = this.buildRelated(context, potentialTriplets, smartsModule, this.params.oneChartPerType, this.params.numResults, this.params.includedCharts, this.params.excludedCharts);
        List<VisRecommendation> fours = this.buildRelated(context, potentialFoursomes, smartsModule, this.params.oneChartPerType, this.params.numResults, this.params.includedCharts, this.params.excludedCharts);
        List<VisRecommendation> advancedCharts = this.mergeRelatedCharts(triples, fours, this.params.numResults);
        List<VisRecommendation> finalResponse = this.mergeRelatedCharts(pairs, advancedCharts, this.params.numResults);
        this.logOutput("Final related-visualizations to return: ", finalResponse);
        this.continuationToken.addSolutions(finalResponse, this.indexedSmartsModule);
        return finalResponse;
    }

    @Override
    public boolean isSmartsModuleReady() {
        return this.smartsModuleReady;
    }

    private void logInput(String desc, List<ColumnIdentifier> columns) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(desc);
            for (ColumnIdentifier ci : columns) {
                LOGGER.debug(ci.columnIdForExpression);
            }
        }
    }

    private List<RelatedVisualizationCandidate> generatePotentialSingles() {
        if (this.emptyVisualizationEntireSmartsModule && this.interestingFieldsRule != null && this.getSkipVisRecommender()) {
            List<RelatedVisualizationCandidate> candidates = this.interestingFieldsRule.getOrderedInterestingFields(this.params.numResults);
            this.scoringRules.generateUserCommunityScore(candidates);
            this.sort(candidates);
            return candidates;
        }
        return new ArrayList<RelatedVisualizationCandidate>();
    }

    private List<VisRecommendation> mergeRelatedCharts(List<VisRecommendation> pairs, List<VisRecommendation> triples, int numResults) {
        ArrayList<VisRecommendation> results = new ArrayList<VisRecommendation>();
        int required = Math.max(numResults * 2 / 10, 1);
        if (numResults == 1) {
            required = 0;
        }
        boolean done = false;
        int pairsIdx = 0;
        int triplesIdx = 0;
        HashSet<Integer> resultSetHashCodes = new HashSet<Integer>();
        while (!done) {
            VisRecommendation topTriple;
            VisRecommendation topPair = pairsIdx < pairs.size() ? pairs.get(pairsIdx) : null;
            RelatedVisualizationScoring.MergeRelatedResult mergeResult = this.scoringRules.chooseTop(topPair, topTriple = triplesIdx < triples.size() ? triples.get(triplesIdx) : null, pairsIdx, triplesIdx, numResults, required);
            if (mergeResult == RelatedVisualizationScoring.MergeRelatedResult.TWO_VAR) {
                ++pairsIdx;
                if (!this.duplicateRecommendation(topPair, resultSetHashCodes)) {
                    results.add(topPair);
                }
            } else if (mergeResult == RelatedVisualizationScoring.MergeRelatedResult.THREE_PLUS_VAR) {
                ++triplesIdx;
                if (!this.duplicateRecommendation(topTriple, resultSetHashCodes)) {
                    results.add(topTriple);
                }
            } else {
                done = true;
            }
            if (results.size() < numResults) continue;
            done = true;
        }
        return results;
    }

    private boolean duplicateRecommendation(VisRecommendation visRec, Set<Integer> resultSet) {
        int hash = this.simpleVisRecHashCode(visRec);
        if (resultSet.contains(hash)) {
            return true;
        }
        resultSet.add(hash);
        return false;
    }

    private int simpleVisRecHashCode(VisRecommendation visRec) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (visRec.getChartType() == null ? 0 : visRec.getChartType().hashCode());
        result = 31 * result + (visRec.getColumns() == null ? 0 : visRec.getColumns().hashCode());
        return result;
    }

    private List<VisRecommendation> buildRelated(RequestContext context, List<RelatedVisualizationCandidate> potentialPairings, SmartsModule smartsModule, boolean oneChartPerType, int numResults, List<String> includedCharts, List<String> excludedCharts) {
        VisRecommendation chart;
        RelatedVisualizationCandidate pairing;
        int ii;
        long myStartTime = System.currentTimeMillis();
        ArrayList<VisRecommendation> related = new ArrayList<VisRecommendation>();
        ArrayList<RelatedVisualizationCandidate> relatedRuleBreakers = new ArrayList<RelatedVisualizationCandidate>();
        ArrayList<VisRecommendation> undesirables = new ArrayList<VisRecommendation>();
        for (ii = 0; ii < potentialPairings.size(); ++ii) {
            if (this.buildRelatedTimeout(myStartTime)) {
                return related;
            }
            pairing = potentialPairings.get(ii);
            if (!this.getSkipVisRecommender() && !this.rulesSatisfied(pairing)) {
                pairing.setRuleBreaker(true);
                relatedRuleBreakers.add(pairing);
                continue;
            }
            chart = this.generateRelated(context, pairing, smartsModule, related, numResults, ii < potentialPairings.size() - 1, includedCharts, excludedCharts);
            if (pairing.isUndesirable()) {
                undesirables.add(chart);
                continue;
            }
            if (related.size() != numResults) continue;
            return related;
        }
        if (!this.params.allowRuleBreakers) {
            return related;
        }
        for (ii = 0; ii < relatedRuleBreakers.size(); ++ii) {
            pairing = (RelatedVisualizationCandidate)relatedRuleBreakers.get(ii);
            chart = this.generateRelated(context, pairing, smartsModule, related, numResults, ii < potentialPairings.size() - 1, includedCharts, excludedCharts);
            if (this.buildRelatedTimeout(myStartTime) || related.size() == numResults) break;
            if (!pairing.isUndesirable()) continue;
            undesirables.add(chart);
        }
        this.sortCharts(related);
        if (related.size() < numResults) {
            this.sortCharts(undesirables);
            int needed = numResults - related.size();
            for (int ii2 = 0; ii2 < undesirables.size() && ii2 < needed; ++ii2) {
                related.add((VisRecommendation)undesirables.get(ii2));
            }
        }
        return related;
    }

    private VisRecommendation defaultFieldRecommendation(List<ColumnIdentifier> columnIdentifierList) {
        ArrayList<VisColumn> returnableColumns = new ArrayList<VisColumn>();
        for (ColumnIdentifier columnIdentifier : columnIdentifierList) {
            if (this.inViewSet.contains(columnIdentifier) && !this.emptyVisualizationEntireSmartsModule) continue;
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(columnIdentifier.columnIdForExpression);
            returnableColumns.add(new VisColumn(ids, null, null, Collections.emptySet()));
        }
        return new VisRecommendation(null, null, null, null, returnableColumns, 0.0);
    }

    private VisRecommendation generateRelated(RequestContext context, RelatedVisualizationCandidate pairing, SmartsModule smartsModule, List<VisRecommendation> related, int numResults, boolean moreRemaining, List<String> includedCharts, List<String> excludedCharts) {
        List<ColumnIdentifier> columnIdentifierList = this.generateColumnIdentities(pairing);
        List recommendations = null;
        VisRecommendation best = null;
        if (this.getSkipVisRecommender()) {
            best = this.defaultFieldRecommendation(columnIdentifierList);
        } else {
            SmartsResult result = this.recommender.generateRecommendationsFromPair(context, smartsModule, columnIdentifierList, this.getRemainingTimeForVisRec(), includedCharts, excludedCharts, Collections.emptyMap());
            if (result.getSmartsStatus().equals((Object)SmartsStatus.ERROR)) {
                LOGGER.error("Error returned by Vis Recommender: " + result.getSmartsStatus().getDetails());
            } else {
                recommendations = result.getRecommendations();
                best = this.findBest(recommendations);
                if (best != null && best.getColumns().size() < 2 && columnIdentifierList.size() >= 2) {
                    best = null;
                }
            }
        }
        if (best != null && !best.getColumns().isEmpty()) {
            if (!this.getSkipVisRecommender() && (this.lowDesirabilityChart(best) || this.splitLogicalGroup(pairing))) {
                pairing.setUndesirable(true);
                best.setScore(best.getScore() - 10000.0);
                best.setRuleBreaker(true);
            } else {
                best.setScore(pairing.getTotalScore().doubleValue());
                best.setRuleBreaker(pairing.isRuleBreaker());
                related.add(best);
                this.observe(pairing);
                int numFound = related.size();
                if (numFound == numResults && moreRemaining) {
                    this.continuationToken.setIsContinuationPossible(true);
                }
            }
            return best;
        }
        this.continuationToken.addSolution(columnIdentifierList);
        return null;
    }

    private boolean lowDesirabilityChart(IRecommendedVisualization visualization) {
        return this.lowDesirabilityChart(new VisRecommendation(visualization));
    }

    private boolean lowDesirabilityChart(VisRecommendation chart) {
        return !this.params.skipCharts && (this.tooManyCategories(chart) || this.oneDotScatter(chart) || this.latOrLonMissing(chart));
    }

    private boolean splitLogicalGroup(RelatedVisualizationCandidate candidate) {
        return this.hierarchyRule != null && this.hierarchyRule.splitsLogicalGroup(candidate);
    }

    private boolean latOrLonMissing(VisRecommendation chart) {
        boolean containsLat = false;
        boolean containsLon = false;
        for (VisColumn column : chart.getColumns()) {
            if (column.getSlot().contains("LATITUDE")) {
                containsLat = true;
                continue;
            }
            if (!column.getSlot().contains("LONGITUDE")) continue;
            containsLon = true;
        }
        return containsLon && !containsLat || containsLat && !containsLon;
    }

    private boolean tooManyCategories(VisRecommendation chart) {
        if (chart.getColumns().size() == 2) {
            for (VisColumn slot : chart.getColumns()) {
                String id;
                if (!slot.getSlot().equals("CATEGORY") && (!slot.getSlot().equals("COLOR") || !chart.getChartType().contains("Bubble")) || !this.columnInfoMap.containsKey(id = slot.getFirst())) continue;
                ColumnInfo categorical = this.columnInfoMap.get(id);
                Value distinctCount = StatisticsUtil.getStatisticValue((ColumnInfo)categorical, (StatisticType)StatisticType.DISTINCT_COUNT);
                if (distinctCount != null && distinctCount.intValue() > 100) {
                    return true;
                }
                if (distinctCount != null || !categorical.getDataType().isNumeric()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean oneDotScatter(VisRecommendation chart) {
        if (chart.getChartType() != null && (chart.getChartType().equals("Scatter") || chart.getChartType().equals("Bubble"))) {
            if (chart.getColumns().size() == 2) {
                return true;
            }
            if (chart.getColumns().size() > 3) {
                return false;
            }
            return !this.hasCategoricalPoints(chart);
        }
        return false;
    }

    private boolean hasCategoricalPoints(VisRecommendation chart) {
        for (VisColumn slot : chart.getColumns()) {
            ColumnInfo axis;
            RelatedVisualizationScoring.RelatedVizConcept isCategorical;
            String id;
            if (!slot.getSlot().equals("COLOR") && !slot.getSlot().equals("POINTS") && !slot.getSlot().equals("SIZE") || !this.columnInfoMap.containsKey(id = slot.getFirst()) || !(isCategorical = this.scoringRules.isCategorical(axis = this.columnInfoMap.get(id))).equals((Object)RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL)) continue;
            return true;
        }
        return false;
    }

    private boolean rulesSatisfied(RelatedVisualizationCandidate pairing) {
        if (this.hierarchyRule != null && this.hierarchyRule.wouldBeViolated(pairing)) {
            return false;
        }
        if (this.similarityRule != null && this.similarityRule.wouldBeViolated(pairing)) {
            return false;
        }
        return this.interestingFieldsRule == null || !this.interestingFieldsRule.wouldBeViolated(pairing, this.emptyVisualizationEntireSmartsModule ? new HashSet<ColumnIdentifier>() : this.inViewSet);
    }

    private void observe(RelatedVisualizationCandidate pairing) {
        if (this.hierarchyRule != null) {
            this.hierarchyRule.observe(pairing);
        }
        if (this.similarityRule != null) {
            this.similarityRule.observe(pairing);
        }
    }

    private List<ColumnIdentifier> generateColumnIdentities(RelatedVisualizationCandidate candidate) {
        ArrayList<ColumnIdentifier> columnIdentifierList = new ArrayList<ColumnIdentifier>();
        this.addToColumnIdentifierList(candidate.getField1(), columnIdentifierList);
        this.addToColumnIdentifierList(candidate.getField2(), columnIdentifierList);
        this.addToColumnIdentifierList(candidate.getField3(), columnIdentifierList);
        this.addToColumnIdentifierList(candidate.getField4(), columnIdentifierList);
        return columnIdentifierList;
    }

    private void addToColumnIdentifierList(String idForExpression, List<ColumnIdentifier> pairList) {
        ColumnIdentifier cid = this.getColumnIdentifier(idForExpression);
        if (cid != null) {
            pairList.add(cid);
        }
    }

    private ColumnIdentifier getColumnIdentifier(String idForExpression) {
        if (idForExpression != null && !idForExpression.isEmpty()) {
            return this.indexedSmartsModule.getColumnIdentifier(idForExpression);
        }
        return null;
    }

    private VisRecommendation findBest(List<? extends IRecommendedVisualization> recommendations) {
        IRecommendedVisualization bestRecommendation = null;
        if (recommendations == null) {
            return null;
        }
        double score = 0.0;
        boolean highestScoringChartIsUndesirable = false;
        for (IRecommendedVisualization iRecommendedVisualization : recommendations) {
            boolean low = this.lowDesirabilityChart(iRecommendedVisualization);
            boolean lowerScoringChartIsAllowed = false;
            if (highestScoringChartIsUndesirable && !low && bestRecommendation.getColumnBindings().size() == iRecommendedVisualization.getColumnBindings().size() && Math.abs(bestRecommendation.getScore() - iRecommendedVisualization.getScore()) <= 0.1) {
                lowerScoringChartIsAllowed = true;
            }
            if (this.isExcludedChartType(iRecommendedVisualization) || !(iRecommendedVisualization.getScore() > score) && !lowerScoringChartIsAllowed) continue;
            bestRecommendation = iRecommendedVisualization;
            score = iRecommendedVisualization.getScore();
            highestScoringChartIsUndesirable = low;
        }
        if (bestRecommendation != null) {
            return new VisRecommendation(bestRecommendation);
        }
        return null;
    }

    private boolean isExcludedChartType(IRecommendedVisualization recommendation) {
        if (recommendation.getLabel().equals("List")) {
            return true;
        }
        if (this.params.supportedChartTypes == null || this.params.supportedChartTypes.isEmpty()) {
            return false;
        }
        return !this.params.supportedChartTypes.contains(recommendation.getLabel());
    }

    private List<RelatedVisualizationCandidate> generatePotentialPairings(List<ColumnIdentifier> inView, RequestContext context) throws RelatedVisualizationException {
        ArrayList<RelatedVisualizationCandidate> candidates = new ArrayList<RelatedVisualizationCandidate>();
        if (!this.params.generatePairings) {
            return candidates;
        }
        this.generatePairingCombinationsWithTimeout(inView, candidates);
        this.tabulateCandidateScores(candidates, context);
        this.logOutputCandidates("Related-Visualization pairing candidates:", candidates);
        return candidates;
    }

    private void logOutputCandidates(String desc, List<RelatedVisualizationCandidate> candidates) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(desc);
            LOGGER.debug(candidates.toString());
            LOGGER.debug("-------");
        }
    }

    private void logOutput(String desc, List<VisRecommendation> charts) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(desc);
            for (VisRecommendation chart : charts) {
                this.logOutputChart(chart);
            }
            LOGGER.debug("-------");
        }
    }

    private void logOutputChart(VisRecommendation chart) {
        StringBuilder str = new StringBuilder("{ ");
        for (VisColumn col : chart.getColumns()) {
            str.append(col.getFirst() + " - " + col.getSlot() + "  ");
        }
        str.append("} ");
        str.append(chart.getChartType() + " (score: " + chart.getScore() + " ruleBreaker: " + chart.isRuleBreaker() + ")");
        LOGGER.debug(str.toString());
    }

    private List<RelatedVisualizationCandidate> generatePotentialTriplets(List<ColumnIdentifier> inView, RequestContext context) throws RelatedVisualizationException {
        ArrayList<RelatedVisualizationCandidate> candidates = new ArrayList<RelatedVisualizationCandidate>();
        if (!this.params.generateTriplets || this.emptyVisualizationEntireSmartsModule && this.getSkipVisRecommender()) {
            return candidates;
        }
        this.generateTripletCombinationsWithTimeout(inView, candidates);
        this.tabulateCandidateScores(candidates, context);
        this.logOutputCandidates("Related-Visualization triplet candidates:", candidates);
        return candidates;
    }

    private List<RelatedVisualizationCandidate> generatePotentialFoursomes(List<ColumnIdentifier> inView, RequestContext context) throws RelatedVisualizationException {
        ArrayList<RelatedVisualizationCandidate> candidates = new ArrayList<RelatedVisualizationCandidate>();
        if (!this.params.generateFoursomes || this.emptyVisualizationEntireSmartsModule && this.getSkipVisRecommender()) {
            return candidates;
        }
        this.generateFoursomeCombinationsWithTimeout(inView, candidates);
        this.tabulateCandidateScores(candidates, context);
        this.logOutputCandidates("Related-Visualization foursome candidates:", candidates);
        return candidates;
    }

    private void tabulateCandidateScores(List<RelatedVisualizationCandidate> candidates, RequestContext requestContext) {
        this.scoringRules.generateUserCommunityScore(candidates);
        this.scoringRules.calculateInterestingnessScore(candidates, this.interestingFieldsRule, this.inViewSet);
        if (this.getUserId(requestContext) != null) {
            this.scoringRules.generateUserPreferenceScore(candidates, this.getUserId(requestContext));
        }
        this.sort(candidates);
    }

    private String getUserId(RequestContext context) {
        if (context != null && context.getCredentials() != null && context.getCredentials().getUserId() != null && !context.getCredentials().getUserId().isEmpty()) {
            return context.getCredentials().getUserId();
        }
        return null;
    }

    private void generatePairingCombinationsWithTimeout(List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        long myStartTime = System.currentTimeMillis();
        for (int ii = 0; ii < inView.size(); ++ii) {
            ColumnIdentifier columnIdentifier = inView.get(ii);
            if (this.combinationTimeout(myStartTime) || candidates.size() >= 1000) {
                return;
            }
            ColumnInfo inViewCi = columnIdentifier.getColumnInfo();
            this.generatePotentialPairingsFromSlot(inViewCi, candidates);
            this.generatePotentialPairingsFromSimilarity(inViewCi, inView, candidates);
            this.generateShallowPairingsFromInterestingness(columnIdentifier, inView, candidates);
        }
    }

    private void generateShallowPairingsFromInterestingness(ColumnIdentifier columnToConsider, List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        ArrayList<ColumnIdentifier> columnsToConsider = new ArrayList<ColumnIdentifier>();
        columnsToConsider.add(columnToConsider);
        this.generateShallowCandidates(columnsToConsider, inView, candidates);
    }

    private void generateShallowTripletsFromInterestingness(ColumnIdentifier columnToConsider1, ColumnIdentifier columnToConsider2, List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        ArrayList<ColumnIdentifier> columnsToConsider = new ArrayList<ColumnIdentifier>();
        columnsToConsider.add(columnToConsider1);
        columnsToConsider.add(columnToConsider2);
        this.generateShallowCandidates(columnsToConsider, inView, candidates);
    }

    private void generateShallowFoursomesFromInterestingness(ColumnIdentifier columnToConsider1, ColumnIdentifier columnToConsider2, ColumnIdentifier columnToConsider3, List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        ArrayList<ColumnIdentifier> columnsToConsider = new ArrayList<ColumnIdentifier>();
        columnsToConsider.add(columnToConsider1);
        columnsToConsider.add(columnToConsider2);
        columnsToConsider.add(columnToConsider3);
        this.generateShallowCandidates(columnsToConsider, inView, candidates);
    }

    private void generateTripletCombinationsWithTimeout(List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        long myStartTime = System.currentTimeMillis();
        for (int ii = 0; ii < inView.size(); ++ii) {
            if (this.combinationTimeout(myStartTime) || candidates.size() >= 1000) {
                return;
            }
            ColumnIdentifier visColumn1 = inView.get(ii);
            ColumnInfo inViewCi1 = this.columnInfoMap.get(visColumn1.columnIdForExpression);
            for (int jj = ii + 1; jj < inView.size(); ++jj) {
                ColumnIdentifier visColumn2 = inView.get(jj);
                ColumnInfo inViewCi2 = this.columnInfoMap.get(visColumn2.columnIdForExpression);
                this.generatePotentialTripletsFromSlot(inViewCi1, inViewCi2, candidates);
                if (this.combinationTimeout(myStartTime) || candidates.size() >= 1000) {
                    return;
                }
                this.generateShallowTripletsFromInterestingness(visColumn1, visColumn2, inView, candidates);
            }
        }
    }

    private void generateFoursomeCombinationsWithTimeout(List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        long myStartTime = System.currentTimeMillis();
        for (int ii = 0; ii < inView.size(); ++ii) {
            if (this.combinationTimeout(myStartTime) || candidates.size() >= 1000) {
                return;
            }
            ColumnIdentifier visColumn1 = inView.get(ii);
            ColumnInfo inViewCi1 = this.columnInfoMap.get(visColumn1.columnIdForExpression);
            for (int jj = ii + 1; jj < inView.size(); ++jj) {
                if (this.combinationTimeout(myStartTime) || candidates.size() >= 1000) {
                    return;
                }
                ColumnIdentifier visColumn2 = inView.get(jj);
                ColumnInfo inViewCi2 = this.columnInfoMap.get(visColumn2.columnIdForExpression);
                for (int kk = jj + 1; kk < inView.size(); ++kk) {
                    ColumnIdentifier visColumn3 = inView.get(kk);
                    ColumnInfo inViewCi3 = this.columnInfoMap.get(visColumn3.columnIdForExpression);
                    this.generatePotentialFoursomesFromSlot(inViewCi1, inViewCi2, inViewCi3, candidates);
                    this.generateShallowFoursomesFromInterestingness(visColumn1, visColumn2, visColumn3, inView, candidates);
                    if (!this.combinationTimeout(myStartTime) && candidates.size() < 1000) continue;
                    return;
                }
            }
        }
    }

    private boolean combinationTimeout(long startTime) {
        return this.combinationTimeoutValue > 0L && System.currentTimeMillis() - startTime > this.combinationTimeoutValue || this.requestTimeout();
    }

    private boolean buildRelatedTimeout(long startTime) {
        return this.buildRelatedTimeoutValue > 0L && System.currentTimeMillis() - startTime > this.buildRelatedTimeoutValue || this.requestTimeout();
    }

    private void sort(List<RelatedVisualizationCandidate> candidates) {
        Collections.sort(candidates, (a, b) -> {
            Double valA = a.getTotalScore();
            Double valB = b.getTotalScore();
            return -1 * valA.compareTo(valB);
        });
    }

    private void sortCharts(List<VisRecommendation> related) {
        Collections.sort(related, (a, b) -> {
            Double valA = a.getScore() + (double)(a.isRuleBreaker() ? 0 : 10000);
            Double valB = b.getScore() + (double)(b.isRuleBreaker() ? 0 : 10000);
            return -1 * valA.compareTo(valB);
        });
    }

    private void generatePotentialPairingsFromSimilarity(ColumnInfo catCi, List<ColumnIdentifier> inView, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        Map catCiBivariates = this.indexedSmartsModule.getBivariates(catCi);
        for (ColumnIdentifier inViewColumn : inView) {
            String inViewId = inViewColumn.columnIdForExpression;
            if (inViewId.equals(catCi.getIdForExpression()) || !this.indexedSmartsModule.hasBivariates(inViewColumn)) continue;
            Map bivariates = this.indexedSmartsModule.getBivariates(inViewColumn);
            for (Map.Entry entry : bivariates.entrySet()) {
                BivariateStatistics biv = (BivariateStatistics)entry.getValue();
                String dataSetId = ((ColumnIdentifier)entry.getKey()).datasetId;
                String otherId = this.getOtherId(inViewColumn.columnId, biv);
                String otherIdForExpression = this.indexedSmartsModule.getColumnIdentifier((String)dataSetId, (String)otherId).columnIdForExpression;
                ColumnIdentifier otherColumnIdentifier = this.indexedSmartsModule.getColumnIdentifier(otherIdForExpression);
                if (catCiBivariates != null && catCiBivariates.containsKey(otherColumnIdentifier) || this.alreadyACandidate(catCi.getIdForExpression(), otherIdForExpression)) continue;
                this.accumulateBivariateForSimilarPair(catCi.getIdForExpression(), inViewId, biv, candidates);
            }
        }
    }

    private void generateShallowCandidates(List<ColumnIdentifier> columnsToConsider, List<ColumnIdentifier> allInView, List<RelatedVisualizationCandidate> candidates) {
        if (this.interestingFieldsRule == null) {
            return;
        }
        for (ColumnIdentifier columnToConsider : columnsToConsider) {
            if (this.interestingFieldsRule.getInfluencersMap() == null || !this.interestingFieldsRule.getInfluencersMap().containsKey(columnToConsider)) continue;
            Map<ColumnIdentifier, FieldRecommendationRecord> coInterestingFields = this.interestingFieldsRule.getInfluencersMap().get(columnToConsider);
            for (Map.Entry<ColumnIdentifier, FieldRecommendationRecord> pair : coInterestingFields.entrySet()) {
                ColumnIdentifier interestingColumnIdentifier = pair.getKey();
                this.addCandidateForFieldRecommendation(columnsToConsider, interestingColumnIdentifier, allInView, pair.getValue(), candidates, true);
            }
        }
        if (this.interestingFieldsRule.getModuleInterestingFields() != null) {
            FieldsRecommendation fields = this.interestingFieldsRule.getModuleInterestingFields();
            List interestingFields = fields.getRecommendedFields();
            for (FieldRecommendationRecord f : interestingFields) {
                if ("_global_calculations".equals(f.getTableID())) continue;
                ColumnIdentifier interestingColumnIdentifier = this.indexedSmartsModule.getColumnIdentifier(f.getFieldIDForExpression());
                this.addCandidateForFieldRecommendation(columnsToConsider, interestingColumnIdentifier, allInView, f, candidates, false);
            }
        }
    }

    private void addCandidateForFieldRecommendation(List<ColumnIdentifier> existingColumns, ColumnIdentifier newCi, List<ColumnIdentifier> allInView, FieldRecommendationRecord f, List<RelatedVisualizationCandidate> candidates, boolean highPriority) {
        ArrayList<String> candidateIdsForExpression = new ArrayList<String>();
        for (ColumnIdentifier ci : existingColumns) {
            candidateIdsForExpression.add(ci.columnIdForExpression);
        }
        candidateIdsForExpression.add(newCi.columnIdForExpression);
        if (!this.alreadyInView(newCi, allInView) && !this.alreadyACandidate(candidateIdsForExpression) && this.isLikelyToJoin(newCi, existingColumns)) {
            RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(candidateIdsForExpression);
            if (!highPriority) {
                candidate.setRuleBreaker(true);
            }
            if (!this.continuationToken.previouslyAttempted(candidate)) {
                candidates.add(candidate);
                this.updateCandidateMap(candidateIdsForExpression);
            }
        }
    }

    private boolean isLikelyToJoin(ColumnIdentifier newCi, List<ColumnIdentifier> existingColumns) {
        for (ColumnIdentifier ci : existingColumns) {
            if (ci.datasetId.equals(newCi.datasetId) || ci.datasetId.equals("_global_calculations")) continue;
            Boolean isJoinable = this.isEstablishedToBeJoinable(ci.datasetId, newCi.datasetId);
            if (isJoinable == null) {
                HashSet<String> datasetSet = new HashSet<String>();
                datasetSet.add(newCi.datasetId);
                datasetSet.add(ci.datasetId);
                if (!this.determineIfJoinable(ci.datasetId, newCi.datasetId)) {
                    this.addLikelyJoinable(datasetSet, false);
                    return false;
                }
                this.addLikelyJoinable(datasetSet, true);
                continue;
            }
            if (isJoinable.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Boolean isEstablishedToBeJoinable(String datasetId1, String datasetId2) {
        if (!this.likelyJoinableDatasets.containsKey(datasetId1) || !this.likelyJoinableDatasets.get(datasetId1).containsKey(datasetId2)) {
            return null;
        }
        return this.likelyJoinableDatasets.get(datasetId1).get(datasetId2);
    }

    private boolean alreadyInView(ColumnIdentifier ci, List<ColumnIdentifier> allInView) {
        for (ColumnIdentifier inView : allInView) {
            if (!inView.equals((Object)ci)) continue;
            return true;
        }
        return false;
    }

    private boolean determineIfJoinable(String datasetId1, String datasetId2) {
        if (datasetId1.equals(datasetId2)) {
            return true;
        }
        DatasetInfo ds1 = this.getDataset(datasetId1, this.indexedSmartsModule.getSmartsModule());
        DatasetInfo ds2 = this.getDataset(datasetId2, this.indexedSmartsModule.getSmartsModule());
        if (ds1 == null || ds2 == null) {
            return false;
        }
        List columnInfos1 = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds1);
        List columnInfos2 = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds2);
        for (ColumnInfo ci1 : columnInfos1) {
            for (ColumnInfo ci2 : columnInfos2) {
                if (!this.sameName(ci1, ci2) || !this.sameDataType(ci1, ci2) || !this.sameUsage(ci1, ci2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sameName(ColumnInfo ci1, ColumnInfo ci2) {
        return ci1.getName() != null && ci1.getName().equals(ci2.getName());
    }

    private boolean sameDataType(ColumnInfo ci1, ColumnInfo ci2) {
        return ci1.getDataType() != null && ci1.getDataType().equals(ci2.getDataType());
    }

    private boolean sameUsage(ColumnInfo ci1, ColumnInfo ci2) {
        return ci1.getUsage() != null && ci1.getUsage().equals((Object)ci2.getUsage());
    }

    private DatasetInfo getDataset(String tableId, SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().filter(dataset -> tableId.equals(dataset.getId())).findFirst().orElse(null);
    }

    private void generatePotentialPairingsFromSlot(ColumnInfo inViewCi, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        if (inViewCi == null) {
            return;
        }
        RelatedVisualizationScoring.RelatedVizConcept isCategorical = this.scoringRules.isCategorical(inViewCi);
        if (this.indexedSmartsModule.hasBivariates(inViewCi)) {
            Map bivariates = this.indexedSmartsModule.getBivariates(inViewCi);
            for (Map.Entry entry : bivariates.entrySet()) {
                BivariateStatistics biv = (BivariateStatistics)entry.getValue();
                String dataSetId = ((ColumnIdentifier)entry.getKey()).datasetId;
                String biv1IdForExpression = this.indexedSmartsModule.getColumnIdentifier((String)dataSetId, (String)biv.getColumn1()).columnIdForExpression;
                String biv2IdForExpression = this.indexedSmartsModule.getColumnIdentifier((String)dataSetId, (String)biv.getColumn2()).columnIdForExpression;
                if (this.alreadyACandidate(biv1IdForExpression, biv2IdForExpression)) continue;
                this.accumulateBivariateFor(biv, inViewCi, isCategorical, candidates);
            }
        }
    }

    private void generatePotentialTripletsFromSlot(ColumnInfo inViewCi1, ColumnInfo inViewCi2, List<RelatedVisualizationCandidate> candidates) {
        if (inViewCi1 == null || inViewCi2 == null) {
            return;
        }
        if (inViewCi1.getIdForExpression().equals(inViewCi2.getIdForExpression())) {
            return;
        }
        Map bivariates1 = this.indexedSmartsModule.getBivariates(inViewCi1);
        Map bivariates2 = this.indexedSmartsModule.getBivariates(inViewCi2);
        this.accumulateAllTripletsForColumn(bivariates1, inViewCi1.getIdForExpression(), bivariates2, inViewCi2.getIdForExpression(), candidates);
    }

    private void generatePotentialFoursomesFromSlot(ColumnInfo inViewCi1, ColumnInfo inViewCi2, ColumnInfo inViewCi3, List<RelatedVisualizationCandidate> candidates) {
        if (inViewCi1 == null || inViewCi2 == null || inViewCi3 == null) {
            return;
        }
        if (inViewCi1.getIdForExpression().equals(inViewCi2.getIdForExpression())) {
            return;
        }
        if (inViewCi1.getIdForExpression().equals(inViewCi3.getIdForExpression())) {
            return;
        }
        if (inViewCi2.getIdForExpression().equals(inViewCi3.getIdForExpression())) {
            return;
        }
        if (this.indexedSmartsModule.hasBivariates(inViewCi1)) {
            Map bivariates1 = this.indexedSmartsModule.getBivariates(inViewCi1);
            Map bivariates2 = this.indexedSmartsModule.getBivariates(inViewCi2);
            Map bivariates3 = this.indexedSmartsModule.getBivariates(inViewCi3);
            this.accumulateAllFoursomesForColumn(bivariates1, inViewCi1.getIdForExpression(), bivariates2, inViewCi2.getIdForExpression(), bivariates3, inViewCi3.getIdForExpression(), candidates);
        }
    }

    private void accumulateAllTripletsForColumn(Map<ColumnIdentifier, BivariateStatistics> bivariates1, String columnId1, Map<ColumnIdentifier, BivariateStatistics> bivariates2, String columnId2, List<RelatedVisualizationCandidate> candidates) {
        if (bivariates1 == null && bivariates2 == null) {
            return;
        }
        ImmutablePair pair12 = null;
        if (bivariates1 != null && bivariates1.containsKey(this.indexedSmartsModule.getColumnIdentifier(columnId2))) {
            BivariateStatistics biv12 = bivariates1.get(this.indexedSmartsModule.getColumnIdentifier(columnId2));
            String datasetId = this.indexedSmartsModule.getColumnIdentifier((String)columnId1).datasetId;
            pair12 = new ImmutablePair((Object)biv12, (Object)datasetId);
        }
        Map<ColumnIdentifier, BivariateStatistics> bivariatesToScan = bivariates1;
        Map<ColumnIdentifier, BivariateStatistics> bivariatesToScan2 = bivariates2;
        if (bivariatesToScan == null) {
            bivariatesToScan = bivariates2;
            bivariatesToScan2 = bivariates1;
        }
        for (Map.Entry<ColumnIdentifier, BivariateStatistics> entry : bivariatesToScan.entrySet()) {
            ColumnIdentifier biv13Col2Id;
            ColumnIdentifier biv13Col1Id;
            BivariateStatistics biv13 = entry.getValue();
            BivariateStatistics biv23 = null;
            String datasetId = entry.getKey().datasetId;
            ColumnIdentifier id3 = null;
            if (biv13 != null && (id3 = this.isOneOutOfView(biv13Col1Id = this.indexedSmartsModule.getColumnIdentifier(datasetId, biv13.getColumn1()), biv13Col2Id = this.indexedSmartsModule.getColumnIdentifier(datasetId, biv13.getColumn2()))) != null && bivariatesToScan2 != null && bivariatesToScan2.containsKey(id3)) {
                biv23 = bivariatesToScan2.get(id3);
            }
            if (id3 == null || biv23 == null && biv13 == null && pair12 == null || id3.equals((Object)this.indexedSmartsModule.getColumnIdentifier(columnId1)) || id3.equals((Object)this.indexedSmartsModule.getColumnIdentifier(columnId2))) continue;
            ImmutablePair pair13 = null;
            ImmutablePair pair23 = null;
            if (biv13 != null) {
                pair13 = new ImmutablePair((Object)biv13, (Object)datasetId);
            }
            if (biv23 != null) {
                pair23 = new ImmutablePair(biv23, (Object)datasetId);
            }
            ArrayList<Pair<BivariateStatistics, String>> bivs = new ArrayList<Pair<BivariateStatistics, String>>();
            if (pair12 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair12);
            }
            if (pair13 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair13);
            }
            if (pair23 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair23);
            }
            ArrayList<String> columnIdsForExpression = new ArrayList<String>();
            columnIdsForExpression.add(this.indexedSmartsModule.getColumnIdentifier((String)columnId1).columnIdForExpression);
            columnIdsForExpression.add(this.indexedSmartsModule.getColumnIdentifier((String)columnId2).columnIdForExpression);
            columnIdsForExpression.add(id3.columnIdForExpression);
            if (this.alreadyACandidate(columnIdsForExpression)) continue;
            this.accumulateBivariateFor(bivs, columnIdsForExpression, candidates);
        }
    }

    private void accumulateAllFoursomesForColumn(Map<ColumnIdentifier, BivariateStatistics> bivariates1, String columnId1, Map<ColumnIdentifier, BivariateStatistics> bivariates2, String columnId2, Map<ColumnIdentifier, BivariateStatistics> bivariates3, String columnId3, List<RelatedVisualizationCandidate> candidates) {
        ImmutablePair pair12 = null;
        ImmutablePair pair13 = null;
        ImmutablePair pair23 = null;
        if (bivariates1.containsKey(this.indexedSmartsModule.getColumnIdentifier(columnId2))) {
            BivariateStatistics biv12 = bivariates1.get(this.indexedSmartsModule.getColumnIdentifier(columnId2));
            String datasetId12 = this.indexedSmartsModule.getColumnIdentifier((String)columnId2).datasetId;
            pair12 = new ImmutablePair((Object)biv12, (Object)datasetId12);
        }
        if (bivariates1.containsKey(this.indexedSmartsModule.getColumnIdentifier(columnId3))) {
            BivariateStatistics biv13 = bivariates1.get(this.indexedSmartsModule.getColumnIdentifier(columnId3));
            String datasetId13 = this.indexedSmartsModule.getColumnIdentifier((String)columnId3).datasetId;
            pair13 = new ImmutablePair((Object)biv13, (Object)datasetId13);
        }
        if (bivariates2 != null && bivariates2.containsKey(this.indexedSmartsModule.getColumnIdentifier(columnId3))) {
            BivariateStatistics biv23 = bivariates2.get(this.indexedSmartsModule.getColumnIdentifier(columnId3));
            String datasetId23 = this.indexedSmartsModule.getColumnIdentifier((String)columnId3).datasetId;
            pair23 = new ImmutablePair((Object)biv23, (Object)datasetId23);
        }
        for (Map.Entry<ColumnIdentifier, BivariateStatistics> entry : bivariates1.entrySet()) {
            ColumnIdentifier biv14Col2Id;
            BivariateStatistics biv14 = entry.getValue();
            String datasetId4 = entry.getKey().datasetId;
            ImmutablePair pair14 = new ImmutablePair((Object)biv14, (Object)datasetId4);
            ImmutablePair pair24 = null;
            ImmutablePair pair34 = null;
            String datasetId = entry.getKey().datasetId;
            ColumnIdentifier biv14Col1Id = this.indexedSmartsModule.getColumnIdentifier(datasetId, biv14.getColumn1());
            ColumnIdentifier id4 = this.isOneOutOfView(biv14Col1Id, biv14Col2Id = this.indexedSmartsModule.getColumnIdentifier(datasetId, biv14.getColumn2()));
            if (id4 == null || id4.equals((Object)this.indexedSmartsModule.getColumnIdentifier(columnId1)) || id4.equals((Object)this.indexedSmartsModule.getColumnIdentifier(columnId2)) || id4.equals((Object)this.indexedSmartsModule.getColumnIdentifier(columnId3))) continue;
            if (id4 != null && bivariates2 != null && bivariates2.containsKey(id4)) {
                BivariateStatistics biv24 = bivariates2.get(id4);
                pair24 = new ImmutablePair((Object)biv24, (Object)datasetId4);
            }
            if (id4 != null && bivariates3 != null && bivariates3.containsKey(id4)) {
                BivariateStatistics biv34 = bivariates3.get(id4);
                pair34 = new ImmutablePair((Object)biv34, (Object)datasetId4);
            }
            ArrayList<Pair<BivariateStatistics, String>> bivs = new ArrayList<Pair<BivariateStatistics, String>>();
            if (pair12 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair12);
            }
            if (pair13 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair13);
            }
            if (pair23 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair23);
            }
            if (pair14 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair14);
            }
            if (pair24 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair24);
            }
            if (pair34 != null) {
                bivs.add((Pair<BivariateStatistics, String>)pair34);
            }
            ArrayList<String> columnIds = new ArrayList<String>();
            columnIds.add(columnId1);
            columnIds.add(columnId2);
            columnIds.add(columnId3);
            columnIds.add(id4.columnIdForExpression);
            if (this.alreadyACandidate(columnIds)) continue;
            this.accumulateBivariateFor(bivs, columnIds, candidates);
        }
    }

    private String getOtherId(String id, BivariateStatistics biv) throws RelatedVisualizationException {
        if (!biv.getColumn1().equals(id) && !biv.getColumn2().equals(id)) {
            throw new RelatedVisualizationException("invalid argument id passed to bivariate lookup.");
        }
        String otherId = biv.getColumn1();
        if (otherId.equals(id)) {
            otherId = biv.getColumn2();
        }
        return otherId;
    }

    private void accumulateBivariateForSimilarPair(String columnAId, String columnBId, BivariateStatistics biv, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        boolean outIsCategorical;
        String datasetId = this.indexedSmartsModule.getColumnIdentifier((String)columnBId).datasetId;
        String otherId = this.getOtherId(this.indexedSmartsModule.getColumnIdentifier((String)columnBId).columnId, biv);
        ColumnIdentifier otherIdColumnIdentifier = this.indexedSmartsModule.getColumnIdentifier(datasetId, otherId);
        if (!this.outOfViewSet.contains(otherIdColumnIdentifier)) {
            return;
        }
        ColumnInfo outOfViewCi = otherIdColumnIdentifier.getColumnInfo();
        ColumnInfo inputColumnInfo = this.indexedSmartsModule.getColumnIdentifier(columnAId).getColumnInfo();
        boolean inIsCategorical = this.scoringRules.isCategorical(inputColumnInfo) == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL;
        boolean bl = outIsCategorical = this.scoringRules.isCategorical(outOfViewCi) == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL;
        if (inIsCategorical && outIsCategorical) {
            return;
        }
        double d = this.scoringRules.extractStatistic(biv.getStatistics(), false, outIsCategorical);
        if (d > 0.0) {
            RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(columnAId, outOfViewCi.getIdForExpression(), d);
            if (d < (double)0.03f || d > (double)0.55f) {
                candidate.setRuleBreaker(true);
            }
            if (!this.continuationToken.previouslyAttempted(candidate)) {
                candidates.add(candidate);
                this.updateCandidateMap(columnAId, otherId);
            }
        }
    }

    private boolean accumulateBivariateFor(BivariateStatistics biv, ColumnInfo inViewCi, RelatedVisualizationScoring.RelatedVizConcept isCategorical, List<RelatedVisualizationCandidate> candidates) throws RelatedVisualizationException {
        String dataSetId = this.indexedSmartsModule.getColumnIdentifier((String)inViewCi.getIdForExpression()).datasetId;
        String otherId = this.getOtherId(inViewCi.getId(), biv);
        ColumnIdentifier otherIdColumnIdentifier = this.indexedSmartsModule.getColumnIdentifier(dataSetId, otherId);
        if (!this.outOfViewSet.contains(otherIdColumnIdentifier)) {
            return false;
        }
        ColumnInfo outOfViewCi = this.columnInfoMap.get(otherIdColumnIdentifier.columnIdForExpression);
        RelatedVisualizationScoring.RelatedVizConcept outIsCategorical = this.scoringRules.isCategorical(outOfViewCi);
        if (outIsCategorical == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL && isCategorical == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL && !this.getSkipVisRecommender()) {
            return false;
        }
        if (outIsCategorical == RelatedVisualizationScoring.RelatedVizConcept.NEITHER || isCategorical == RelatedVisualizationScoring.RelatedVizConcept.NEITHER) {
            return false;
        }
        double d = this.scoringRules.extractStatistic(biv.getStatistics(), isCategorical == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL, outIsCategorical == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL);
        if (d > 0.0) {
            RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(inViewCi.getIdForExpression(), otherIdColumnIdentifier.columnIdForExpression, d);
            if (d < (double)0.03f || d > (double)0.55f) {
                candidate.setRuleBreaker(true);
            }
            if (!this.continuationToken.previouslyAttempted(candidate)) {
                candidates.add(candidate);
                this.updateCandidateMap(inViewCi.getIdForExpression(), otherIdColumnIdentifier.columnIdForExpression);
                return true;
            }
        }
        return false;
    }

    private void accumulateBivariateFor(List<Pair<BivariateStatistics, String>> biv, List<String> columnIds, List<RelatedVisualizationCandidate> candidates) {
        RelatedVisualizationCandidate candidate = new RelatedVisualizationCandidate(columnIds);
        if (this.continuationToken.previouslyAttempted(candidate)) {
            return;
        }
        boolean foundMetric = false;
        boolean foundCat = false;
        for (int ii = 0; ii < columnIds.size(); ++ii) {
            RelatedVisualizationScoring.RelatedVizConcept rvc = this.scoringRules.isCategorical(columnIds.get(ii));
            if (rvc == RelatedVisualizationScoring.RelatedVizConcept.NEITHER) {
                return;
            }
            if (rvc == RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL || rvc == RelatedVisualizationScoring.RelatedVizConcept.BOTH) {
                foundCat = true;
            }
            if (rvc != RelatedVisualizationScoring.RelatedVizConcept.MEASURE && rvc != RelatedVisualizationScoring.RelatedVizConcept.BOTH) continue;
            foundMetric = true;
        }
        if (!foundCat || !foundMetric) {
            return;
        }
        double correlationScore = 0.0;
        int mixedCount = 0;
        for (int ii = 0; ii < biv.size(); ++ii) {
            double d;
            ColumnIdentifier bivCol1 = this.indexedSmartsModule.getColumnIdentifier((String)biv.get(ii).getRight(), ((BivariateStatistics)biv.get(ii).getLeft()).getColumn1());
            ColumnIdentifier bivCol2 = this.indexedSmartsModule.getColumnIdentifier((String)biv.get(ii).getRight(), ((BivariateStatistics)biv.get(ii).getLeft()).getColumn2());
            RelatedVisualizationScoring.RelatedVizConcept isCat1 = this.scoringRules.isCategorical(bivCol1.columnIdForExpression);
            RelatedVisualizationScoring.RelatedVizConcept isCat2 = this.scoringRules.isCategorical(bivCol2.columnIdForExpression);
            ColumnIdentifier id3 = this.isOneOutOfView(bivCol1, bivCol2);
            double lowerBar = 0.01f;
            double upperBar = 0.95f;
            if (id3 != null) {
                lowerBar = 0.03f;
                upperBar = 0.55f;
            }
            if ((d = this.scoringRules.extractStatistic(((BivariateStatistics)biv.get(ii).getLeft()).getStatistics(), true, false)) > lowerBar && d < upperBar) {
                correlationScore += d;
                ++mixedCount;
                continue;
            }
            if (isCat1 != RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL || isCat2 != RelatedVisualizationScoring.RelatedVizConcept.CATEGORICAL) continue;
            return;
        }
        if (mixedCount == 0) {
            return;
        }
        candidate.setCorrelationScore(correlationScore /= (double)Math.max(mixedCount, columnIds.size()));
        candidates.add(candidate);
        this.updateCandidateMap(columnIds);
    }

    private ColumnIdentifier isOneOutOfView(ColumnIdentifier id1, ColumnIdentifier id2) {
        if (this.outOfViewSet.contains(id1) && this.inViewSet.contains(id2)) {
            return id1;
        }
        if (this.inViewSet.contains(id1) && this.outOfViewSet.contains(id2)) {
            return id2;
        }
        return null;
    }

    private boolean alreadyACandidate(String id1, String id2) throws RelatedVisualizationException {
        if (this.indexedSmartsModule.getColumnIdentifier(id1) == null || this.indexedSmartsModule.getColumnIdentifier(id2) == null) {
            throw new RelatedVisualizationException("improper id passed to method that checks for previous solutions.");
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id1);
        ids.add(id2);
        return this.alreadyACandidate(ids);
    }

    private boolean alreadyACandidate(List<String> ids) {
        String key = this.candidateKey(ids);
        return this.candidateKeyMap.contains(key);
    }

    private String candidateKey(List<String> ids) {
        Collections.sort(ids);
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < ids.size(); ++ii) {
            sb.append(ids.get(ii));
            sb.append("|");
        }
        return sb.toString();
    }

    private void updateCandidateMap(String id1, String id2) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id1);
        ids.add(id2);
        String key = this.candidateKey(ids);
        this.candidateKeyMap.add(key);
    }

    private void updateCandidateMap(List<String> ids) {
        String key = this.candidateKey(ids);
        this.candidateKeyMap.add(key);
    }

    private List<ColumnIdentifier> getInView(RequestContext context, SmartsModule smartsModule, VisualizationPayload visualization, String token) throws RelatedVisualizationException {
        List<ColumnIdentifier> inViewColumns = null;
        if (this.checkFlags(4) && this.interestingFieldsRecommender != null) {
            this.interestingFieldsRule = new RelatedFieldsRule(this.interestingFieldsRecommender, context, smartsModule, this.indexedSmartsModule, this.params.joinableTableIds, this.influencersTimeoutValue);
        }
        if (visualization == null || visualization.getColumns().isEmpty()) {
            this.emptyVisualizationEntireSmartsModule = true;
            inViewColumns = this.setDatasetFromEmptyVisualization(smartsModule, token);
        } else {
            inViewColumns = this.setDatasetFromPopulatedVisualization(smartsModule, token, visualization.getColumns());
        }
        return inViewColumns;
    }

    private void getAllInterestingFields(SmartsModule smartsModule, int n) {
        if (this.interestingFieldsRule != null) {
            this.interestingFieldsRule.getTopInterestingFields(smartsModule, n);
        }
    }

    private void addPotentiallyInterestingField(String columnId) {
        if (this.interestingFieldsRule != null) {
            this.interestingFieldsRule.addPotentiallyInterestingField(columnId);
        }
    }

    private List<ColumnIdentifier> setDatasetFromEmptyVisualization(SmartsModule smartsModule, String token) {
        ArrayList<ColumnIdentifier> columns = new ArrayList<ColumnIdentifier>();
        this.setDataSetInfo(smartsModule, token);
        this.getAllInterestingFields(smartsModule, this.params.numResults);
        for (DatasetInfo ds : smartsModule.getDatasets()) {
            List columnInfos = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
            for (ColumnInfo ci : columnInfos) {
                String columnId = ci.getIdForExpression();
                ColumnIdentifier columnIdentifier = this.indexedSmartsModule.getColumnIdentifier(ci.getIdForExpression());
                columns.add(columnIdentifier);
                this.addPotentiallyInterestingField(columnId);
            }
        }
        return columns;
    }

    private List<ColumnIdentifier> setDatasetFromPopulatedVisualization(SmartsModule smartsModule, String token, List<VisColumn> visColumns) throws RelatedVisualizationException {
        ArrayList<ColumnIdentifier> columns = new ArrayList<ColumnIdentifier>();
        HashSet<String> datasetsOfUserChart = new HashSet<String>();
        for (VisColumn columnInVis : visColumns) {
            List columnIds = columnInVis.getId();
            for (String columnId : columnIds) {
                boolean foundColumn = false;
                for (DatasetInfo ds : smartsModule.getDatasets()) {
                    List cis = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
                    if (!cis.stream().anyMatch(c -> c.getIdForExpression().equals(columnId))) continue;
                    columns.add(this.indexedSmartsModule.getColumnIdentifier(columnId));
                    datasetsOfUserChart.add(ds.getId());
                    this.addPotentiallyInterestingField(columnId);
                    foundColumn = true;
                    break;
                }
                if (foundColumn) continue;
                throw new RelatedVisualizationException((Throwable)new ColumnNotFoundException(columnId));
            }
        }
        this.setDataSetInfo(smartsModule, token);
        this.getAllInterestingFields(smartsModule, this.params.numResults);
        this.addLikelyJoinable(datasetsOfUserChart, true);
        return columns;
    }

    private void addLikelyJoinable(Set<String> datasetsSet, boolean isJoinable) {
        if (datasetsSet.size() > 1) {
            datasetsSet.forEach(ds1 -> datasetsSet.forEach(ds2 -> {
                if (!ds1.equals(ds2)) {
                    if (!this.likelyJoinableDatasets.containsKey(ds1)) {
                        this.likelyJoinableDatasets.put((String)ds1, new HashMap());
                    }
                    this.likelyJoinableDatasets.get(ds1).put((String)ds2, isJoinable);
                    if (!this.likelyJoinableDatasets.containsKey(ds2)) {
                        this.likelyJoinableDatasets.put((String)ds2, new HashMap());
                    }
                    this.likelyJoinableDatasets.get(ds2).put((String)ds1, isJoinable);
                }
            }));
        }
    }

    private void setDataSetInfo(SmartsModule smartsModule, String token) {
        if (this.checkFlags(1)) {
            this.hierarchyRule = new RelatedVisualizationHierarchyRule(this.columnInfoMap, this.indexedSmartsModule);
        }
        if (this.checkFlags(2)) {
            this.similarityRule = new RelatedVisualizationSimilarityRule(this.indexedSmartsModule.getAllBivariates(), this.scoringRules, this.indexedSmartsModule);
        }
        ArrayList<ColumnInfo> dataSetsColumns = new ArrayList<ColumnInfo>();
        for (DatasetInfo datasetInfo : smartsModule.getDatasets()) {
            dataSetsColumns.addAll(SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo));
        }
        this.continuationToken = new ContinuationToken(dataSetsColumns, token);
    }

    private List<ColumnIdentifier> getOutOfView(SmartsModule smartsModule, List<ColumnIdentifier> inView) {
        ArrayList<ColumnIdentifier> columnsNotInView = new ArrayList<ColumnIdentifier>();
        if (inView != null && !inView.isEmpty()) {
            this.inViewSet.addAll(inView);
        }
        smartsModule.getDatasets().forEach(ds -> {
            List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
            columns.forEach(column -> {
                Value domainSize;
                ColumnIdentifier columnIdentifer = this.indexedSmartsModule.getColumnIdentifier(column.getIdForExpression());
                if (!(this.inViewSet.contains(columnIdentifer) && this.inViewSet.size() < columns.size() / 2 || (domainSize = StatisticsUtil.getStatisticValue((ColumnInfo)column, (StatisticType)StatisticType.DISTINCT_COUNT)) == null || domainSize.intValue() <= 1)) {
                    columnsNotInView.add(columnIdentifer);
                }
                this.storeColumnInfo((ColumnInfo)column);
            });
        });
        if (inView != null && inView.isEmpty()) {
            inView.addAll(columnsNotInView);
            this.inViewSet.addAll(columnsNotInView);
        } else if (columnsNotInView.isEmpty()) {
            columnsNotInView.addAll(inView);
        }
        this.outOfViewSet.addAll(columnsNotInView);
        return columnsNotInView;
    }

    private void storeColumnInfo(ColumnInfo ci) {
        this.columnInfoMap.put(ci.getIdForExpression(), ci);
    }

    private boolean checkFlags(int var) {
        return (var & this.params.ruleFlags) != 0;
    }

    public void setFlags(int f) {
        this.params.ruleFlags = f;
    }

    public void enableFlag(int f) {
        this.params.ruleFlags |= f;
    }

    public void setGeneratePairings(boolean b) {
        this.params.generatePairings = b;
    }

    public void setGenerateTriplets(boolean b) {
        this.params.generateTriplets = b;
    }

    public void setGenerateFoursomes(boolean b) {
        this.params.generateFoursomes = b;
    }

    public void setAllowRuleBreakers(boolean b) {
        this.params.allowRuleBreakers = b;
    }

    private void setTimeouts(long t) {
        this.requestStartTime = System.currentTimeMillis();
        if (t <= 0L) {
            return;
        }
        this.combinationTimeoutValue = Math.max(t / 10L, 1L);
        this.buildRelatedTimeoutValue = Math.max(t / 6L, 1L);
        this.influencersTimeoutValue = Math.max(t / 2L, 1L);
    }

    private long getRemainingTimeForVisRec() {
        if (this.params.timeout > 0L) {
            return this.params.timeout - (System.currentTimeMillis() - this.requestStartTime);
        }
        return 10000L;
    }

    private boolean requestTimeout() {
        return this.getRemainingTimeForVisRec() <= 0L;
    }

    private void show(List<VisColumn> cols) {
        StringBuilder str = new StringBuilder();
        str.append("{");
        for (VisColumn vsc : cols) {
            str.append(vsc.getFirst());
            str.append(" ");
        }
        str.append("}");
        System.out.println(str);
    }

    private void displayOutput(VisRecommendation relatedCharts) {
        ArrayList<VisRecommendation> listy = new ArrayList<VisRecommendation>();
        listy.add(relatedCharts);
        this.displayOutput(listy);
    }

    private void displayOutput(List<VisRecommendation> relatedCharts) {
        StringBuilder sb = new StringBuilder("{");
        for (VisRecommendation recommendation : relatedCharts) {
            for (VisColumn col : recommendation.getColumns()) {
                sb.append(col.getFirst() + ",");
            }
            sb.append("}");
            System.out.println(sb.toString() + " " + recommendation.getChartType());
        }
    }

    @Override
    public String getContinuationToken() {
        if (this.continuationToken != null) {
            try {
                return this.continuationToken.makeContinuationToken();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    private boolean smartsModuleHasSufficientlyProgressed(SmartsModule smartsModule, String expectedCompletedTask) {
        if (smartsModule.getAnalysisState() != null && smartsModule.getAnalysisState().equals((Object)AnalysisStateType.DONE)) {
            return true;
        }
        if (smartsModule.getAnalysisMode() != null && smartsModule.getAnalysisMode().equals((Object)AnalysisModeType.SHALLOW)) {
            return true;
        }
        for (DatasetInfo ds : smartsModule.getDatasets()) {
            AnalysisPhase analysisPhase;
            if (ds.getAnalysisPhases() == null || ds.getAnalysisPhases().isEmpty()) continue;
            boolean foundThatPredictFinished = false;
            Iterator iterator = ds.getAnalysisPhases().iterator();
            while (iterator.hasNext() && !(foundThatPredictFinished = (analysisPhase = (AnalysisPhase)iterator.next()).getCompletedTasks().stream().anyMatch(completedTask -> completedTask.getId() != null && completedTask.getId().equals(expectedCompletedTask)))) {
            }
            if (foundThatPredictFinished) continue;
            return false;
        }
        return true;
    }
}

