/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelatedVisualizationCandidate {
    private String field1 = null;
    private String field2 = null;
    private String field3 = null;
    private String field4 = null;
    private double correlationScore = 0.0;
    private double communityScore = 0.0;
    private double interestingnessScore = 0.0;
    private double personalDislikeScore = 0.0;
    private boolean ruleBreaker = false;
    private boolean undesirable = false;

    public RelatedVisualizationCandidate(String columnId) {
        this.setField1(columnId);
    }

    public RelatedVisualizationCandidate(List<String> columnIds) {
        this.setField1(columnIds.get(0));
        this.setField2(columnIds.get(1));
        if (columnIds.size() >= 3) {
            this.setField3(columnIds.get(2));
        }
        if (columnIds.size() >= 4) {
            this.setField4(columnIds.get(3));
        }
    }

    public RelatedVisualizationCandidate(String colId1, String colId2, double score) {
        this.setField1(colId1);
        this.setField2(colId2);
        this.setCorrelationScore(score);
    }

    public void setField1(String f1) {
        this.field1 = f1;
    }

    public void setField2(String f2) {
        this.field2 = f2;
    }

    public void setField3(String f3) {
        this.field3 = f3;
    }

    public void setField4(String f4) {
        this.field4 = f4;
    }

    public String getField1() {
        return this.field1;
    }

    public String getField2() {
        return this.field2;
    }

    public String getField3() {
        return this.field3;
    }

    public String getField4() {
        return this.field4;
    }

    public Double getTotalScore() {
        return this.correlationScore + this.communityScore + this.interestingnessScore + this.personalDislikeScore;
    }

    public Double getCommunityScore() {
        return this.communityScore;
    }

    public void setCorrelationScore(Double d) {
        this.correlationScore = 0.5 - Math.abs(d - 0.5);
    }

    public void setCommunityScore(Double d) {
        this.communityScore = d;
    }

    public double getInterestingnessScore() {
        return this.interestingnessScore;
    }

    public void setInterestingnessScore(Double percent) {
        this.interestingnessScore = percent;
    }

    public void setInterestingnessScore(Double percent, Double inflation) {
        this.setInterestingnessScore(percent);
        this.interestingnessScore *= inflation.doubleValue();
    }

    public void setDislikeScore(Double d) {
        this.personalDislikeScore = d;
    }

    public boolean isRuleBreaker() {
        return this.ruleBreaker;
    }

    public void setRuleBreaker(boolean ruleBreaker) {
        this.ruleBreaker = ruleBreaker;
    }

    public boolean isUndesirable() {
        return this.undesirable;
    }

    public void setUndesirable(boolean und) {
        this.undesirable = und;
    }

    public Set<String> fieldsAsSet() {
        HashSet<String> fieldSet = new HashSet<String>();
        if (this.field1 != null) {
            fieldSet.add(this.field1);
        }
        if (this.field2 != null) {
            fieldSet.add(this.field2);
        }
        if (this.field3 != null) {
            fieldSet.add(this.field3);
        }
        if (this.field4 != null) {
            fieldSet.add(this.field4);
        }
        return fieldSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Field1:" + this.field1);
        sb.append(", Field2:" + this.field2);
        if (this.field3 != null) {
            sb.append(", Field3:" + this.field3);
        }
        if (this.field4 != null) {
            sb.append(", Field4:" + this.field4);
        }
        sb.append(", correlationScore:" + this.correlationScore);
        sb.append(", communityScore:" + this.communityScore);
        sb.append(", influencers score:" + this.interestingnessScore);
        sb.append(", my dislike score:" + this.personalDislikeScore);
        return sb.toString();
    }
}

