/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.util;

import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.ContentRecommenderFactory;
import com.ibm.smarts.content.recommender.api.IContentRecommender;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.CandidateTopicGenerator;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.ir.visualizer.IRVisualizerUtil;
import com.ibm.smarts.ir.visualizer.IRVisualizerUtilParams;
import com.ibm.smarts.relatedvisualizations.exception.RelatedVisualizationException;
import com.ibm.smarts.relatedvisualizations.util.IRelatedContentAdvisor;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationParameters;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.useractions.actions.VisualizationPayload;
import com.ibm.smarts.visualization.recommender.api.IVisualizationRecommender;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedVisualizationContentRecommender
implements IRelatedContentAdvisor {
    private final IContentRecommender contentRecommender;
    private final IVisualizationRecommender visRecommender;
    private static final int LIMIT_CONSEC_COL_APPEARANCES = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedVisualizationContentRecommender.class);

    public RelatedVisualizationContentRecommender(InterestingFieldsRecommender fieldRecommender, IVisualizationRecommender visRecommender) {
        this.contentRecommender = ContentRecommenderFactory.getContentRecommender((InterestingFieldsRecommender)fieldRecommender);
        this.visRecommender = visRecommender;
    }

    @Override
    public List<VisRecommendation> suggestRelated(RequestContext rc, VisualizationPayload vis, SmartsModule sm, RelatedVisualizationParameters inputParameters) throws RelatedVisualizationException {
        QuickAccessSmartsModule quickAccessSmartsModule = new QuickAccessSmartsModule(sm);
        List<TopicScope> scopes = this.createScopes(vis);
        if (scopes.isEmpty()) {
            return this.tryIFeelLucky(rc, quickAccessSmartsModule, inputParameters);
        }
        return this.tryAllPrimaryTopics(rc, scopes, quickAccessSmartsModule, inputParameters);
    }

    private List<VisRecommendation> tryAllPrimaryTopics(RequestContext rc, List<TopicScope> topicScopeList, QuickAccessSmartsModule sm, RelatedVisualizationParameters inputParameters) {
        ArrayList<List<VisRecommendation>> allRelatedContent = new ArrayList<List<VisRecommendation>>();
        for (int iTopicNum = 0; iTopicNum <= topicScopeList.size() - 1; ++iTopicNum) {
            ArrayList<TopicScope> secondaryList = new ArrayList<TopicScope>(topicScopeList);
            TopicScope primaryTopic = (TopicScope)secondaryList.remove(iTopicNum);
            if (!this.isPermissible(primaryTopic, sm)) continue;
            AnalysisScope contentRecScope = new AnalysisScope(sm.getSmartsModule(), sm.getSmartsModule().getType(), rc.productLocale, primaryTopic, secondaryList);
            contentRecScope.setMaxColumnCombinations(inputParameters.numResults);
            contentRecScope.setJoinableColumnMap(inputParameters.getJoinableColumnIds());
            contentRecScope.setFilters(inputParameters.filters);
            allRelatedContent.add(this.getVisRecommendationsFromContentRecommender(rc, contentRecScope, inputParameters.includedCharts));
        }
        Optional<TopicScope> loneTopic = topicScopeList.size() == 1 ? Optional.of(topicScopeList.get(0)) : Optional.empty();
        return this.rotateContent(allRelatedContent, inputParameters.numResults, loneTopic);
    }

    private List<VisRecommendation> tryIFeelLucky(RequestContext rc, QuickAccessSmartsModule sm, RelatedVisualizationParameters inputParameters) {
        AnalysisScope contentRecScope = new AnalysisScope(sm.getSmartsModule(), sm.getSmartsModule().getType(), rc.productLocale, null, Collections.emptyList());
        contentRecScope.setMaxColumnCombinations(inputParameters.numResults);
        return this.getVisRecommendationsFromContentRecommender(rc, contentRecScope, inputParameters.includedCharts);
    }

    public List<VisRecommendation> rotateContent(List<List<VisRecommendation>> allRelatedContent, int requestedSize, Optional<TopicScope> allowedConsecTopic) {
        ArrayList<VisRecommendation> visRecs = new ArrayList<VisRecommendation>();
        ArrayList<Set<String>> consecColumnSets = new ArrayList<Set<String>>();
        boolean done = allRelatedContent.isEmpty();
        ArrayList<VisRecommendation> rejectedCharts = new ArrayList<VisRecommendation>();
        while (!done) {
            done = true;
            for (int relatedContentListNum = 0; relatedContentListNum < allRelatedContent.size() && visRecs.size() < requestedSize; ++relatedContentListNum) {
                List<VisRecommendation> thesePrimaryCharts = allRelatedContent.get(relatedContentListNum);
                if (thesePrimaryCharts.isEmpty()) continue;
                VisRecommendation vis = thesePrimaryCharts.remove(0);
                this.processUniquenessAndConsecutiveRules(vis, consecColumnSets, visRecs, allowedConsecTopic, rejectedCharts, true);
                if (thesePrimaryCharts.isEmpty()) continue;
                done = false;
            }
            if (visRecs.size() != requestedSize) continue;
            done = true;
        }
        if (visRecs.size() < requestedSize && !rejectedCharts.isEmpty()) {
            done = false;
            HashSet<Set<String>> uniqueCharts = new HashSet<Set<String>>(consecColumnSets);
            while (!done) {
                VisRecommendation vis = (VisRecommendation)rejectedCharts.remove(0);
                Set<String> columnIds = this.getColumnIds(vis);
                if (!uniqueCharts.contains(columnIds)) {
                    visRecs.add(vis);
                    uniqueCharts.add(columnIds);
                }
                if (visRecs.size() != requestedSize && !rejectedCharts.isEmpty()) continue;
                done = true;
            }
        }
        return visRecs;
    }

    private void processUniquenessAndConsecutiveRules(VisRecommendation vis, List<Set<String>> consecColumnSets, List<VisRecommendation> visRecs, Optional<TopicScope> allowedConsecTopic, List<VisRecommendation> rejectedCharts, boolean applyConsecCheck) {
        HashSet<Set<String>> uniqueCharts;
        Set<String> columnIds = this.getColumnIds(vis);
        if (allowedConsecTopic.isPresent()) {
            columnIds.remove(allowedConsecTopic.get().getId());
        }
        if (!(uniqueCharts = new HashSet<Set<String>>(consecColumnSets)).contains(columnIds)) {
            if (applyConsecCheck && this.passesConsecCheck(consecColumnSets, columnIds)) {
                consecColumnSets.add(columnIds);
                visRecs.add(vis);
            } else {
                rejectedCharts.add(vis);
            }
        }
    }

    public boolean passesConsecCheck(List<Set<String>> consecColumnSets, Set<String> columnIds) {
        if (consecColumnSets == null || consecColumnSets.size() < 3) {
            return true;
        }
        Set<String> intersection = consecColumnSets.get(consecColumnSets.size() - 1);
        for (int lastSetId = consecColumnSets.size() - 2; lastSetId >= consecColumnSets.size() - 3; --lastSetId) {
            Set<String> lastSet = consecColumnSets.get(lastSetId);
            if (!(intersection = intersection.stream().filter(lastSet::contains).collect(Collectors.toSet())).isEmpty()) continue;
            return true;
        }
        return intersection.stream().filter(columnIds::contains).collect(Collectors.toSet()).isEmpty();
    }

    private boolean isPermissible(TopicScope primaryTopic, QuickAccessSmartsModule sm) {
        return CandidateTopicGenerator.isPermissibleTopic((ColumnInfo)sm.getColumnInfo(primaryTopic.getId()));
    }

    private Set<String> getColumnIds(VisRecommendation vis) {
        HashSet<String> allColumns = new HashSet<String>();
        for (VisColumn visColumn : vis.getColumns()) {
            allColumns.addAll(visColumn.getId());
        }
        return allColumns;
    }

    private List<VisRecommendation> getVisRecommendationsFromContentRecommender(RequestContext rc, AnalysisScope contentRecScope, List<String> includedCharts) {
        List irs = new ArrayList();
        try {
            irs = this.contentRecommender.recommendIRs(contentRecScope, rc);
        }
        catch (ContentException e) {
            LOGGER.info(e.getSmartsStatus().getDetails());
        }
        if (!irs.isEmpty()) {
            IRContent ir = (IRContent)irs.get(0);
            IRVisualizerUtilParams irVisParams = new IRVisualizerUtilParams(this.visRecommender, contentRecScope.getSmartsModule(), ir, rc.productLocale);
            irVisParams.setIncludedChartTypes(includedCharts);
            Map combinationToChartMap = IRVisualizerUtil.generate((IRVisualizerUtilParams)irVisParams);
            return ir.getCombinations().stream().map(comb -> (IRecommendedVisualization)combinationToChartMap.get(comb)).filter(Objects::nonNull).map(r -> new VisRecommendation(r)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<TopicScope> createScopes(VisualizationPayload vis) {
        ArrayList<TopicScope> secondaryTopics = new ArrayList<TopicScope>();
        for (VisColumn visColumn : vis.getColumns()) {
            for (String id : visColumn.getId()) {
                TopicScope topic = new TopicScope(id, 1.0);
                secondaryTopics.add(topic);
            }
        }
        Collections.sort(secondaryTopics, Comparator.comparing(TopicScope::getId));
        return secondaryTopics;
    }

    @Override
    public boolean isSmartsModuleReady() {
        return true;
    }

    @Override
    public String getContinuationToken() {
        return null;
    }
}

