/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.relatedvisualizations.util;

import com.ibm.smarts.model.QuickAccessSmartsModule;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.relatedvisualizations.rules.RelatedFieldsRule;
import com.ibm.smarts.relatedvisualizations.util.RelatedVisualizationCandidate;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.store.api.provider.UserActionStorable;
import com.ibm.smarts.useractions.actions.VisualizationAction;
import com.ibm.smarts.useractions.consumers.RelatedVisualizationConsumer;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RelatedVisualizationScoring {
    public static final double TOO_GOOD_TO_BE_TRUE_SCORE = (double)0.95f;
    public static final double TOO_GOOD_TO_BE_TRUE_SCORE_NEW_FIELDS = (double)0.55f;
    public static final double TOO_BAD_TO_BE_TRUE_SCORE = (double)0.01f;
    public static final double TOO_BAD_TO_BE_TRUE_SCORE_NEW_FIELDS = (double)0.03f;
    public static final double TARGET_CORRELATION = 0.5;
    private static final double NEUTRAL_SCORE = (double)0.2f;
    private static final double LEARNING_RATE_K = (double)0.05f;
    private static final double MAX_COMMUNITY_SCORE = 1.0;
    public static final double SINGLE_FIELD_INFLATION = 2.0;
    public static final double TOO_SIMILAR = 0.5;
    RelatedVisualizationConsumer keyGenerator = new RelatedVisualizationConsumer();
    private IUserActionStore userActionStore = null;
    private Map<String, ColumnInfo> columnInfoMap = new HashMap<String, ColumnInfo>();
    private QuickAccessSmartsModule columnIdentifierMap = null;

    public RelatedVisualizationScoring(IUserActionStore store, Map<String, ColumnInfo> map, QuickAccessSmartsModule ciMap) {
        this.userActionStore = store;
        this.columnInfoMap = map;
        this.columnIdentifierMap = ciMap;
    }

    public void calculateInterestingnessScore(List<RelatedVisualizationCandidate> candidates, RelatedFieldsRule relatedFieldsData, Set<ColumnIdentifier> inViewSet) {
        if (candidates.isEmpty()) {
            return;
        }
        for (RelatedVisualizationCandidate candidate : candidates) {
            this.calculateInterestingness(candidate, relatedFieldsData, inViewSet);
        }
    }

    private void calculateInterestingness(RelatedVisualizationCandidate candidate, RelatedFieldsRule relatedFieldsData, Set<ColumnIdentifier> inViewSet) {
        if (relatedFieldsData == null) {
            return;
        }
        ArrayList<Double> interestingnessScores = new ArrayList<Double>();
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField1(), candidate.getField2(), relatedFieldsData, inViewSet);
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField1(), candidate.getField3(), relatedFieldsData, inViewSet);
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField1(), candidate.getField4(), relatedFieldsData, inViewSet);
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField2(), candidate.getField3(), relatedFieldsData, inViewSet);
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField2(), candidate.getField4(), relatedFieldsData, inViewSet);
        this.getInterestingnessIfNewRelation(interestingnessScores, candidate.getField3(), candidate.getField4(), relatedFieldsData, inViewSet);
        if (interestingnessScores.isEmpty()) {
            candidate.setInterestingnessScore(0.0);
            return;
        }
        double sum = interestingnessScores.stream().mapToDouble(d -> d).sum();
        if (sum <= 0.0) {
            candidate.setInterestingnessScore(0.0);
            return;
        }
        int size = interestingnessScores.size();
        double percent = sum / (double)size;
        candidate.setInterestingnessScore(percent, 0.5);
    }

    private ColumnIdentifier getColumnIdentifier(String idForExpression) {
        if (idForExpression == null || idForExpression.isEmpty()) {
            return null;
        }
        return this.columnIdentifierMap.getColumnIdentifier(idForExpression);
    }

    private void getInterestingnessIfNewRelation(List<Double> interestingnessScores, String field1, String field2, RelatedFieldsRule relatedFieldsData, Set<ColumnIdentifier> inViewSet) {
        if (field1 == null || field2 == null || inViewSet.contains(this.getColumnIdentifier(field1)) && inViewSet.contains(this.getColumnIdentifier(field2))) {
            return;
        }
        interestingnessScores.add(relatedFieldsData.getInterestingnessConfidence(field1, field2));
    }

    public void generateUserPreferenceScore(List<RelatedVisualizationCandidate> candidates, String userId) {
        if (this.userActionStore == null || candidates.isEmpty()) {
            return;
        }
        HashMap<String, UserActionStorable> statsMap = new HashMap<String, UserActionStorable>();
        ArrayList<Integer> allScores = new ArrayList<Integer>();
        ArrayList<RelatedVisualizationCandidate> unscoredCandidates = new ArrayList<RelatedVisualizationCandidate>();
        for (RelatedVisualizationCandidate candidate : candidates) {
            UserActionStorable stats = this.getUserActionScore(candidate, statsMap, userId);
            if (stats.getScore() < 0) {
                allScores.add(stats.getScore());
                unscoredCandidates.add(candidate);
                continue;
            }
            candidate.setDislikeScore(0.0);
        }
        if (allScores.isEmpty()) {
            return;
        }
        Collections.sort(allScores);
        double median = ((Integer)allScores.get(allScores.size() / 2)).intValue();
        for (RelatedVisualizationCandidate candidate : unscoredCandidates) {
            UserActionStorable stats = this.getUserActionScore(candidate, statsMap, userId);
            candidate.setDislikeScore(this.getSigmoidScore(stats, median) - 1.0);
        }
    }

    public void generateUserCommunityScore(List<RelatedVisualizationCandidate> candidates) {
        UserActionStorable stats;
        if (this.userActionStore == null || candidates.isEmpty()) {
            return;
        }
        HashMap<String, UserActionStorable> statsMap = new HashMap<String, UserActionStorable>();
        ArrayList<Double> allScores = new ArrayList<Double>();
        boolean circulatingScores = false;
        for (RelatedVisualizationCandidate candidate : candidates) {
            stats = this.getUserActionScore(candidate, statsMap, "GlobalUser");
            if (stats.getHits() != stats.getScore()) {
                circulatingScores = true;
                statsMap.clear();
                allScores.clear();
                break;
            }
            allScores.add(this.getAdjustedScore(stats, circulatingScores));
        }
        if (circulatingScores) {
            for (RelatedVisualizationCandidate candidate : candidates) {
                stats = this.getUserActionScore(candidate, statsMap, "GlobalUser");
                allScores.add(this.getAdjustedScore(stats, circulatingScores));
            }
        }
        Collections.sort(allScores);
        double median = (Double)allScores.get(allScores.size() / 2);
        for (RelatedVisualizationCandidate candidate : candidates) {
            UserActionStorable stats2 = this.getUserActionScore(candidate, statsMap, "GlobalUser");
            candidate.setCommunityScore(this.getAdjustedSigmoidScore(stats2, median, circulatingScores));
        }
    }

    public MergeRelatedResult chooseTop(VisRecommendation topPair, VisRecommendation topTriple, int pairsIdx, int triplesIdx, int numResults, int numRequired) {
        if (topPair == null && topTriple == null) {
            return MergeRelatedResult.NEITHER;
        }
        if (topPair != null && topTriple == null) {
            return MergeRelatedResult.TWO_VAR;
        }
        if (topPair == null && topTriple != null) {
            return MergeRelatedResult.THREE_PLUS_VAR;
        }
        if (pairsIdx >= numResults - numRequired && triplesIdx < numRequired) {
            return MergeRelatedResult.THREE_PLUS_VAR;
        }
        if (triplesIdx >= numResults - numRequired && pairsIdx < numRequired) {
            return MergeRelatedResult.TWO_VAR;
        }
        if (topPair.isRuleBreaker() && !topTriple.isRuleBreaker()) {
            return MergeRelatedResult.THREE_PLUS_VAR;
        }
        if (!topPair.isRuleBreaker() && topTriple.isRuleBreaker()) {
            return MergeRelatedResult.TWO_VAR;
        }
        if (topPair.getScore() > topTriple.getScore()) {
            return MergeRelatedResult.TWO_VAR;
        }
        return MergeRelatedResult.THREE_PLUS_VAR;
    }

    private UserActionStorable getUserActionScore(RelatedVisualizationCandidate candidate, HashMap<String, UserActionStorable> statsMap, String userId) {
        String key1 = candidate.getField1();
        String key2 = candidate.getField2();
        String key = key1 + "|" + key2;
        if (candidate.getField3() != null) {
            key = key + "|" + candidate.getField3();
        }
        if (statsMap.containsKey(key)) {
            return statsMap.get(key);
        }
        ArrayList<ColumnInfo> ciList = new ArrayList<ColumnInfo>();
        ColumnInfo ci = this.columnInfoMap.get(key1);
        if (ci != null) {
            ciList.add(ci);
        }
        if ((ci = this.columnInfoMap.get(key2)) != null) {
            ciList.add(ci);
        }
        if (candidate.getField3() != null && (ci = this.columnInfoMap.get(candidate.getField3())) != null) {
            ciList.add(ci);
        }
        if (candidate.getField4() != null && (ci = this.columnInfoMap.get(candidate.getField4())) != null) {
            ciList.add(ci);
        }
        UserActionStorable stats = this.generateUserCommunityScoreByColumnInfos(ciList, userId);
        statsMap.put(key, stats);
        return stats;
    }

    public double getAdjustedSigmoidScore(UserActionStorable stats, double median, boolean circulatingScores) {
        double adjScore = this.getAdjustedScore(stats, circulatingScores);
        double distanceFromMedian = adjScore - median;
        return 1.0 / (1.0 + Math.exp((double)-0.05f * distanceFromMedian));
    }

    public double getSigmoidScore(UserActionStorable stats, double median) {
        double adjScore = stats.getScore();
        double distanceFromMedian = adjScore - median;
        return 1.0 / (1.0 + Math.exp((double)-0.05f * distanceFromMedian));
    }

    private double getAdjustedScore(UserActionStorable stats, boolean circulatingScores) {
        if (stats.getHits() == 0) {
            return 0.2f;
        }
        if (!circulatingScores) {
            return stats.getScore();
        }
        if (stats.getScore() == 0) {
            return -1.0 * (double)stats.getHits();
        }
        if (stats.getScore() == stats.getHits()) {
            return 1.0 + (double)stats.getHits() / 1000.0;
        }
        if (stats.getScore() > stats.getHits()) {
            return stats.getScore();
        }
        return (double)stats.getScore() / (double)stats.getHits();
    }

    private UserActionStorable generateUserCommunityScoreByColumnInfos(List<ColumnInfo> ciList, String userId) {
        VisualizationAction action = new VisualizationAction(null, ciList);
        String conceptKey = this.keyGenerator.getConceptKey(action);
        String lemmaKey = this.keyGenerator.getLemmaKey(action);
        UserActionStorable conceptStats = this.userActionStore.getStats(userId, conceptKey);
        UserActionStorable lemmaStats = this.userActionStore.getStats(userId, lemmaKey);
        return this.plus(conceptStats, lemmaStats);
    }

    private UserActionStorable plus(UserActionStorable a, UserActionStorable b) {
        UserActionStorable c = new UserActionStorable();
        c.setHits(a.getHits() + b.getHits());
        c.setScore(a.getScore() + b.getScore());
        return c;
    }

    public double extractStatistic(List<Statistic> stats, boolean isCategorical, boolean outIsCategorical) {
        StatisticType[] preferredOrder2;
        StatisticType[] preferredOrder1 = new StatisticType[]{StatisticType.CRAMERS_V, StatisticType.PEARSON, StatisticType.ETA};
        StatisticType[] preferredOrder = preferredOrder2 = new StatisticType[]{StatisticType.PEARSON, StatisticType.CRAMERS_V, StatisticType.ETA};
        if (outIsCategorical && isCategorical) {
            preferredOrder = preferredOrder1;
        }
        Value v = null;
        for (int idx = 0; idx < 3; ++idx) {
            v = this.getStatisticValue(stats, preferredOrder[idx]);
            if (v == null || v.isNull() || v.isError() || !v.isOK() || Double.isNaN(v.doubleValue()) || v.doubleValue() < (double)0.01f) {
                continue;
            }
            return v.doubleValue();
        }
        return 0.0;
    }

    private Value getStatisticValue(List<Statistic> list, StatisticType statType) {
        Statistic stat = list.stream().filter(s -> s.getType() == statType).findFirst().orElse(null);
        if (stat != null) {
            return stat.getValue();
        }
        return null;
    }

    public RelatedVizConcept isCategorical(String id) {
        return this.isCategorical(this.columnInfoMap.get(id));
    }

    public RelatedVizConcept isCategorical(ColumnInfo ci1) {
        if (ci1 == null) {
            return RelatedVizConcept.NEITHER;
        }
        SemanticInfo si = ci1.getSemanticInfo();
        if (si == null) {
            return RelatedVizConcept.NEITHER;
        }
        List<Concept> allConcepts = this.getFlattenedConceptsList(ConceptsRegistry.instance().getConcepts(si.getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())));
        boolean isCategorical = false;
        boolean isMeasure = false;
        for (Concept concept : allConcepts) {
            if (concept.getName().equals("Categorical")) {
                isCategorical = true;
                continue;
            }
            if (!concept.getName().equals("Measure")) continue;
            isMeasure = true;
        }
        if (isCategorical && isMeasure) {
            return RelatedVizConcept.BOTH;
        }
        if (isCategorical) {
            return RelatedVizConcept.CATEGORICAL;
        }
        if (isMeasure) {
            return RelatedVizConcept.MEASURE;
        }
        return RelatedVizConcept.NEITHER;
    }

    private List<Concept> getFlattenedConceptsList(List<Concept> ci) {
        if (ci.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Concept> conceptsList = new ArrayList<Concept>();
        for (Concept concept : ci) {
            conceptsList.add(concept);
            if (concept.getParents().isEmpty()) continue;
            conceptsList.addAll(concept.getAncestors());
        }
        return conceptsList;
    }

    public static enum RelatedVizConcept {
        CATEGORICAL,
        MEASURE,
        BOTH,
        NEITHER;

    }

    public static enum MergeRelatedResult {
        TWO_VAR,
        THREE_PLUS_VAR,
        NEITHER;

    }
}

