/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pda.analysis.anomaly;

import com.ibm.json.java.JSONArray;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.qs.ResultSet;
import com.ibm.smarts.pda.analysis.BasePurposeDrivenAnalysisQuery;
import com.ibm.smarts.pda.analysis.PDAContext;
import com.ibm.smarts.pda.analysis.PurposeDrivenAnalysis;
import com.ibm.smarts.pda.analysis.anomaly.AnomalyContext;
import com.ibm.smarts.pda.analysis.anomaly.MultipleMeasureAnomalyQuery;
import com.ibm.smarts.pda.analysis.anomaly.SingleMeasureAnomalyQuery;
import com.ibm.smarts.pda.util.RowIterator;
import java.io.IOException;

public class Anomaly
implements PurposeDrivenAnalysis {
    private InterestingFieldsRecommender fieldRecommender;
    private IDataProvider dataProvider;
    private final String baseUri;

    public Anomaly(IDataProvider dataProvider, InterestingFieldsRecommender fieldRecommender, String baseUri) {
        this.dataProvider = dataProvider;
        this.fieldRecommender = fieldRecommender;
        this.baseUri = baseUri;
    }

    @Override
    public String analyze(PDAContext context) throws IOException {
        AnomalyContext anomalyContext = (AnomalyContext)context;
        BasePurposeDrivenAnalysisQuery query = anomalyContext.getMeasures().size() == 1 ? new SingleMeasureAnomalyQuery(anomalyContext.getDatasetID(), anomalyContext.getMeasures().get(0), anomalyContext.getFactors(), "Anomaly Analysis") : new MultipleMeasureAnomalyQuery(anomalyContext.getDatasetID(), anomalyContext.getMeasures(), anomalyContext.getFactors(), "Anomaly Analysis");
        ResultSet result = query.execute(context.getRequestContext(), this.dataProvider, context.getDatasetID(), context.getDatasetType(), context.getConnections(), this.baseUri);
        RowIterator it = new RowIterator(result);
        if (!it.hasNext()) {
            return null;
        }
        JSONArray rows = new JSONArray();
        while (it.hasNext()) {
            rows.add((Object)it.next());
        }
        return rows.toString();
    }
}

