/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pda.analysis.anomaly;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.pda.analysis.BasePurposeDrivenAnalysisQuery;
import com.ibm.smarts.pda.util.PDAUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MultipleMeasureAnomalyQuery
extends BasePurposeDrivenAnalysisQuery {
    public MultipleMeasureAnomalyQuery(String id, List<String> measures, List<String> factors, String description) throws IOException {
        this.description = description;
        this.querySpec = this.buildQuerySpec(id, measures, factors);
    }

    private String buildQuerySpec(String id, List<String> measures, List<String> factors) throws IOException {
        JSONArray items = this.buildItems(measures, factors);
        JSONArray projections = this.buildProjection(factors);
        String strProj = projections.toString();
        strProj = strProj.substring(1, strProj.length() - 1);
        Properties queries = PDAUtil.loadProperties("/query/AnomalyQuery.properties");
        return String.format(queries.getProperty(this.getClass().getSimpleName()), id, items.stream().map(i -> i.toString()).collect(Collectors.joining(",")), strProj);
    }

    private JSONArray buildItems(List<String> measures, List<String> factors) {
        JSONArray result = new JSONArray();
        result.addAll((Collection)this.buildMeasure(measures));
        result.addAll((Collection)this.buildFactors(factors));
        return result;
    }

    private JSONArray buildProjection(List<String> factors) {
        JSONArray result = new JSONArray();
        IntStream.range(0, factors.size()).forEach(id -> {
            JSONObject proj = new JSONObject();
            proj.put((Object)"attr:refDataItem", (Object)("Factor" + id));
            result.add((Object)proj);
        });
        return result;
    }

    private JSONArray buildMeasure(List<String> ids) {
        JSONArray measures = new JSONArray();
        IntStream.range(0, ids.size()).forEach(id -> {
            JSONObject result = new JSONObject();
            result.put((Object)"attr:name", (Object)("Measure" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", ids.get(id));
            measures.add((Object)result);
            result = new JSONObject();
            result.put((Object)"attr:name", (Object)("Avg" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", (Object)String.format("average(total([Measure%s]) for report prefilter)", id));
            measures.add((Object)result);
            result = new JSONObject();
            result.put((Object)"attr:name", (Object)("SD" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", (Object)String.format("standard-deviation (total([Measure%s]) for report prefilter)", id));
            measures.add((Object)result);
            result = new JSONObject();
            result.put((Object)"attr:name", (Object)("Z" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", (Object)String.format("(total([Measure%s]) - [Avg%s])/[SD%s]", id, id, id));
            measures.add((Object)result);
        });
        JSONObject result = new JSONObject();
        result.put((Object)"attr:name", (Object)"ZMeasure");
        result.put((Object)"attr:aggregate", (Object)"automatic");
        String expr = IntStream.range(0, ids.size()).mapToObj(i -> "power([Z" + i + "], 2)").collect(Collectors.joining("+"));
        expr = "sqrt(" + expr + ")";
        result.put((Object)"expression", (Object)expr);
        measures.add((Object)result);
        return measures;
    }

    private JSONArray buildFactors(List<String> ids) {
        JSONArray factors = new JSONArray();
        IntStream.range(0, ids.size()).forEach(id -> {
            JSONObject result = new JSONObject();
            result.put((Object)"attr:name", (Object)("Factor" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", ids.get(id));
            factors.add((Object)result);
        });
        return factors;
    }
}

