/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pda.analysis.anomaly;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.pda.analysis.BasePurposeDrivenAnalysisQuery;
import com.ibm.smarts.pda.util.PDAUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SingleMeasureAnomalyQuery
extends BasePurposeDrivenAnalysisQuery {
    public SingleMeasureAnomalyQuery(String id, String measure, List<String> factors, String description) throws IOException {
        this.description = description;
        this.querySpec = this.buildQuerySpec(id, measure, factors);
    }

    private String buildQuerySpec(String id, String measure, List<String> factors) throws IOException {
        JSONArray items = this.buildItems(measure, factors);
        JSONArray projections = this.buildProjection(factors);
        String strProj = projections.toString();
        strProj = strProj.substring(1, strProj.length() - 1);
        Properties queries = PDAUtil.loadProperties("/query/AnomalyQuery.properties");
        return String.format(queries.getProperty(this.getClass().getSimpleName()), id, items.stream().map(i -> i.toString()).collect(Collectors.joining(",")), strProj);
    }

    private JSONArray buildItems(String measure, List<String> factors) {
        JSONArray result = new JSONArray();
        result.add((Object)this.buildMeasure(measure));
        result.addAll((Collection)this.buildFactors(factors));
        return result;
    }

    private JSONArray buildProjection(List<String> factors) {
        JSONArray result = new JSONArray();
        JSONObject measure = new JSONObject();
        measure.put((Object)"attr:refDataItem", (Object)"Measure");
        result.add((Object)measure);
        IntStream.range(0, factors.size()).forEach(id -> {
            JSONObject proj = new JSONObject();
            proj.put((Object)"attr:refDataItem", (Object)("Factor" + id));
            result.add((Object)proj);
        });
        return result;
    }

    private JSONObject buildMeasure(String id) {
        JSONObject result = new JSONObject();
        result.put((Object)"attr:name", (Object)"Measure");
        result.put((Object)"attr:aggregate", (Object)"total");
        result.put((Object)"expression", (Object)id);
        return result;
    }

    private JSONArray buildFactors(List<String> ids) {
        JSONArray factors = new JSONArray();
        IntStream.range(0, ids.size()).forEach(id -> {
            JSONObject result = new JSONObject();
            result.put((Object)"attr:name", (Object)("Factor" + id));
            result.put((Object)"attr:aggregate", (Object)"automatic");
            result.put((Object)"expression", ids.get(id));
            factors.add((Object)result);
        });
        return factors;
    }
}

