/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pda.util;

import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.ColumnInfoUtil;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PDAUtil {
    private static String dateConcept = "http://www.ibm.com/ontologies/waca/domain/common#Date";

    public static Set<String> getDims(List<String> columnIdForExpressions, JoinGraph joinGraph) {
        List dims = joinGraph.getRelatedNto1(columnIdForExpressions);
        return dims.stream().collect(Collectors.groupingBy(idForExpression -> idForExpression.substring(0, idForExpression.lastIndexOf(".")))).keySet();
    }

    public static ColumnInfo getDateInfluencer(String datasetID, SmartsModule smartsModule, JoinGraph joinGraph) {
        List<ColumnInfo> dates = PDAUtil.getDateColumns(datasetID, smartsModule, joinGraph);
        Optional<ImmutablePair> closetDateColumn = dates.stream().map(d -> new ImmutablePair(d, (Object)ColumnInfoUtil.getCount((ColumnInfo)d))).filter(p -> p.getRight() != null).sorted(Comparator.comparingLong(p -> (Long)p.getRight()).reversed()).findFirst();
        if (closetDateColumn.isPresent()) {
            return (ColumnInfo)closetDateColumn.get().getLeft();
        }
        return null;
    }

    public static List<ColumnInfo> getDateColumns(String datasetID, SmartsModule smartsModule, JoinGraph joinGraph) {
        Optional<DatasetInfo> datasetInfo = smartsModule.getDatasets().stream().filter(ds -> ds.getId().equals(datasetID)).findFirst();
        if (!datasetInfo.isPresent()) {
            return Collections.emptyList();
        }
        return PDAUtil.getDateColumns(datasetInfo, smartsModule, joinGraph);
    }

    public static List<ColumnInfo> getDateColumns(Optional<DatasetInfo> datasetInfo, SmartsModule smartsModule, JoinGraph joinGraph) {
        List<ColumnInfo> dates = PDAUtil.getDateColumns(datasetInfo);
        if (!dates.isEmpty()) {
            return dates;
        }
        if (datasetInfo.isPresent()) {
            Set<String> dims = PDAUtil.getDims(SmartsModuleUtil.getFlattenedColumns((BaseItemObject)((BaseItemObject)datasetInfo.get())).stream().map(BaseObject::getIdForExpression).collect(Collectors.toList()), joinGraph);
            return dims.stream().flatMap(dim -> PDAUtil.getDateColumns(smartsModule.getDatasets().stream().filter(ds -> ds.getId().equals(dim)).findFirst()).stream()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<ColumnInfo> getDateColumns(Optional<DatasetInfo> datasetInfo) {
        if (!datasetInfo.isPresent()) {
            return Collections.emptyList();
        }
        return SmartsModuleUtil.getFlattenedColumns((BaseItemObject)((BaseItemObject)datasetInfo.get())).stream().filter(c -> c.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).anyMatch(cid -> cid.equals(dateConcept))).collect(Collectors.toList());
    }

    public static Optional<ColumnInfo> getDimKey(DatasetInfo ds) {
        return SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().filter(c -> ColumnInfoUtil.getCount((ColumnInfo)c).equals(ColumnInfoUtil.getDistinctCount((ColumnInfo)c))).findFirst();
    }

    public static Optional<org.apache.commons.lang3.tuple.Pair<String, String>> getPrimaryKey(String tableId, String columnId, Module module) {
        return module.getRelationship().stream().map(r -> PDAUtil.getPrimaryKey(r, tableId, columnId)).filter(Objects::nonNull).findFirst();
    }

    public static org.apache.commons.lang3.tuple.Pair<String, String> getPrimaryKey(Relationship relationship, String tableId, String columnId) {
        Set oRefs;
        CardinalityType o;
        Set nRefs;
        CardinalityType n;
        if (relationship.getLeft().getMaxcard().equals((Object)CardinalityEnum.MANY)) {
            n = relationship.getLeft();
            nRefs = relationship.getLink().stream().map(l -> l.getLeftRef()).collect(Collectors.toSet());
            o = relationship.getRight();
            oRefs = relationship.getLink().stream().map(l -> l.getRightRef()).collect(Collectors.toSet());
        } else if (relationship.getRight().getMaxcard().equals((Object)CardinalityEnum.MANY)) {
            n = relationship.getRight();
            nRefs = relationship.getLink().stream().map(l -> l.getRightRef()).collect(Collectors.toSet());
            o = relationship.getLeft();
            oRefs = relationship.getLink().stream().map(l -> l.getLeftRef()).collect(Collectors.toSet());
        } else {
            return null;
        }
        if (n.getRef().equals(tableId) && nRefs.contains(columnId)) {
            return new ImmutablePair((Object)o.getRef(), oRefs.stream().sorted().findFirst().get());
        }
        return null;
    }

    public static boolean isIDCaption(FieldRecommendationRecord rec, SmartsModule smartsModule) {
        String id = "http://www.ibm.com/ontologies/waca/domain/common#Identifier";
        String name = "http://www.ibm.com/ontologies/waca/domain/common#Caption";
        return smartsModule.getDatasets().stream().flatMap(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream()).filter(c -> c.getIdForExpression().equals(rec.getFieldIDForExpression())).anyMatch(c -> c.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).anyMatch(cpt -> cpt.equals(id) || cpt.equals(name)));
    }

    public static boolean isDate(FieldRecommendationRecord rec, SmartsModule smartsModule) {
        String id = "http://www.ibm.com/ontologies/waca/domain/common#Date";
        return smartsModule.getDatasets().stream().flatMap(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream()).filter(c -> c.getIdForExpression().equals(rec.getFieldIDForExpression())).anyMatch(c -> c.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).anyMatch(cpt -> cpt.equals(id)));
    }

    public static boolean isLatitudeLongitude(FieldRecommendationRecord rec, SmartsModule smartsModule) {
        String latitude = "http://www.ibm.com/ontologies/waca/domain/common#Latitude";
        String longitude = "http://www.ibm.com/ontologies/waca/domain/common#Longitude";
        return smartsModule.getDatasets().stream().flatMap(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream()).filter(c -> c.getIdForExpression().equals(rec.getFieldIDForExpression())).anyMatch(c -> c.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).anyMatch(cpt -> cpt.equals(latitude) || cpt.equals(longitude)));
    }

    public static Map<Pair<String, String>, BivariateStatistics> toMap(List<BivariateStatistics> bv) {
        HashMap<Pair<String, String>, BivariateStatistics> retVal = new HashMap<Pair<String, String>, BivariateStatistics>(bv.size());
        bv.forEach(bvValue -> retVal.put((Pair<String, String>)new Pair((Object)bvValue.getColumn1(), (Object)bvValue.getColumn2()), (BivariateStatistics)bvValue));
        return retVal;
    }

    public static JSONObject stratify(JSONArray data, String[] cols, boolean sorted) {
        if (!sorted) {
            data.sort(Comparator.comparing(r -> Stream.of(cols).map(c -> ((JSONObject)r).get(c).toString()).collect(Collectors.joining())));
        }
        String[] currentColValues = new String[cols.length];
        JSONObject root = new JSONObject();
        JSONArray children = new JSONArray();
        root.put((Object)"name", (Object)"root");
        root.put((Object)"children", (Object)children);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject parent = root;
            JSONObject r2 = (JSONObject)data.get(i);
            for (int l = 0; l < cols.length; ++l) {
                String col = cols[l];
                String name = (String)r2.get((Object)col);
                if (!name.equals(currentColValues[l])) {
                    currentColValues[l] = name;
                    JSONObject currentLevel = new JSONObject();
                    currentLevel.put((Object)"name", (Object)name);
                    if (l == cols.length - 1) {
                        Double diff = Double.parseDouble(r2.get((Object)"Diff").toString());
                        currentLevel.put((Object)"value", (Object)diff);
                    } else {
                        currentLevel.put((Object)"children", (Object)new JSONArray());
                        for (int j = l + 1; j < cols.length; ++j) {
                            currentColValues[j] = null;
                        }
                    }
                    ((JSONArray)parent.get((Object)"children")).add((Object)currentLevel);
                    parent = currentLevel;
                    continue;
                }
                JSONArray currentChildren = (JSONArray)parent.get((Object)"children");
                parent = (JSONObject)currentChildren.get(currentChildren.size() - 1);
            }
        }
        return root;
    }

    public static Properties loadProperties(String path) throws IOException {
        InputStream in = null;
        try {
            in = PDAUtil.loadFromClasspath(path);
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                Properties properties = props;
                return properties;
            }
            throw new IOException(String.format("%s is missing.", path));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static InputStream loadFromClasspath(String path) {
        InputStream in = PDAUtil.class.getResourceAsStream(path);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(path);
        }
        return in;
    }
}

