/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pda.util;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.model.qs.Edge;
import com.ibm.smarts.model.qs.Header;
import com.ibm.smarts.model.qs.Identifier;
import com.ibm.smarts.model.qs.Item;
import com.ibm.smarts.model.qs.ItemClass;
import com.ibm.smarts.model.qs.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class RowIterator
implements Iterator<JSONObject> {
    private Edge edge;
    private Iterator<Item> it;
    private List<Header> headers;

    public RowIterator(ResultSet resultSet) {
        if (resultSet.getEdges() != null && !resultSet.getEdges().isEmpty()) {
            this.edge = (Edge)resultSet.getEdges().get(0);
            this.it = this.edge.getItems() != null ? this.edge.getItems().iterator() : null;
            this.headers = this.edge.getItemClasses() != null ? ((ItemClass)this.edge.getItemClasses().get(0)).getH() : null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.it != null && this.it.hasNext();
    }

    @Override
    public JSONObject next() {
        Item item = this.it.next();
        JSONObject row = new JSONObject();
        IntStream.range(0, item.getT().size()).forEach(i -> {
            Map c = (Map)item.getT().get(i);
            Object v = c.get("v");
            if (v == null) {
                if (c.get("deco") != null && ((Map)c.get("deco")).get("state").equals("NULL")) {
                    v = 1.0E-6;
                } else {
                    Long rId = new Long(c.get("rId").toString());
                    v = ((Identifier)this.edge.getIdentifiers().get(rId)).getD();
                }
            }
            row.put((Object)this.headers.get(i).getDi(), v);
        });
        return row;
    }
}

