/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7EncryptedData;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7EnvelopedData;
import java.security.cert.X509Certificate;

public class EncryptingSession
extends DefaultAdditionalInfoHandler {
    private String serviceID;

    EncryptingSession(String serviceID) {
        this.serviceID = serviceID;
    }

    public byte[] encryptData(byte[] cleartext) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("encryptData", this);
        ipfFunction.addParameter("cleartext", cleartext);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            byte[] ciphertext = PKCS7EncryptedData.encode(KeyStoreReader.getCSKWithExpiryCheck(), cleartext);
            new IPFTraceFunction("encryptData", this).logExit(ciphertext);
            return ciphertext;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("encryptData", this).logExit(e);
            throw e;
        }
    }

    public byte[] encryptAsymmetric(byte[] cleartext, X509Certificate[] recipients) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("encryptAsymmetric", this);
        ipfFunction.addParameter("cleartext", cleartext);
        ipfFunction.addParameter("recipients", recipients);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            byte[] ciphertext = PKCS7EnvelopedData.encode(recipients, cleartext);
            new IPFTraceFunction("encryptAsymmetric", this).logExit(ciphertext);
            return ciphertext;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("encryptAsymmetric", this).logExit(e);
            throw e;
        }
    }

    public byte[] decryptData(byte[] ciphertext) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("decryptData", this);
        ipfFunction.addParameter("ciphertext", ciphertext);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            byte[] cleartext = PKCS7EncryptedData.decode(ciphertext);
            new IPFTraceFunction("decryptData", this).logExit(cleartext);
            return cleartext;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("decryptData", this).logExit(e);
            throw e;
        }
    }

    public byte[] decryptAsymmetric(byte[] ciphertext) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("decryptAsymmetric", this);
        ipfFunction.addParameter("ciphertext", ciphertext);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            byte[] cleartext = PKCS7EnvelopedData.decode(ciphertext);
            new IPFTraceFunction("decryptAsymmetric", this).logExit(cleartext);
            return cleartext;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("decryptAsymmetric", this).logExit(e);
            throw e;
        }
    }
}

