/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.GenericHMACToken;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class GenericHMACSession {
    private int version = 2;
    private String pwdString = null;
    private Mac mac = null;
    private static String strongPBECipher_v1 = "PBEWithMD5AndTripleDES";
    private SecretKey sessionHMACKey_v1 = null;
    private static String strongPBECipher_v2 = "PBEWithSHA1AndDESede";
    private SecretKey sessionHMACKey_v2 = null;

    GenericHMACSession(byte[] password) throws CAMCryptoException {
        this.setPassword(password);
    }

    GenericHMACSession() throws CAMCryptoException {
    }

    public void setVersion(int ver) {
        this.version = ver;
    }

    public void setPassword(byte[] password) throws CAMCryptoException {
        if (password == null || password.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_password_nodata"));
        }
        this.pwdString = new String(password);
        this.generatePBEKey();
        this.mac = null;
    }

    private void generatePBEKey() throws CAMCryptoException {
        if (this.pwdString == null || this.pwdString.length() == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_password_nodata"));
        }
        try {
            PBEKeySpec keySpec = new PBEKeySpec(this.pwdString.toCharArray());
            String pbeProvider = JVMEnvironment.getInstance().getPBEProvider();
            SecretKeyFactory keyFactory1 = SecretKeyFactory.getInstance(strongPBECipher_v1, pbeProvider);
            this.sessionHMACKey_v1 = keyFactory1.generateSecret(keySpec);
            SecretKeyFactory keyFactory2 = SecretKeyFactory.getInstance(strongPBECipher_v2, pbeProvider);
            this.sessionHMACKey_v2 = keyFactory2.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_generic_hmac_cipher_key"));
        }
    }

    private Mac createMacV0(IConfiguration config) throws CAMCryptoException {
        if (JVMEnvironment.getInstance().isFIPSEnabled()) {
            String hmacAlg = config.getHMACAlgorithm();
            return this.createMac(hmacAlg);
        }
        return this.createMac("HmacSHA1");
    }

    protected Mac createMac(String algorithm) throws CAMCryptoException {
        try {
            Mac theMac = Mac.getInstance(algorithm);
            return theMac;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_mac_obj"));
        }
    }

    public byte[] protectDataV0(byte[] data) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        if (this.mac == null) {
            this.mac = this.createMacV0(config);
            try {
                this.mac.init(this.sessionHMACKey_v1);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_mac_obj"));
            }
        }
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        byte[] hmacData = null;
        hmacData = this.mac.doFinal(data);
        return hmacData;
    }

    public byte[] protectDataV1(byte[] data) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Configuration config = Configuration.getInstance();
        String algorithm = config.getDigestAlgorithm();
        GenericHMACToken token = this.createTokenV1(data, algorithm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        token.setVersion(1);
        token.writeToken(out);
        return out.toByteArray();
    }

    public byte[] protectData(byte[] data) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Configuration config = Configuration.getInstance();
        String algorithm = config.getDigestAlgorithm();
        GenericHMACToken token = this.createTokenV2(data, algorithm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        token.writeToken(out);
        return out.toByteArray();
    }

    public byte[] protectDataV0(byte[] data, byte[] password) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.setPassword(password);
        byte[] hmacData = null;
        hmacData = this.protectDataV0(data);
        return hmacData;
    }

    public byte[] protectDataV1(byte[] data, byte[] password) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.setPassword(password);
        return this.protectDataV1(data);
    }

    public byte[] protectData(byte[] data, byte[] password) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.setPassword(password);
        return this.protectData(data);
    }

    private GenericHMACToken createTokenV1(byte[] data, String algorithm) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        Mac theMac = this.createMac(config.getHMACAlgorithm(algorithm));
        try {
            theMac.init(this.sessionHMACKey_v1);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_mac_obj"));
        }
        GenericHMACToken token = new GenericHMACToken(algorithm, theMac, data);
        return token;
    }

    private GenericHMACToken createTokenV2(byte[] data, String algorithm) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        Mac theMac = this.createMac(config.getHMACAlgorithm(algorithm));
        try {
            theMac.init(this.sessionHMACKey_v2);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_mac_obj"));
        }
        GenericHMACToken token = new GenericHMACToken(algorithm, theMac, data);
        return token;
    }

    public boolean verifyData(byte[] hmacData, byte[] data) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        if (hmacData == null || hmacData.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        try {
            GenericHMACToken token = new GenericHMACToken();
            ByteArrayInputStream in = new ByteArrayInputStream(hmacData);
            token.readToken(in);
            String algorithm = token.getAlgorithm();
            int version = token.getVersion();
            GenericHMACToken token2 = null;
            if (version == GenericHMACToken.VERSION1) {
                token2 = this.createTokenV1(data, algorithm);
            } else if (version == GenericHMACToken.VERSION2) {
                token2 = this.createTokenV2(data, algorithm);
            } else {
                return false;
            }
            boolean bResult1 = token.verify(token2);
            if (bResult1) {
                return bResult1;
            }
        }
        catch (Exception token) {
            // empty catch block
        }
        byte[] hmacVerifyData = null;
        hmacVerifyData = this.protectDataV0(data);
        boolean bResult2 = Arrays.equals(hmacVerifyData, hmacData);
        return bResult2;
    }

    public boolean verifyData(byte[] hmacData, byte[] data, byte[] password) throws CAMCryptoException {
        if (data == null || data.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        if (hmacData == null || hmacData.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.setPassword(password);
        return this.verifyData(hmacData, data);
    }
}

