/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.value.DecimalValue;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.ApplicationOntologyReasoner;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class ApplicationConceptClassification
extends AbstractSmartsModuleClassificationStep {
    private static final String DUMMY_TIMESTAMP = "2004-04-12T13:20:00Z";
    private static final String DUMMY_DATE = "2013-11-09T00:00:00";
    private List<Ontology<OWLOntology>> mOntologies = null;

    ApplicationConceptClassification(List<Ontology<OWLOntology>> ontologies, RequestContext reqCtx) {
        super(reqCtx);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.getDatasetClassificationPkgs().forEach(this::classify);
        this.clearMDC();
    }

    private void classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return;
        }
        if (this.isExecParallel()) {
            IntStream.range(0, inScopeColPkgs.size()).parallel().forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        } else {
            IntStream.range(0, inScopeColPkgs.size()).forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        }
    }

    private void classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope) {
        if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.CONCEPTS)) {
            if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.CONCEPTS) && columnPkg.getColumnInfo().getSemanticInfo() != null && columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().anyMatch(this::isApplicatoinConcept)) {
                return;
            }
            this.mdcColInfo(index, columnPkg);
            this.mOntologies.forEach(o -> this.classify(index, columnPkg, (Ontology<OWLOntology>)o));
        }
    }

    private void classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        try {
            ColumnInfo column = columnPkg.getColumnInfo();
            LOGGER.info("Classify column [{}]:{}", (Object)index, (Object)column.getId());
            LOGGER.info("\tName = {}, Data Type = {}", (Object)column.getName(), (Object)column.getDataType());
            LOGGER.info("\tStatistics = {}", (Object)column.getStatistics().stream().map(s -> s.getType().name() + ":" + s.getValue()).collect(Collectors.joining(", ")));
            LOGGER.info("\tValueDecorations =  " + column.getValueDecorations());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\tSamples = " + column.getSamples());
            }
            ObjectFactory objFactory = new ObjectFactory();
            if (columnPkg.getColumnInfo().getDataType().getBaseType().equals((Object)BaseDataType.TIME)) {
                this.addConcept(columnPkg, IRI.create((String)"http://www.ibm.com/ontologies/waca/application#TimeType"), objFactory, 1.0f);
                this.addConcept(columnPkg, IRI.create((String)"http://www.ibm.com/ontologies/waca/application#Categorical"), objFactory, 1.0f);
            }
            OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
            Map<IRI, List<OWLLiteral>> propertyValues = this.buildDataPropertyMap(index, column, factory);
            columnPkg.setDataPropertyValues(propertyValues);
            Set<ConceptInfo> concepts = ApplicationOntologyReasoner.getConcepts((OWLOntology)ontology.getValue(), propertyValues, this.getCleanedSampleData(column), objFactory, this.currentReqCtx);
            this.validate(columnPkg, concepts);
            LOGGER.info("Classification Results\t= {}", (Object)concepts.stream().map(ConceptInfo::getConceptID).collect(Collectors.joining(", ")));
            concepts.forEach(c -> {
                Optional<ConceptInfo> existing = columnPkg.getConcepts().stream().filter(concept -> concept.getConceptID().equals(c.getConceptID())).findFirst();
                if (existing.isPresent()) {
                    if (Float.compare(c.getConfidence(), existing.get().getConfidence()) > 0) {
                        existing.get().setConfidence(c.getConfidence());
                    }
                } else {
                    columnPkg.getConcepts().add((ConceptInfo)c);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error(String.format("Caught exception while processing column [%s]", columnPkg.getColumnInfo().getName()), (Throwable)ex);
        }
    }

    private void validate(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Set<ConceptInfo> concepts) {
        if (columnPkg.getAnalysisMode() == AnalysisModeType.SHALLOW) {
            concepts.removeIf(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/application#Empty"));
        }
    }

    private Map<IRI, List<OWLLiteral>> buildDataPropertyMap(int index, ColumnInfo column, OWLDataFactory factory) {
        double density;
        HashMap<IRI, List<OWLLiteral>> propertyValues = new HashMap<IRI, List<OWLLiteral>>();
        propertyValues.put(DATA_COLUMN_INDEX_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(index)));
        List valueDecorations = column.getValueDecorations().stream().map(d -> factory.getOWLLiteral(d.getType().name(), OWL2Datatype.XSD_STRING)).collect(Collectors.toList());
        propertyValues.put(DATA_DECORATION_PROPERTY_IRI, valueDecorations);
        if ((column.getDataType().isInteger() || column.getDataType().isString()) && column.getSamples().stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(String::length).collect(Collectors.toSet()).size() == 1) {
            valueDecorations.add(factory.getOWLLiteral("UNIFORM", OWL2Datatype.XSD_STRING));
        }
        String aSampleValue = null;
        List<String> samples = this.getCleanedSampleData(column);
        if (!samples.isEmpty()) {
            aSampleValue = samples.get(0);
            if (column.getDataType().getBaseType().equals((Object)BaseDataType.TIMESTAMP)) {
                aSampleValue = DUMMY_TIMESTAMP;
            } else if (column.getDataType().getBaseType().equals((Object)BaseDataType.DATE)) {
                aSampleValue = DUMMY_DATE;
            } else if (column.getDataType().getBaseType().equals((Object)BaseDataType.LONG)) {
                aSampleValue = String.valueOf(Integer.MAX_VALUE);
            } else if (column.getDataType().isBoolean()) {
                aSampleValue = "1";
            }
        } else {
            aSampleValue = column.getDataType().isUnknown() ? "" : (column.getDataType().getBaseType().equals((Object)BaseDataType.TIMESTAMP) ? DUMMY_TIMESTAMP : (column.getDataType().isTemporal() ? DUMMY_DATE : "0"));
        }
        if (column.getDataType().getBaseType() == BaseDataType.DECIMAL) {
            aSampleValue = this.getDecimalStringValue(aSampleValue);
        }
        propertyValues.put(DATA_VALUE_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(aSampleValue, ApplicationConceptClassification.getOWL2Datatype(column))));
        this.buildDataPropertyMapFromStatistics(column, factory, propertyValues);
        List temp = (List)propertyValues.get(DATA_COUNT_PROPETY_IRI);
        if (temp == null && samples.isEmpty()) {
            propertyValues.put(DATA_COUNT_PROPETY_IRI, Collections.singletonList(factory.getOWLLiteral(0)));
        }
        int count = temp == null ? 0 : ((OWLLiteral)temp.get(0)).parseInteger();
        temp = (List)propertyValues.get(DATA_DISTINCT_COUNT_PROPERTY_IRI);
        if (temp == null && samples.isEmpty()) {
            propertyValues.put(DATA_DISTINCT_COUNT_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(0)));
        }
        int countDistinct = temp == null ? 0 : ((OWLLiteral)temp.get(0)).parseInteger();
        temp = (List)propertyValues.get(DATA_DENSITY_PROPERTY_IRI);
        double d2 = density = temp == null ? 1.0 : ((OWLLiteral)temp.get(0)).parseDouble();
        if (count > 0 && countDistinct > 0) {
            Double uniqueValueRatio = (double)countDistinct / (double)count;
            propertyValues.put(DATA_UNIQUE_VALUE_RATIO_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(uniqueValueRatio.toString(), OWL2Datatype.XSD_DOUBLE)));
            Double repetitionRatio = (double)countDistinct / (double)count * density;
            propertyValues.put(DATA_REPETITION_RATIO_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(repetitionRatio.toString(), OWL2Datatype.XSD_DOUBLE)));
        }
        if (!propertyValues.keySet().contains(DATA_MIN_PROPERTY_IRI)) {
            propertyValues.put(DATA_MAX_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral("0", ApplicationConceptClassification.getOWL2Datatype(column))));
        }
        if (!propertyValues.keySet().contains(DATA_MAX_PROPERTY_IRI)) {
            propertyValues.put(DATA_MAX_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral("0", ApplicationConceptClassification.getOWL2Datatype(column))));
        }
        this.computeDataQuartileRatios(propertyValues, column, factory);
        return propertyValues;
    }

    private void buildDataPropertyMapFromStatistics(ColumnInfo column, OWLDataFactory factory, Map<IRI, List<OWLLiteral>> propertyValues) {
        IntegerValue count = new IntegerValue();
        column.getStatistics().stream().filter(s -> s.getType() == StatisticType.COUNT).findFirst().ifPresent(s -> count.set(s.getValue().intValue()));
        column.getStatistics().forEach(s -> {
            if (null == s.getValue() || !s.getValue().isOK()) {
                if (null == s.getValue() && count.getValue() != 0 || null != s.getValue() && !s.getValue().isOK()) {
                    LOGGER.error(String.format("Invalid stats %s with value %s", s.getType(), s.getValue()));
                }
            } else {
                switch (s.getType()) {
                    case COUNT: {
                        propertyValues.put(DATA_COUNT_PROPETY_IRI, Collections.singletonList(factory.getOWLLiteral(s.getValue().intValue())));
                        break;
                    }
                    case DISTINCT_COUNT: {
                        propertyValues.put(DATA_DISTINCT_COUNT_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(s.getValue().intValue())));
                        break;
                    }
                    case NULL_COUNT: {
                        propertyValues.put(DATA_NULL_COUNT_PROPETY_IRI, Collections.singletonList(factory.getOWLLiteral(s.getValue().intValue())));
                        break;
                    }
                    case DENSITY: {
                        propertyValues.put(DATA_DENSITY_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(s.getValue().stringValue(), OWL2Datatype.XSD_DOUBLE)));
                        break;
                    }
                    case MIN_VALUE: {
                        propertyValues.put(DATA_MIN_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(this.getBoundryValue(column, (Statistic)s), ApplicationConceptClassification.getOWL2Datatype(column))));
                        break;
                    }
                    case MAX_VALUE: {
                        propertyValues.put(DATA_MAX_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(this.getBoundryValue(column, (Statistic)s), ApplicationConceptClassification.getOWL2Datatype(column))));
                        break;
                    }
                }
            }
        });
        this.setDataStep(column, factory, propertyValues);
    }

    private void setDataStep(ColumnInfo column, OWLDataFactory factory, Map<IRI, List<OWLLiteral>> propertyValues) {
        if (ApplicationConceptClassification.getOWL2Datatype(column).equals((Object)OWL2Datatype.XSD_INTEGER)) {
            int countDistinct;
            List<OWLLiteral> temp = propertyValues.get(DATA_MIN_PROPERTY_IRI);
            int min = temp == null ? 0 : temp.get(0).parseInteger();
            temp = propertyValues.get(DATA_MAX_PROPERTY_IRI);
            int max = temp == null ? 0 : temp.get(0).parseInteger();
            temp = propertyValues.get(DATA_DISTINCT_COUNT_PROPERTY_IRI);
            int n = countDistinct = temp == null ? 0 : temp.get(0).parseInteger();
            if (countDistinct > 0) {
                if (min == max) {
                    propertyValues.put(DATA_STEP_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral("0", OWL2Datatype.XSD_INTEGER)));
                } else {
                    int dataStep = (int)Math.ceil(((double)(max - min) + 1.0) / (double)countDistinct);
                    propertyValues.put(DATA_STEP_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral(String.valueOf(dataStep), OWL2Datatype.XSD_INTEGER)));
                }
            }
        }
    }

    private void computeDataQuartileRatios(Map<IRI, List<OWLLiteral>> propertyValues, ColumnInfo column, OWLDataFactory factory) {
        if (!column.getDataType().isNumeric()) {
            return;
        }
        Optional<Statistic> sampleQ1 = column.getSampleStatistics().stream().filter(s -> s.getType() == StatisticType.Q_1).findAny();
        Optional<Statistic> sampleQ3 = column.getSampleStatistics().stream().filter(s -> s.getType() == StatisticType.Q_3).findAny();
        Optional<Statistic> min = column.getStatistics().stream().filter(s -> s.getType() == StatisticType.MIN_VALUE).findAny();
        Optional<Statistic> max = column.getStatistics().stream().filter(s -> s.getType() == StatisticType.MAX_VALUE).findAny();
        if (sampleQ1.isPresent() && sampleQ3.isPresent() && min.isPresent() && max.isPresent()) {
            double dQ1 = sampleQ1.get().getValue().doubleValue();
            double dQ3 = sampleQ3.get().getValue().doubleValue();
            double dMin = min.get().getValue().doubleValue();
            double dMax = max.get().getValue().doubleValue();
            if (Double.compare(dQ3, dQ1) != 0) {
                propertyValues.put(DATA_QUARTILE_LOWER_RATIO_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral((dQ1 - dMin) / (dQ3 - dQ1))));
                propertyValues.put(DATA_QUARTILE_UPPER_RATIO_PROPERTY_IRI, Collections.singletonList(factory.getOWLLiteral((dMax - dQ3) / (dQ3 - dQ1))));
            }
        }
    }

    private String getBoundryValue(ColumnInfo column, Statistic s) {
        String v = s.getValue().stringValue();
        if (column.getDataType().getBaseType().equals((Object)BaseDataType.LONG)) {
            if (s.getValue().longValue() < Integer.MIN_VALUE) {
                v = String.valueOf(Integer.MIN_VALUE);
            } else if (s.getValue().longValue() > Integer.MAX_VALUE) {
                v = String.valueOf(Integer.MAX_VALUE);
            }
        }
        if (column.getDataType().getBaseType() == BaseDataType.DECIMAL) {
            v = this.getDecimalStringValue(v);
        }
        return v;
    }

    private String getDecimalStringValue(String value) {
        DecimalValue dv = new DecimalValue();
        dv.assignFrom(value);
        return dv.stringValue();
    }
}

