/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.SemanticAnalysisHelper;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ClueHit;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class CandidateElection
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    CandidateElection(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg pkg) {
        pkg.setModified(true);
        Map mappings = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getDomainDefaultConceptMappings();
        Map mapping = (Map)mappings.get(this.mOntologies.get(0).getOntologyID());
        if (!this.isExecParallel()) {
            ArrayList collectDurations = new ArrayList();
            pkg.getDatasetClassificationPkgs().forEach(dp -> {
                this.mdcDSInfo((SmartsModuleClassificationPkg.DatasetClassificationPkg)dp);
                List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dp.getInScopeColumnClassificationPkgs();
                if (inScopeColPkgs.isEmpty()) {
                    return;
                }
                for (int i = 0; i < inScopeColPkgs.size(); ++i) {
                    SmartsModuleClassificationPkg.ColumnClassificationPkg ccp;
                    if (!this.shouldExecute(inScopeColPkgs.get(i), dp.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME) || this.createCandidateFromDefaultMapping(mapping, ccp = inScopeColPkgs.get(i))) continue;
                    this.collectCandidates(i, ccp, collectDurations);
                }
            });
            LOGGER.warn(String.format("==> Search clues sequentially in CandidateElection step took [%s]ms", collectDurations.stream().mapToLong(Duration::toMillis).sum()));
        } else {
            this.executeAsync(pkg, mapping);
        }
        this.clearMDC();
    }

    private boolean createCandidateFromDefaultMapping(Map<String, ConceptInfo> mapping, SmartsModuleClassificationPkg.ColumnClassificationPkg ccp) {
        ConceptInfo concept;
        boolean hasCreated = false;
        if (mapping != null && (concept = mapping.get(ccp.getColumnInfo().getName().toLowerCase(this.currentReqCtx.locale))) != null) {
            ccp.addCandidate(Optional.of(this.createCandidate(concept)));
            ccp.addConcept(concept);
            hasCreated = true;
        }
        return hasCreated;
    }

    private SmartsModuleClassificationPkg.Candidate createCandidate(ConceptInfo concept) {
        SmartsModuleClassificationPkg.Candidate c = new SmartsModuleClassificationPkg.Candidate(IRI.create((String)concept.getConceptID())).setLexicalRelevance(concept.getConfidence()).setRelevance(concept.getConfidence());
        LOGGER.info("Create a candidate based on default mapping: {}", (Object)c.toString());
        return c;
    }

    public void executeAsync(SmartsModuleClassificationPkg pkg, Map<String, ConceptInfo> mapping) {
        Instant before = Instant.now();
        ArrayList fs = new ArrayList();
        pkg.getDatasetClassificationPkgs().forEach(dp -> {
            this.mdcDSInfo((SmartsModuleClassificationPkg.DatasetClassificationPkg)dp);
            List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dp.getInScopeColumnClassificationPkgs();
            if (inScopeColPkgs.isEmpty()) {
                return;
            }
            for (int i = 0; i < inScopeColPkgs.size(); ++i) {
                SmartsModuleClassificationPkg.ColumnClassificationPkg ccp;
                if (!this.shouldExecute(inScopeColPkgs.get(i), dp.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME) || this.createCandidateFromDefaultMapping(mapping, ccp = inScopeColPkgs.get(i))) continue;
                fs.add(this.collectCandidatesAsync(i, ccp));
            }
        });
        LOGGER.warn("Waiting for " + fs.size() + " futures to complete...");
        CompletableFuture.allOf(fs.toArray(new CompletableFuture[fs.size()])).join();
        LOGGER.warn(String.format("==> Search clues async in CandidateElection step took [%s]ms ", Duration.between(before, Instant.now()).toMillis()));
    }

    private void collectCandidates(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg ccp, List<Duration> collectDurations) {
        this.mdcColInfo(index, ccp);
        TextInfo textInfo = ccp.getColumnLabel();
        if (textInfo == null) {
            LOGGER.error("Missing TextInfo of [{}]", (Object)ccp.getColumnInfo().getName());
            return;
        }
        String lang = StringUtils.isBlank((CharSequence)textInfo.getLanguage()) ? this.currentReqCtx.locale.getLanguage() : textInfo.getLanguage();
        List phrases = textInfo.getPhrases();
        if (phrases.isEmpty()) {
            LOGGER.error("Missing PhraseInfo of [{}]", (Object)ccp.getColumnInfo().getName());
            return;
        }
        PhraseInfo columnLabel = (PhraseInfo)phrases.get(0);
        HashMap<String, List<ClueHit>> groups = new HashMap<String, List<ClueHit>>();
        try {
            groups.putAll(SemanticAnalysisHelper.collectHits(lang, columnLabel, collectDurations, this.currentReqCtx, this.mOntologies));
        }
        catch (Exception e) {
            LOGGER.error("Failed collecting hits for [{}]", (Object)columnLabel);
            return;
        }
        this.collectCandidates(ccp, columnLabel, groups);
    }

    private void collectCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg ccp, PhraseInfo columnLabel, Map<String, List<ClueHit>> groups) {
        Collection<ClueHit> results = SemanticAnalysisHelper.computeCandidates(columnLabel, groups);
        Optional.ofNullable(results).ifPresent(rs -> rs.stream().sorted(Comparator.comparing(ClueHit::getScore).reversed()).forEach(r -> {
            SmartsModuleClassificationPkg.ColumnClassificationPkg columnClassificationPkg = ccp;
            synchronized (columnClassificationPkg) {
                ccp.addCandidate(Optional.of(this.createCandidate((ClueHit)r)));
            }
        }));
        LOGGER.warn("Elected candidates for [{}]", (Object)columnLabel.getText());
        ccp.getCandidates().forEach(c -> LOGGER.warn(c.toString()));
    }

    private SmartsModuleClassificationPkg.Candidate createCandidate(ClueHit r) {
        float normalizedScore = (float)(1.0 - Math.exp(-r.getScore()));
        SmartsModuleClassificationPkg.Candidate c = new SmartsModuleClassificationPkg.Candidate(IRI.create((String)r.getClue().getConceptID().trim())).setLexicalRelevance(normalizedScore).setRelevance(normalizedScore);
        LOGGER.debug("Original = {}, Normalized = {}", (Object)Float.valueOf(r.getScore()), (Object)Float.valueOf(c.getRelevance()));
        return c;
    }

    private CompletableFuture<Void> collectCandidatesAsync(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg ccp) {
        this.mdcColInfo(index, ccp);
        String lang = StringUtils.isBlank((CharSequence)ccp.getColumnLabel().getLanguage()) ? this.currentReqCtx.locale.getLanguage() : ccp.getColumnLabel().getLanguage();
        PhraseInfo columnLabel = (PhraseInfo)ccp.getColumnLabel().getPhrases().get(0);
        CompletableFuture<Map<String, List<ClueHit>>> hitsF = SemanticAnalysisHelper.collectHitsAsync(lang, columnLabel, this.currentReqCtx, this.mOntologies);
        CompletionStage ret = hitsF.thenAccept(hits -> {
            HashMap<String, List<ClueHit>> groups = new HashMap<String, List<ClueHit>>();
            groups.putAll((Map<String, List<ClueHit>>)hits);
            this.collectCandidates(ccp, columnLabel, groups);
        });
        return ret;
    }
}

