/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.ontology.util.TNode;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Hierarchy;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SemanticInfo;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public class Ensemble
extends AbstractSmartsModuleClassificationStep {
    protected Ensemble(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    public void execute(SmartsModuleClassificationPkg pkg) {
        pkg.getDatasetClassificationPkgs().forEach(dp -> {
            dp.getInScopeColumnClassificationPkgs().forEach(cp -> {
                SemanticInfo si = cp.getColumnInfo().getSemanticInfo();
                si.setDefaultAggregation(cp.getDefaultAggregation());
                si.setUsage(cp.getUsage());
                cp.getColumnInfo().setDefaultAggregation(cp.getDefaultAggregation());
                cp.getColumnInfo().setUsage(cp.getUsage());
            });
            if (!dp.getGroups().isEmpty()) {
                dp.getDataset().getLogicalGroups().clear();
                dp.getGroups().stream().forEach(g -> {
                    Optional<Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>> idMember;
                    if (g.getGroupKey().isPresent() && (idMember = this.getGroupIDOrDetailMember((SmartsModuleClassificationPkg.LogicalGroup)g, false)).isPresent()) {
                        LogicalGroup lg = new LogicalGroup();
                        ConceptInfo keyConcept = this.createConceptInfo(g.getGroupKey().get());
                        lg.setConcept(keyConcept);
                        lg.setId(Integer.toString(g.getGroupId()));
                        lg.getMember().add(this.buildGroupMember(idMember.get()));
                        g.getGroupMembers().stream().forEach(m -> {
                            if (((Optional)m.getFirst()).isPresent() && !((SmartsModuleClassificationPkg.ColumnClassificationPkg)m.getSecond()).getColumnInfo().getId().equals(((SmartsModuleClassificationPkg.ColumnClassificationPkg)((Pair)idMember.get()).getSecond()).getColumnInfo().getId())) {
                                LogicalGroup.Member member = this.buildGroupMember((Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>)m);
                                lg.getMember().add(member);
                            }
                        });
                        dp.getDataset().getLogicalGroups().add(lg);
                    }
                });
            }
            if (!dp.getHierarchies().isEmpty()) {
                dp.getDataset().getHierarchies().clear();
                dp.getHierarchies().stream().forEach(h -> {
                    ArrayDeque<SmartsModuleClassificationPkg.LogicalGroup> stack = new ArrayDeque<SmartsModuleClassificationPkg.LogicalGroup>();
                    this.buildLevelStack((Deque<SmartsModuleClassificationPkg.LogicalGroup>)stack, (TNode<SmartsModuleClassificationPkg.LogicalGroup>)h, dp.getDataset().getHierarchies());
                });
            }
        });
    }

    private LogicalGroup.Member buildGroupMember(Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg> m) {
        ConceptInfo attrConcept = this.createConceptInfo(m.getFirst().get());
        LogicalGroup.Member member = new LogicalGroup.Member();
        member.setAttribute(attrConcept);
        member.setColumnId(m.getSecond().getColumnInfo().getId());
        member.setIdForExpression(m.getSecond().getColumnInfo().getIdForExpression());
        member.setDatasetId(m.getSecond().getDatasetInfo().getId());
        return member;
    }

    private boolean buildLevelStack(Deque<SmartsModuleClassificationPkg.LogicalGroup> stack, TNode<SmartsModuleClassificationPkg.LogicalGroup> level, List<Hierarchy> hierarchies) {
        stack.push(level.getData());
        if (!level.getChildren().isEmpty()) {
            IntStream.range(0, level.getChildren().size()).forEach(i -> {
                if (this.buildLevelStack(stack, level.getChildren().get(i), hierarchies)) {
                    hierarchies.add(this.buildHierarchy(stack));
                    stack.pop();
                }
            });
            stack.pop();
            return false;
        }
        return true;
    }

    private Hierarchy buildHierarchy(Deque<SmartsModuleClassificationPkg.LogicalGroup> stack) {
        Hierarchy hierarchy = new Hierarchy();
        Iterator<SmartsModuleClassificationPkg.LogicalGroup> it = stack.descendingIterator();
        int levelNo = 1;
        while (it.hasNext()) {
            SmartsModuleClassificationPkg.LogicalGroup group = it.next();
            Hierarchy.Level level = new Hierarchy.Level();
            level.setGroupId(Integer.toString(group.getGroupId()));
            level.setLevelNo(Integer.toString(levelNo));
            ++levelNo;
            hierarchy.getLevel().add(level);
        }
        return hierarchy;
    }
}

