/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.MDC;

public class EntityResolution
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> m_ontologies = null;

    EntityResolution(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.m_ontologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        MDC.put((String)"DatasetID", (String)("[" + dsPkg.getDataset().getId() + "]"));
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return false;
        }
        boolean bModified = this.isExecParallel() ? IntStream.range(0, inScopeColPkgs.size()).parallel().mapToObj(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope())).reduce(Boolean::logicalOr).orElse(false).booleanValue() : IntStream.range(0, inScopeColPkgs.size()).mapToObj(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope())).reduce(Boolean::logicalOr).orElse(false).booleanValue();
        return bModified;
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope) {
        if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ModifiableProperty.NAME)) {
            this.mdcColInfo(index, columnPkg);
            return this.m_ontologies.stream().map(o -> this.resolveEntityCandidates(columnPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
        }
        return false;
    }

    private boolean resolveEntityCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        List entities = this.getEntities(columnPkg).collect(Collectors.toList());
        if (entities.size() <= 1) {
            return false;
        }
        LOGGER.info("Resolve entity candidate for {}", (Object)columnPkg.getColumnInfo().getId());
        Optional<SmartsModuleClassificationPkg.Candidate> entityWithHighestScore = entities.stream().filter(e -> e.getConceptID().equals((Object)IRI.create((String)"http://www.w3.org/2002/07/owl#Thing"))).findFirst();
        if (!entityWithHighestScore.isPresent()) {
            entities.sort(this.getCandidateComparator(factory, reasoner, Optional.empty()));
            entityWithHighestScore = Optional.of(entities.get(entities.size() - 1));
        }
        SmartsModuleClassificationPkg.Candidate bestEntity = entityWithHighestScore.get();
        return columnPkg.getCandidates().stream().filter(c -> columnPkg.getEntityCandidates((SmartsModuleClassificationPkg.Candidate)c).size() > 1).map(c -> this.updateEntities((SmartsModuleClassificationPkg.Candidate)c, bestEntity, columnPkg)).reduce(Boolean::logicalOr).orElse(false);
    }

    private Map<SmartsModuleClassificationPkg.Candidate, Long> getEntityWeight(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        Map<SmartsModuleClassificationPkg.Candidate, Long> weights = columnPkg.getCandidates().stream().map(columnPkg::getEntityCandidates).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        weights.keySet().stream().forEach(key -> weights.computeIfPresent((SmartsModuleClassificationPkg.Candidate)key, (k, v) -> v + 10L));
        return weights;
    }

    private boolean updateEntities(SmartsModuleClassificationPkg.Candidate candidate, SmartsModuleClassificationPkg.Candidate entityWithHighestScore, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        Set<SmartsModuleClassificationPkg.Candidate> candidateEntities = columnPkg.getEntityCandidates(candidate);
        if (candidateEntities.size() > 1 || !candidateEntities.contains(entityWithHighestScore)) {
            candidateEntities.clear();
            candidateEntities.add(entityWithHighestScore);
            return true;
        }
        return false;
    }

    private boolean updateEntitiesFromContext(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg, Ontology<OWLOntology> ontology) {
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        Map<SmartsModuleClassificationPkg.Candidate, Long> weights = dsPkg.getColumnClassificationPkgs().stream().map(this::getEntityWeight).flatMap(m -> m.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue)));
        ArrayList modifiedFlag = new ArrayList();
        IntStream.range(0, dsPkg.getColumnClassificationPkgs().size()).forEach(i -> {
            SmartsModuleClassificationPkg.ColumnClassificationPkg iColumn = dsPkg.getColumnClassificationPkgs().get(i);
            if (iColumn.getCandidates().stream().flatMap(c -> iColumn.getEntityCandidates((SmartsModuleClassificationPkg.Candidate)c).stream()).anyMatch(e -> e.getConceptID().equals((Object)ENTITY_ROOT_IRI))) {
                ArrayList<SmartsModuleClassificationPkg.Candidate> potentialEntities = new ArrayList<SmartsModuleClassificationPkg.Candidate>();
                IntStream.range(i + 1, dsPkg.getColumnClassificationPkgs().size()).forEach(j -> {
                    SmartsModuleClassificationPkg.ColumnClassificationPkg jColumn = dsPkg.getColumnClassificationPkgs().get(j);
                    Stream jEntities = jColumn.getCandidates().stream().flatMap(c -> jColumn.getEntityCandidates((SmartsModuleClassificationPkg.Candidate)c).stream());
                    potentialEntities.addAll(jEntities.filter(e -> !e.getConceptID().equals((Object)ENTITY_ROOT_IRI)).collect(Collectors.toSet()));
                });
                if (!potentialEntities.isEmpty()) {
                    potentialEntities.sort(this.getCandidateComparator(factory, reasoner, Optional.of(weights)));
                    iColumn.getCandidates().forEach(c -> {
                        Set<SmartsModuleClassificationPkg.Candidate> iEntities = iColumn.getEntityCandidates((SmartsModuleClassificationPkg.Candidate)c);
                        if (!iEntities.isEmpty() && iEntities.stream().anyMatch(e -> e.getConceptID().equals((Object)ENTITY_ROOT_IRI))) {
                            iEntities.clear();
                            iEntities.add((SmartsModuleClassificationPkg.Candidate)potentialEntities.get(potentialEntities.size() - 1));
                            modifiedFlag.add(Boolean.TRUE);
                        }
                    });
                }
            }
        });
        return !modifiedFlag.isEmpty();
    }

    private Comparator<SmartsModuleClassificationPkg.Candidate> getCandidateComparator(OWLDataFactory factory, OWLReasoner reasoner, Optional<Map<SmartsModuleClassificationPkg.Candidate, Long>> weights) {
        return (e1, e2) -> {
            int result = Float.compare(e1.getRelevance(), e2.getRelevance());
            if (result == 0) {
                OWLClass e1Class = factory.getOWLClass(e1.getConceptID());
                OWLClass e2Class = factory.getOWLClass(e2.getConceptID());
                if (reasoner.getSuperClasses((OWLClassExpression)e1Class, false).containsEntity((OWLObject)e2Class)) {
                    result = 1;
                } else if (reasoner.getSuperClasses((OWLClassExpression)e2Class, false).containsEntity((OWLObject)e1Class)) {
                    result = -1;
                } else if (weights.isPresent()) {
                    Long e1Weight = (Long)((Map)weights.get()).get(e1);
                    e1Weight = e1Weight != null ? e1Weight : 0L;
                    Long e2Weight = (Long)((Map)weights.get()).get(e2);
                    e2Weight = e2Weight != null ? e2Weight : 0L;
                    result = Long.compare(e1Weight, e2Weight);
                }
            }
            return result;
        };
    }
}

